/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.core.ExecutorProvider;
import com.google.cloud.spanner.AbstractReadContext;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.SessionImpl;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.spi.v1.SpannerRpc;
import com.google.common.truth.Truth;
import com.google.spanner.v1.ExecuteBatchDmlRequest;
import com.google.spanner.v1.ExecuteSqlRequest;
import com.google.spanner.v1.RequestOptions;
import com.google.spanner.v1.TransactionSelector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class AbstractReadContextTest {
    @Parameterized.Parameter(value=0)
    public ExecuteSqlRequest.QueryOptions defaultQueryOptions;
    private TestReadContext context;

    @Parameterized.Parameters(name="SpannerOptions.DefaultQueryOptions = {0}")
    public static Collection<Object[]> parameters() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        params.add(new Object[]{ExecuteSqlRequest.QueryOptions.getDefaultInstance()});
        params.add(new Object[]{ExecuteSqlRequest.QueryOptions.newBuilder().setOptimizerVersion("some-version").setOptimizerStatisticsPackage("some-package").build()});
        return params;
    }

    @Before
    public void setup() {
        SessionImpl session = (SessionImpl)Mockito.mock(SessionImpl.class);
        Mockito.when((Object)session.getName()).thenReturn((Object)"session-1");
        TestReadContextBuilder builder = new TestReadContextBuilder();
        this.context = ((TestReadContextBuilder)((TestReadContextBuilder)((TestReadContextBuilder)((TestReadContextBuilder)builder.setSession(session)).setRpc((SpannerRpc)Mockito.mock(SpannerRpc.class))).setDefaultQueryOptions(this.defaultQueryOptions)).setExecutorProvider((ExecutorProvider)Mockito.mock(ExecutorProvider.class))).build();
    }

    @Test
    public void executeSqlRequestBuilderWithoutQueryOptions() {
        ExecuteSqlRequest request = this.context.getExecuteSqlRequestBuilder(Statement.of((String)"SELECT FOO FROM BAR"), ExecuteSqlRequest.QueryMode.NORMAL, Options.fromQueryOptions((Options.QueryOption[])new Options.QueryOption[0]), true).build();
        Truth.assertThat((String)request.getSql()).isEqualTo((Object)"SELECT FOO FROM BAR");
        Truth.assertThat((Object)request.getQueryOptions()).isEqualTo((Object)this.defaultQueryOptions);
    }

    @Test
    public void executeSqlRequestBuilderWithQueryOptions() {
        ExecuteSqlRequest request = this.context.getExecuteSqlRequestBuilder(Statement.newBuilder((String)"SELECT FOO FROM BAR").withQueryOptions(ExecuteSqlRequest.QueryOptions.newBuilder().setOptimizerVersion("2.0").setOptimizerStatisticsPackage("custom-package").build()).build(), ExecuteSqlRequest.QueryMode.NORMAL, Options.fromQueryOptions((Options.QueryOption[])new Options.QueryOption[0]), true).build();
        Truth.assertThat((String)request.getSql()).isEqualTo((Object)"SELECT FOO FROM BAR");
        Truth.assertThat((String)request.getQueryOptions().getOptimizerVersion()).isEqualTo((Object)"2.0");
        Truth.assertThat((String)request.getQueryOptions().getOptimizerStatisticsPackage()).isEqualTo((Object)"custom-package");
    }

    @Test
    public void testBuildRequestOptions() {
        RequestOptions requestOptions = this.context.buildRequestOptions(Options.fromQueryOptions((Options.QueryOption[])new Options.QueryOption[0]));
        Assert.assertEquals((Object)RequestOptions.Priority.PRIORITY_UNSPECIFIED, (Object)requestOptions.getPriority());
    }

    @Test
    public void testBuildRequestOptionsWithPriority() {
        RequestOptions requestOptionsHighPriority = this.context.buildRequestOptions(Options.fromQueryOptions((Options.QueryOption[])new Options.QueryOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.HIGH)}));
        Assert.assertEquals((Object)RequestOptions.Priority.PRIORITY_HIGH, (Object)requestOptionsHighPriority.getPriority());
        RequestOptions requestOptionsMediumPriority = this.context.buildRequestOptions(Options.fromQueryOptions((Options.QueryOption[])new Options.QueryOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.MEDIUM)}));
        Assert.assertEquals((Object)RequestOptions.Priority.PRIORITY_MEDIUM, (Object)requestOptionsMediumPriority.getPriority());
        RequestOptions requestOptionsLowPriority = this.context.buildRequestOptions(Options.fromQueryOptions((Options.QueryOption[])new Options.QueryOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.LOW)}));
        Assert.assertEquals((Object)RequestOptions.Priority.PRIORITY_LOW, (Object)requestOptionsLowPriority.getPriority());
    }

    @Test
    public void testGetExecuteSqlRequestBuilderWithPriority() {
        ExecuteSqlRequest.Builder request = this.context.getExecuteSqlRequestBuilder(Statement.of((String)"SELECT * FROM FOO"), ExecuteSqlRequest.QueryMode.NORMAL, Options.fromQueryOptions((Options.QueryOption[])new Options.QueryOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.MEDIUM)}), false);
        Assert.assertEquals((Object)RequestOptions.Priority.PRIORITY_MEDIUM, (Object)request.getRequestOptions().getPriority());
    }

    @Test
    public void testGetExecuteSqlRequestBuilderWithDataBoost() {
        ExecuteSqlRequest.Builder request = this.context.getExecuteSqlRequestBuilder(Statement.of((String)"SELECT * FROM FOO"), ExecuteSqlRequest.QueryMode.NORMAL, Options.fromQueryOptions((Options.QueryOption[])new Options.QueryOption[]{Options.dataBoostEnabled((Boolean)true)}), false);
        Assert.assertTrue((boolean)request.getDataBoostEnabled());
    }

    @Test
    public void testGetExecuteBatchDmlRequestBuilderWithPriority() {
        ExecuteBatchDmlRequest.Builder request = this.context.getExecuteBatchDmlRequestBuilder(Collections.singleton(Statement.of((String)"SELECT * FROM FOO")), Options.fromQueryOptions((Options.QueryOption[])new Options.QueryOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.LOW)}));
        Assert.assertEquals((Object)RequestOptions.Priority.PRIORITY_LOW, (Object)request.getRequestOptions().getPriority());
    }

    public void executeSqlRequestBuilderWithRequestOptions() {
        ExecuteSqlRequest request = this.context.getExecuteSqlRequestBuilder(Statement.newBuilder((String)"SELECT FOO FROM BAR").build(), ExecuteSqlRequest.QueryMode.NORMAL, Options.fromUpdateOptions((Options.UpdateOption[])new Options.UpdateOption[]{Options.tag((String)"app=spanner,env=test,action=query")}), false).build();
        Truth.assertThat((String)request.getSql()).isEqualTo((Object)"SELECT FOO FROM BAR");
        Truth.assertThat((String)request.getRequestOptions().getRequestTag()).isEqualTo((Object)"app=spanner,env=test,action=query");
        Truth.assertThat((String)request.getRequestOptions().getTransactionTag()).isEmpty();
    }

    @Test
    public void executeSqlRequestBuilderWithRequestOptionsWithTxnTag() {
        SessionImpl session = (SessionImpl)Mockito.mock(SessionImpl.class);
        Mockito.when((Object)session.getName()).thenReturn((Object)"session-1");
        TestReadContextWithTagBuilder builder = new TestReadContextWithTagBuilder();
        TestReadContextWithTag contextWithTag = ((TestReadContextWithTagBuilder)((TestReadContextWithTagBuilder)((TestReadContextWithTagBuilder)((TestReadContextWithTagBuilder)builder.setSession(session)).setRpc((SpannerRpc)Mockito.mock(SpannerRpc.class))).setDefaultQueryOptions(this.defaultQueryOptions)).setExecutorProvider((ExecutorProvider)Mockito.mock(ExecutorProvider.class))).build();
        ExecuteSqlRequest request = contextWithTag.getExecuteSqlRequestBuilder(Statement.newBuilder((String)"SELECT FOO FROM BAR").build(), ExecuteSqlRequest.QueryMode.NORMAL, Options.fromUpdateOptions((Options.UpdateOption[])new Options.UpdateOption[]{Options.tag((String)"app=spanner,env=test,action=query")}), false).build();
        Truth.assertThat((String)request.getSql()).isEqualTo((Object)"SELECT FOO FROM BAR");
        Truth.assertThat((String)request.getRequestOptions().getRequestTag()).isEqualTo((Object)"app=spanner,env=test,action=query");
        Truth.assertThat((String)request.getRequestOptions().getTransactionTag()).isEqualTo((Object)"app=spanner,env=test");
    }

    class TestReadContextBuilder
    extends AbstractReadContext.Builder<TestReadContextBuilder, TestReadContext> {
        TestReadContextBuilder() {
        }

        TestReadContext build() {
            return new TestReadContext(this);
        }
    }

    private final class TestReadContext
    extends AbstractReadContext {
        TestReadContext(TestReadContextBuilder builder) {
            super((AbstractReadContext.Builder)builder);
        }

        TransactionSelector getTransactionSelector() {
            return TransactionSelector.getDefaultInstance();
        }
    }

    class TestReadContextWithTagBuilder
    extends AbstractReadContext.Builder<TestReadContextWithTagBuilder, TestReadContextWithTag> {
        TestReadContextWithTagBuilder() {
        }

        TestReadContextWithTag build() {
            return new TestReadContextWithTag(this);
        }
    }

    private final class TestReadContextWithTag
    extends AbstractReadContext {
        TestReadContextWithTag(TestReadContextWithTagBuilder builder) {
            super((AbstractReadContext.Builder)builder);
        }

        TransactionSelector getTransactionSelector() {
            return TransactionSelector.getDefaultInstance();
        }

        String getTransactionTag() {
            return "app=spanner,env=test";
        }
    }
}

