/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.spanner.Dialect;
import com.google.spanner.admin.database.v1.DatabaseDialect;
import org.junit.Assert;
import org.junit.Test;

public class DialectTest {
    @Test
    public void testCreateDatabaseStatementForGoogleStandardSQLDialect() {
        Assert.assertEquals((Object)"CREATE DATABASE `my-database`", (Object)Dialect.GOOGLE_STANDARD_SQL.createDatabaseStatementFor("my-database"));
    }

    @Test
    public void testCreateDatabaseStatementForPostgreSQLDialect() {
        Assert.assertEquals((Object)"CREATE DATABASE \"my-database\"", (Object)Dialect.POSTGRESQL.createDatabaseStatementFor("my-database"));
    }

    @Test
    public void testGoogleStandardSQLDialectToProto() {
        Assert.assertEquals((Object)DatabaseDialect.GOOGLE_STANDARD_SQL, (Object)Dialect.GOOGLE_STANDARD_SQL.toProto());
    }

    @Test
    public void testPostgreSQLToProto() {
        Assert.assertEquals((Object)DatabaseDialect.POSTGRESQL, (Object)Dialect.POSTGRESQL.toProto());
    }

    @Test
    public void testFromGoogleStandardSQLDialectProto() {
        Assert.assertEquals((Object)Dialect.GOOGLE_STANDARD_SQL, (Object)Dialect.fromProto((DatabaseDialect)DatabaseDialect.GOOGLE_STANDARD_SQL));
    }

    @Test
    public void testFromUnspecifiedDialectProto() {
        Assert.assertEquals((Object)Dialect.GOOGLE_STANDARD_SQL, (Object)Dialect.fromProto((DatabaseDialect)DatabaseDialect.DATABASE_DIALECT_UNSPECIFIED));
    }

    @Test
    public void testFromPostgreSQLDialectProto() {
        Assert.assertEquals((Object)Dialect.POSTGRESQL, (Object)Dialect.fromProto((DatabaseDialect)DatabaseDialect.POSTGRESQL));
    }

    @Test
    public void testFromUnrecognizedDialectProto() {
        Assert.assertThrows(IllegalArgumentException.class, () -> Dialect.fromProto((DatabaseDialect)DatabaseDialect.UNRECOGNIZED));
    }

    @Test
    public void testFromNullDialectProto() {
        Assert.assertThrows(IllegalArgumentException.class, () -> Dialect.fromProto((DatabaseDialect)DatabaseDialect.UNRECOGNIZED));
    }

    @Test
    public void testFromGoogleStandardSQLDialectName() {
        Assert.assertEquals((Object)Dialect.GOOGLE_STANDARD_SQL, (Object)Dialect.fromName((String)"GOOGLE_STANDARD_SQL"));
    }

    @Test
    public void testFromPostgreSQLDialectName() {
        Assert.assertEquals((Object)Dialect.POSTGRESQL, (Object)Dialect.fromName((String)"POSTGRESQL"));
    }

    @Test
    public void testFromInvalidDialectName() {
        Assert.assertThrows(IllegalArgumentException.class, () -> Dialect.fromName((String)"INVALID"));
    }
}

