/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.Identity;
import com.google.cloud.Policy;
import com.google.cloud.Role;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.DatabaseAdminClient;
import com.google.cloud.spanner.Instance;
import com.google.cloud.spanner.InstanceAdminClient;
import com.google.cloud.spanner.InstanceConfigId;
import com.google.cloud.spanner.InstanceId;
import com.google.cloud.spanner.InstanceInfo;
import com.google.cloud.spanner.Options;
import com.google.common.testing.EqualsTester;
import com.google.common.truth.Truth;
import com.google.spanner.admin.instance.v1.AutoscalingConfig;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@RunWith(value=JUnit4.class)
public class InstanceTest {
    @Mock
    InstanceAdminClient instanceClient;
    @Mock
    DatabaseAdminClient dbClient;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void buildInstance() {
        InstanceId id = new InstanceId("test-project", "test-instance");
        InstanceConfigId configId = new InstanceConfigId("test-project", "test-instance-config");
        AutoscalingConfig autoscalingConfig = AutoscalingConfig.newBuilder().setAutoscalingLimits(AutoscalingConfig.AutoscalingLimits.newBuilder().setMinProcessingUnits(1000).setMaxProcessingUnits(5000)).setAutoscalingTargets(AutoscalingConfig.AutoscalingTargets.newBuilder().setHighPriorityCpuUtilizationPercent(65).setStorageUtilizationPercent(95)).build();
        Instance instance = new Instance.Builder(this.instanceClient, this.dbClient, id).setInstanceConfigId(configId).setDisplayName("test instance").setNodeCount(1).setProcessingUnits(2000).setAutoscalingConfig(autoscalingConfig).setState(InstanceInfo.State.READY).addLabel("env", "prod").addLabel("region", "us").setUpdateTime(Timestamp.ofTimeMicroseconds((long)86000L)).setCreateTime(Timestamp.ofTimeMicroseconds((long)46000L)).build();
        Truth.assertThat((Object)instance.getId()).isEqualTo((Object)id);
        Truth.assertThat((Object)instance.getInstanceConfigId()).isEqualTo((Object)configId);
        Truth.assertThat((String)instance.getDisplayName()).isEqualTo((Object)"test instance");
        Truth.assertThat((Integer)instance.getNodeCount()).isEqualTo((Object)1);
        Truth.assertThat((Integer)instance.getProcessingUnits()).isEqualTo((Object)2000);
        Truth.assertThat((Object)instance.getAutoscalingConfig()).isEqualTo((Object)autoscalingConfig);
        Truth.assertThat((Comparable)instance.getState()).isEqualTo((Object)InstanceInfo.State.READY);
        Truth.assertThat((Map)instance.getLabels()).containsExactly((Object)"env", (Object)"prod", new Object[]{"region", "us"});
        Assert.assertEquals((Object)Timestamp.ofTimeMicroseconds((long)86000L), (Object)instance.getUpdateTime());
        Assert.assertEquals((Object)Timestamp.ofTimeMicroseconds((long)46000L), (Object)instance.getCreateTime());
        AutoscalingConfig newAutoscalingConfig = autoscalingConfig.toBuilder().setAutoscalingLimits(AutoscalingConfig.AutoscalingLimits.newBuilder().setMinNodes(10).setMaxNodes(100)).build();
        instance = instance.toBuilder().setDisplayName("new test instance").setAutoscalingConfig(newAutoscalingConfig).build();
        Truth.assertThat((Object)instance.getId()).isEqualTo((Object)id);
        Truth.assertThat((Object)instance.getInstanceConfigId()).isEqualTo((Object)configId);
        Truth.assertThat((String)instance.getDisplayName()).isEqualTo((Object)"new test instance");
        Truth.assertThat((Integer)instance.getNodeCount()).isEqualTo((Object)1);
        Truth.assertThat((Integer)instance.getProcessingUnits()).isEqualTo((Object)2000);
        Truth.assertThat((Object)instance.getAutoscalingConfig()).isEqualTo((Object)newAutoscalingConfig);
        Truth.assertThat((Comparable)instance.getState()).isEqualTo((Object)InstanceInfo.State.READY);
        Truth.assertThat((Map)instance.getLabels()).containsExactly((Object)"env", (Object)"prod", new Object[]{"region", "us"});
        Assert.assertEquals((Object)Timestamp.ofTimeMicroseconds((long)86000L), (Object)instance.getUpdateTime());
        Assert.assertEquals((Object)Timestamp.ofTimeMicroseconds((long)46000L), (Object)instance.getCreateTime());
    }

    @Test
    public void equality() {
        InstanceId id = new InstanceId("test-project", "test-instance");
        InstanceConfigId configId = new InstanceConfigId("test-project", "test-instance-config");
        Instance instance = new Instance.Builder(this.instanceClient, this.dbClient, id).setInstanceConfigId(configId).setDisplayName("test instance").setNodeCount(1).setProcessingUnits(2000).setState(InstanceInfo.State.READY).addLabel("env", "prod").addLabel("region", "us").setUpdateTime(Timestamp.ofTimeMicroseconds((long)86000L)).setCreateTime(Timestamp.ofTimeMicroseconds((long)46000L)).build();
        Instance instance2 = new Instance.Builder(this.instanceClient, this.dbClient, id).setInstanceConfigId(configId).setDisplayName("test instance").setNodeCount(1).setProcessingUnits(2000).setState(InstanceInfo.State.READY).addLabel("region", "us").addLabel("env", "prod").setUpdateTime(Timestamp.ofTimeMicroseconds((long)86000L)).setCreateTime(Timestamp.ofTimeMicroseconds((long)46000L)).build();
        Instance instance3 = new Instance.Builder(this.instanceClient, this.dbClient, id).setInstanceConfigId(configId).setDisplayName("test instance").setNodeCount(1).setProcessingUnits(2000).setState(InstanceInfo.State.READY).addLabel("env", "prod").setUpdateTime(Timestamp.ofTimeMicroseconds((long)8000L)).setCreateTime(Timestamp.ofTimeMicroseconds((long)4000L)).build();
        EqualsTester tester = new EqualsTester();
        tester.addEqualityGroup(new Object[]{instance, instance2});
        tester.addEqualityGroup(new Object[]{instance3});
        tester.testEquals();
    }

    @Test
    public void equalityWithAutoscalingConfig() {
        InstanceId id = new InstanceId("test-project", "test-instance");
        InstanceConfigId configId = new InstanceConfigId("test-project", "test-instance-config");
        AutoscalingConfig autoscalingConfig1 = AutoscalingConfig.newBuilder().setAutoscalingLimits(AutoscalingConfig.AutoscalingLimits.newBuilder().setMinProcessingUnits(1000).setMaxProcessingUnits(5000)).setAutoscalingTargets(AutoscalingConfig.AutoscalingTargets.newBuilder().setHighPriorityCpuUtilizationPercent(65).setStorageUtilizationPercent(95)).build();
        AutoscalingConfig autoscalingConfig2 = autoscalingConfig1.toBuilder().setAutoscalingLimits(autoscalingConfig1.getAutoscalingLimits().toBuilder().setMinNodes(50).setMaxNodes(100)).build();
        Instance instance = new Instance.Builder(this.instanceClient, this.dbClient, id).setInstanceConfigId(configId).setDisplayName("test instance").setNodeCount(1).setProcessingUnits(2000).setAutoscalingConfig(autoscalingConfig1).setState(InstanceInfo.State.READY).addLabel("env", "prod").addLabel("region", "us").setUpdateTime(Timestamp.ofTimeMicroseconds((long)86000L)).setCreateTime(Timestamp.ofTimeMicroseconds((long)46000L)).build();
        Instance instance2 = new Instance.Builder(this.instanceClient, this.dbClient, id).setInstanceConfigId(configId).setDisplayName("test instance").setNodeCount(1).setProcessingUnits(2000).setAutoscalingConfig(autoscalingConfig1).setState(InstanceInfo.State.READY).addLabel("region", "us").addLabel("env", "prod").setUpdateTime(Timestamp.ofTimeMicroseconds((long)86000L)).setCreateTime(Timestamp.ofTimeMicroseconds((long)46000L)).build();
        Instance instance3 = new Instance.Builder(this.instanceClient, this.dbClient, id).setInstanceConfigId(configId).setDisplayName("test instance").setNodeCount(1).setProcessingUnits(2000).setAutoscalingConfig(autoscalingConfig1).setState(InstanceInfo.State.READY).addLabel("env", "prod").setUpdateTime(Timestamp.ofTimeMicroseconds((long)8000L)).setCreateTime(Timestamp.ofTimeMicroseconds((long)4000L)).build();
        Instance instance4 = new Instance.Builder(this.instanceClient, this.dbClient, id).setInstanceConfigId(configId).setDisplayName("test instance").setNodeCount(1).setProcessingUnits(2000).setAutoscalingConfig(autoscalingConfig2).setState(InstanceInfo.State.READY).addLabel("region", "us").addLabel("env", "prod").setUpdateTime(Timestamp.ofTimeMicroseconds((long)86000L)).setCreateTime(Timestamp.ofTimeMicroseconds((long)46000L)).build();
        EqualsTester tester = new EqualsTester();
        tester.addEqualityGroup(new Object[]{instance, instance2});
        tester.addEqualityGroup(new Object[]{instance3});
        tester.addEqualityGroup(new Object[]{instance4});
        tester.testEquals();
    }

    @Test
    public void listDatabases() {
        InstanceId id = new InstanceId("test-project", "test-instance");
        Instance instance = new Instance.Builder(this.instanceClient, this.dbClient, id).build();
        instance.listDatabases(new Options.ListOption[0]);
        ((DatabaseAdminClient)Mockito.verify((Object)this.dbClient)).listDatabases("test-instance", new Options.ListOption[0]);
    }

    @Test
    public void listBackups() {
        InstanceId id = new InstanceId("test-project", "test-instance");
        Instance instance = new Instance.Builder(this.instanceClient, this.dbClient, id).build();
        instance.listBackups(new Options.ListOption[0]);
        ((DatabaseAdminClient)Mockito.verify((Object)this.dbClient)).listBackups("test-instance", new Options.ListOption[0]);
    }

    @Test
    public void listDatabaseOperations() {
        InstanceId id = new InstanceId("test-project", "test-instance");
        Instance instance = new Instance.Builder(this.instanceClient, this.dbClient, id).build();
        instance.listDatabaseOperations(new Options.ListOption[0]);
        ((DatabaseAdminClient)Mockito.verify((Object)this.dbClient)).listDatabaseOperations("test-instance", new Options.ListOption[0]);
    }

    @Test
    public void listBackupOperations() {
        InstanceId id = new InstanceId("test-project", "test-instance");
        Instance instance = new Instance.Builder(this.instanceClient, this.dbClient, id).build();
        instance.listBackupOperations(new Options.ListOption[0]);
        ((DatabaseAdminClient)Mockito.verify((Object)this.dbClient)).listBackupOperations("test-instance", new Options.ListOption[0]);
    }

    @Test
    public void getIAMPolicy() {
        InstanceId id = new InstanceId("test-project", "test-instance");
        Instance instance = new Instance.Builder(this.instanceClient, this.dbClient, id).build();
        instance.getIAMPolicy();
        ((InstanceAdminClient)Mockito.verify((Object)this.instanceClient)).getInstanceIAMPolicy("test-instance");
    }

    @Test
    public void setIAMPolicy() {
        InstanceId id = new InstanceId("test-project", "test-instance");
        Instance instance = new Instance.Builder(this.instanceClient, this.dbClient, id).build();
        Policy policy = Policy.newBuilder().addIdentity(Role.viewer(), Identity.user((String)"joe@example.com"), new Identity[0]).build();
        instance.setIAMPolicy(policy);
        ((InstanceAdminClient)Mockito.verify((Object)this.instanceClient)).setInstanceIAMPolicy("test-instance", policy);
    }

    @Test
    public void testIAMPermissions() {
        InstanceId id = new InstanceId("test-project", "test-instance");
        Instance instance = new Instance.Builder(this.instanceClient, this.dbClient, id).build();
        List<String> permissions = Collections.singletonList("read");
        instance.testIAMPermissions(permissions);
        ((InstanceAdminClient)Mockito.verify((Object)this.instanceClient)).testInstanceIAMPermissions("test-instance", permissions);
    }
}

