/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseClientImpl;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SessionPool;
import com.google.cloud.spanner.SessionPoolOptions;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TransactionManager;
import com.google.protobuf.ListValue;
import com.google.protobuf.Value;
import com.google.spanner.v1.ResultSetMetadata;
import com.google.spanner.v1.StructType;
import com.google.spanner.v1.Type;
import com.google.spanner.v1.TypeCode;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.inprocess.InProcessServerBuilder;
import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SessionPoolLeakTest {
    private static final StatusRuntimeException FAILED_PRECONDITION = Status.FAILED_PRECONDITION.withDescription("Non-retryable test exception.").asRuntimeException();
    private static MockSpannerServiceImpl mockSpanner;
    private static Server server;
    private static LocalChannelProvider channelProvider;
    private Spanner spanner;
    private DatabaseClient client;
    private SessionPool pool;

    @BeforeClass
    public static void startStaticServer() throws IOException {
        mockSpanner = new MockSpannerServiceImpl();
        mockSpanner.setAbortProbability(0.0);
        String uniqueName = InProcessServerBuilder.generateName();
        server = ((InProcessServerBuilder)InProcessServerBuilder.forName((String)uniqueName).scheduledExecutorService((ScheduledExecutorService)new ScheduledThreadPoolExecutor(1)).addService((BindableService)mockSpanner)).build().start();
        channelProvider = LocalChannelProvider.create((String)uniqueName);
    }

    @AfterClass
    public static void stopServer() throws InterruptedException {
        server.shutdown();
        server.awaitTermination();
    }

    @Before
    public void setUp() {
        mockSpanner.reset();
        mockSpanner.removeAllExecutionTimes();
        SpannerOptions.Builder builder = (SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("[PROJECT]")).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance());
        builder.setSessionPoolOption(SessionPoolOptions.newBuilder().setMinSessions(0).setMaxSessions(2).setIncStep(1).build());
        this.spanner = (Spanner)builder.build().getService();
        this.client = this.spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
        this.pool = ((DatabaseClientImpl)this.client).pool;
    }

    @After
    public void tearDown() {
        this.spanner.close();
    }

    @Test
    public void testIgnoreLeakedSession() {
        for (boolean trackStackTraceofSessionCheckout : new boolean[]{true, false}) {
            SpannerOptions.Builder builder = (SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("[PROJECT]")).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance());
            builder.setSessionPoolOption(SessionPoolOptions.newBuilder().setMinSessions(0).setMaxSessions(2).setIncStep(1).setFailOnSessionLeak().setTrackStackTraceOfSessionCheckout(trackStackTraceofSessionCheckout).build());
            Spanner spanner = (Spanner)builder.build().getService();
            DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]"));
            mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(Statement.of((String)"SELECT 1"), com.google.spanner.v1.ResultSet.newBuilder().setMetadata(ResultSetMetadata.newBuilder().setRowType(StructType.newBuilder().addFields(StructType.Field.newBuilder().setName("c").setType(Type.newBuilder().setCode(TypeCode.INT64).build()).build()).build()).build()).addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("1").build()).build()).build()));
            ReadOnlyTransaction transaction = client.readOnlyTransaction();
            try (ResultSet resultSet = transaction.executeQuery(Statement.of((String)"SELECT 1"), new Options.QueryOption[0]);){
                while (resultSet.next()) {
                }
            }
            SessionPool.LeakedSessionException exception = (SessionPool.LeakedSessionException)Assert.assertThrows(SessionPool.LeakedSessionException.class, () -> ((Spanner)spanner).close());
            Assert.assertEquals((Object)(trackStackTraceofSessionCheckout ? "markCheckedOut" : "closeAsync"), (Object)exception.getStackTrace()[0].getMethodName());
        }
    }

    @Test
    public void testReadWriteTransactionExceptionOnCreateSession() {
        this.readWriteTransactionTest(() -> mockSpanner.setBatchCreateSessionsExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)((Object)FAILED_PRECONDITION))), 0);
    }

    @Test
    public void testReadWriteTransactionExceptionOnBegin() {
        this.readWriteTransactionTest(() -> mockSpanner.setBeginTransactionExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)((Object)FAILED_PRECONDITION))), 1);
    }

    private void readWriteTransactionTest(Runnable setup, int expectedNumberOfSessionsAfterExecution) {
        Assert.assertEquals((long)0L, (long)this.pool.getNumberOfSessionsInPool());
        setup.run();
        SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> this.client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> null));
        Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)e.getErrorCode());
        Assert.assertEquals((long)expectedNumberOfSessionsAfterExecution, (long)this.pool.getNumberOfSessionsInPool());
    }

    @Test
    public void testTransactionManagerExceptionOnCreateSession() {
        this.transactionManagerTest(() -> mockSpanner.setBatchCreateSessionsExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)((Object)FAILED_PRECONDITION))), 0);
    }

    @Test
    public void testTransactionManagerExceptionOnBegin() {
        MatcherAssert.assertThat((Object)this.pool.getNumberOfSessionsInPool(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)0)));
        mockSpanner.setBeginTransactionExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)((Object)FAILED_PRECONDITION)));
        try (TransactionManager txManager = this.client.transactionManager(new Options.TransactionOption[0]);){
            txManager.begin();
        }
        MatcherAssert.assertThat((Object)this.pool.getNumberOfSessionsInPool(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1)));
    }

    private void transactionManagerTest(Runnable setup, int expectedNumberOfSessionsAfterExecution) {
        Assert.assertEquals((long)0L, (long)this.pool.getNumberOfSessionsInPool());
        setup.run();
        try (TransactionManager txManager = this.client.transactionManager(new Options.TransactionOption[0]);){
            SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> txManager.begin());
            Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)e.getErrorCode());
        }
        Assert.assertEquals((long)expectedNumberOfSessionsAfterExecution, (long)this.pool.getNumberOfSessionsInPool());
    }
}

