/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.spanner.SessionPool;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class SessionPoolUnbalancedTest {
    static SessionPool.PooledSession mockedSession(int channel) {
        SessionPool.PooledSession session = (SessionPool.PooledSession)Mockito.mock(SessionPool.PooledSession.class);
        Mockito.when((Object)session.getChannel()).thenReturn((Object)channel);
        return session;
    }

    static List<SessionPool.PooledSession> mockedSessions(int ... channels) {
        return Arrays.stream(channels).mapToObj(SessionPoolUnbalancedTest::mockedSession).collect(Collectors.toList());
    }

    static SessionPool.PooledSessionFuture mockedCheckedOutSession(int channel) {
        SessionPool.PooledSession session = SessionPoolUnbalancedTest.mockedSession(channel);
        SessionPool.PooledSessionFuture future = (SessionPool.PooledSessionFuture)Mockito.mock(SessionPool.PooledSessionFuture.class);
        Mockito.when((Object)future.get()).thenReturn((Object)session);
        Mockito.when((Object)future.isDone()).thenReturn((Object)true);
        return future;
    }

    static Set<SessionPool.PooledSessionFuture> mockedCheckedOutSessions(int ... channels) {
        return Arrays.stream(channels).mapToObj(SessionPoolUnbalancedTest::mockedCheckedOutSession).collect(Collectors.toSet());
    }

    @Test
    public void testIsUnbalancedBasics() {
        Assert.assertFalse((boolean)SessionPool.isUnbalanced((int)1, SessionPoolUnbalancedTest.mockedSessions(new int[0]), SessionPoolUnbalancedTest.mockedCheckedOutSessions(1, 1, 1), (int)1));
        Assert.assertFalse((boolean)SessionPool.isUnbalanced((int)1, SessionPoolUnbalancedTest.mockedSessions(new int[0]), SessionPoolUnbalancedTest.mockedCheckedOutSessions(1, 1, 1), (int)2));
        Assert.assertFalse((boolean)SessionPool.isUnbalanced((int)1, SessionPoolUnbalancedTest.mockedSessions(new int[0]), SessionPoolUnbalancedTest.mockedCheckedOutSessions(1, 1, 1), (int)4));
        Assert.assertFalse((boolean)SessionPool.isUnbalanced((int)1, SessionPoolUnbalancedTest.mockedSessions(new int[0]), SessionPoolUnbalancedTest.mockedCheckedOutSessions(1, 1, 1, 1), (int)1));
        Assert.assertFalse((boolean)SessionPool.isUnbalanced((int)1, SessionPoolUnbalancedTest.mockedSessions(new int[0]), SessionPoolUnbalancedTest.mockedCheckedOutSessions(1, 1, 1, 1), (int)2));
        Assert.assertFalse((boolean)SessionPool.isUnbalanced((int)1, SessionPoolUnbalancedTest.mockedSessions(new int[0]), SessionPoolUnbalancedTest.mockedCheckedOutSessions(1, 1, 1, 1), (int)4));
        Assert.assertFalse((boolean)SessionPool.isUnbalanced((int)1, SessionPoolUnbalancedTest.mockedSessions(new int[0]), SessionPoolUnbalancedTest.mockedCheckedOutSessions(1, 1, 1, 1, 1), (int)1));
        Assert.assertFalse((boolean)SessionPool.isUnbalanced((int)1, SessionPoolUnbalancedTest.mockedSessions(new int[0]), SessionPoolUnbalancedTest.mockedCheckedOutSessions(1, 1, 1, 1, 1), (int)2));
        Assert.assertFalse((boolean)SessionPool.isUnbalanced((int)1, SessionPoolUnbalancedTest.mockedSessions(new int[0]), SessionPoolUnbalancedTest.mockedCheckedOutSessions(1, 1, 1, 1, 1), (int)4));
        Assert.assertFalse((boolean)SessionPool.isUnbalanced((int)1, SessionPoolUnbalancedTest.mockedSessions(1, 1, 1), SessionPoolUnbalancedTest.mockedCheckedOutSessions(new int[0]), (int)1));
        Assert.assertFalse((boolean)SessionPool.isUnbalanced((int)1, SessionPoolUnbalancedTest.mockedSessions(1, 1, 1), SessionPoolUnbalancedTest.mockedCheckedOutSessions(new int[0]), (int)2));
        Assert.assertFalse((boolean)SessionPool.isUnbalanced((int)1, SessionPoolUnbalancedTest.mockedSessions(1, 1, 1), SessionPoolUnbalancedTest.mockedCheckedOutSessions(new int[0]), (int)4));
        Assert.assertFalse((boolean)SessionPool.isUnbalanced((int)1, SessionPoolUnbalancedTest.mockedSessions(1, 1, 1, 1), SessionPoolUnbalancedTest.mockedCheckedOutSessions(1), (int)1));
        Assert.assertFalse((boolean)SessionPool.isUnbalanced((int)1, SessionPoolUnbalancedTest.mockedSessions(1, 1, 1, 1), SessionPoolUnbalancedTest.mockedCheckedOutSessions(1), (int)2));
        Assert.assertFalse((boolean)SessionPool.isUnbalanced((int)1, SessionPoolUnbalancedTest.mockedSessions(1, 1, 1, 1), SessionPoolUnbalancedTest.mockedCheckedOutSessions(1), (int)4));
        Assert.assertFalse((boolean)SessionPool.isUnbalanced((int)1, SessionPoolUnbalancedTest.mockedSessions(1, 1, 1, 1, 1), SessionPoolUnbalancedTest.mockedCheckedOutSessions(1, 1), (int)1));
        Assert.assertFalse((boolean)SessionPool.isUnbalanced((int)1, SessionPoolUnbalancedTest.mockedSessions(1, 1, 1, 1, 1), SessionPoolUnbalancedTest.mockedCheckedOutSessions(1, 1), (int)2));
        Assert.assertFalse((boolean)SessionPool.isUnbalanced((int)1, SessionPoolUnbalancedTest.mockedSessions(1, 1, 1, 1, 1), SessionPoolUnbalancedTest.mockedCheckedOutSessions(1, 1), (int)4));
        Assert.assertFalse((boolean)SessionPool.isUnbalanced((int)1, SessionPoolUnbalancedTest.mockedSessions(1, 1, 1), SessionPoolUnbalancedTest.mockedCheckedOutSessions(new int[0]), (int)1));
        Assert.assertFalse((boolean)SessionPool.isUnbalanced((int)1, SessionPoolUnbalancedTest.mockedSessions(1, 1, 1, 1), SessionPoolUnbalancedTest.mockedCheckedOutSessions(new int[0]), (int)1));
        Assert.assertFalse((boolean)SessionPool.isUnbalanced((int)1, SessionPoolUnbalancedTest.mockedSessions(1, 1, 1, 1, 1), SessionPoolUnbalancedTest.mockedCheckedOutSessions(new int[0]), (int)1));
        Assert.assertFalse((boolean)SessionPool.isUnbalanced((int)1, SessionPoolUnbalancedTest.mockedSessions(1, 1, 1, 1, 1, 1), SessionPoolUnbalancedTest.mockedCheckedOutSessions(new int[0]), (int)1));
        Assert.assertFalse((boolean)SessionPool.isUnbalanced((int)1, SessionPoolUnbalancedTest.mockedSessions(1, 1, 1), SessionPoolUnbalancedTest.mockedCheckedOutSessions(1, 1, 1), (int)1));
        Assert.assertFalse((boolean)SessionPool.isUnbalanced((int)1, SessionPoolUnbalancedTest.mockedSessions(1, 1, 1, 1), SessionPoolUnbalancedTest.mockedCheckedOutSessions(1, 1, 1, 1), (int)1));
        Assert.assertFalse((boolean)SessionPool.isUnbalanced((int)1, SessionPoolUnbalancedTest.mockedSessions(1, 1, 1, 1, 1), SessionPoolUnbalancedTest.mockedCheckedOutSessions(1, 1, 1, 1, 1), (int)1));
        Assert.assertFalse((boolean)SessionPool.isUnbalanced((int)1, SessionPoolUnbalancedTest.mockedSessions(1, 1, 1, 1, 1, 1), SessionPoolUnbalancedTest.mockedCheckedOutSessions(1, 1, 1, 1, 1, 1), (int)1));
    }

    @Test
    public void testIsUnbalanced_returnsFalseForBalancedPool() {
        Assert.assertFalse((boolean)SessionPool.isUnbalanced((int)1, SessionPoolUnbalancedTest.mockedSessions(1, 2, 3, 4), SessionPoolUnbalancedTest.mockedCheckedOutSessions(1, 2, 3, 4), (int)4));
        Assert.assertFalse((boolean)SessionPool.isUnbalanced((int)2, SessionPoolUnbalancedTest.mockedSessions(1, 2, 3, 4), SessionPoolUnbalancedTest.mockedCheckedOutSessions(1, 2, 3, 4), (int)4));
        Assert.assertFalse((boolean)SessionPool.isUnbalanced((int)3, SessionPoolUnbalancedTest.mockedSessions(1, 2, 3, 4), SessionPoolUnbalancedTest.mockedCheckedOutSessions(1, 2, 3, 4), (int)4));
        Assert.assertFalse((boolean)SessionPool.isUnbalanced((int)4, SessionPoolUnbalancedTest.mockedSessions(1, 2, 3, 4), SessionPoolUnbalancedTest.mockedCheckedOutSessions(1, 2, 3, 4), (int)4));
        Assert.assertFalse((boolean)SessionPool.isUnbalanced((int)1, SessionPoolUnbalancedTest.mockedSessions(1, 2, 3, 4), SessionPoolUnbalancedTest.mockedCheckedOutSessions(4, 3, 2, 1), (int)4));
        Assert.assertFalse((boolean)SessionPool.isUnbalanced((int)2, SessionPoolUnbalancedTest.mockedSessions(1, 2, 3, 4), SessionPoolUnbalancedTest.mockedCheckedOutSessions(4, 3, 2, 1), (int)4));
        Assert.assertFalse((boolean)SessionPool.isUnbalanced((int)3, SessionPoolUnbalancedTest.mockedSessions(1, 2, 3, 4), SessionPoolUnbalancedTest.mockedCheckedOutSessions(4, 3, 2, 1), (int)4));
        Assert.assertFalse((boolean)SessionPool.isUnbalanced((int)4, SessionPoolUnbalancedTest.mockedSessions(1, 2, 3, 4), SessionPoolUnbalancedTest.mockedCheckedOutSessions(4, 3, 2, 1), (int)4));
        Assert.assertFalse((boolean)SessionPool.isUnbalanced((int)1, SessionPoolUnbalancedTest.mockedSessions(1, 2, 3, 4, 1, 2, 3, 4), SessionPoolUnbalancedTest.mockedCheckedOutSessions(1, 2, 3, 4, 1, 2, 3, 4), (int)4));
        Assert.assertFalse((boolean)SessionPool.isUnbalanced((int)1, SessionPoolUnbalancedTest.mockedSessions(1, 2, 3, 4, 1, 1, 1, 1), SessionPoolUnbalancedTest.mockedCheckedOutSessions(1, 2, 3, 4), (int)4));
        Assert.assertFalse((boolean)SessionPool.isUnbalanced((int)1, SessionPoolUnbalancedTest.mockedSessions(1, 2, 1, 1, 1, 1), SessionPoolUnbalancedTest.mockedCheckedOutSessions(1, 2), (int)2));
        Assert.assertFalse((boolean)SessionPool.isUnbalanced((int)1, SessionPoolUnbalancedTest.mockedSessions(1, 2, 3, 4, 1, 2, 3, 4, 1, 1, 1, 1), SessionPoolUnbalancedTest.mockedCheckedOutSessions(1, 2, 3, 4), (int)8));
        Assert.assertFalse((boolean)SessionPool.isUnbalanced((int)1, SessionPoolUnbalancedTest.mockedSessions(1, 1, 2, 2, 3, 3, 4, 4, 1, 1, 1, 1), SessionPoolUnbalancedTest.mockedCheckedOutSessions(1, 2, 3, 4), (int)8));
        Assert.assertFalse((boolean)SessionPool.isUnbalanced((int)1, SessionPoolUnbalancedTest.mockedSessions(1, 2, 3, 4), SessionPoolUnbalancedTest.mockedCheckedOutSessions(1, 1, 2, 3), (int)4));
        Assert.assertFalse((boolean)SessionPool.isUnbalanced((int)1, SessionPoolUnbalancedTest.mockedSessions(1, 2, 3, 4), SessionPoolUnbalancedTest.mockedCheckedOutSessions(1, 1, 1, 1, 2, 3, 4, 5, 6, 7, 8, 2, 3, 4, 5, 6), (int)8));
        Assert.assertFalse((boolean)SessionPool.isUnbalanced((int)1, SessionPoolUnbalancedTest.mockedSessions(1, 2, 3, 4), SessionPoolUnbalancedTest.mockedCheckedOutSessions(2, 2, 2, 2), (int)4));
        Assert.assertFalse((boolean)SessionPool.isUnbalanced((int)1, SessionPoolUnbalancedTest.mockedSessions(1, 2, 3, 4, 5, 6, 7, 8), SessionPoolUnbalancedTest.mockedCheckedOutSessions(1, 1, 2), (int)8));
        Assert.assertFalse((boolean)SessionPool.isUnbalanced((int)1, SessionPoolUnbalancedTest.mockedSessions(1, 2, 3, 4, 5, 6, 7, 8), SessionPoolUnbalancedTest.mockedCheckedOutSessions(1, 1, 1, 1, 1, 2, 3, 4, 5, 6, 7, 8, 2, 4, 5, 5, 3, 4, 8, 8), (int)8));
    }

    @Test
    public void testIsUnbalanced_returnsTrueForUnbalancedPool() {
        Assert.assertTrue((boolean)SessionPool.isUnbalanced((int)1, SessionPoolUnbalancedTest.mockedSessions(1, 1), SessionPoolUnbalancedTest.mockedCheckedOutSessions(1, 2, 1, 2), (int)2));
        Assert.assertTrue((boolean)SessionPool.isUnbalanced((int)2, SessionPoolUnbalancedTest.mockedSessions(2, 2), SessionPoolUnbalancedTest.mockedCheckedOutSessions(1, 2, 1, 2), (int)2));
        Assert.assertTrue((boolean)SessionPool.isUnbalanced((int)1, SessionPoolUnbalancedTest.mockedSessions(1, 1, 1, 4), SessionPoolUnbalancedTest.mockedCheckedOutSessions(1, 2, 3, 4), (int)4));
        Assert.assertTrue((boolean)SessionPool.isUnbalanced((int)2, SessionPoolUnbalancedTest.mockedSessions(2, 2, 2, 4), SessionPoolUnbalancedTest.mockedCheckedOutSessions(1, 2, 3, 4), (int)4));
        Assert.assertTrue((boolean)SessionPool.isUnbalanced((int)3, SessionPoolUnbalancedTest.mockedSessions(1, 3, 3, 3), SessionPoolUnbalancedTest.mockedCheckedOutSessions(1, 2, 3, 4), (int)4));
        Assert.assertTrue((boolean)SessionPool.isUnbalanced((int)4, SessionPoolUnbalancedTest.mockedSessions(1, 4, 4, 4), SessionPoolUnbalancedTest.mockedCheckedOutSessions(1, 2, 3, 4), (int)4));
        Assert.assertTrue((boolean)SessionPool.isUnbalanced((int)1, SessionPoolUnbalancedTest.mockedSessions(1, 2, 3, 4, 5, 6, 1, 1), SessionPoolUnbalancedTest.mockedCheckedOutSessions(1, 2, 3, 4), (int)8));
        Assert.assertTrue((boolean)SessionPool.isUnbalanced((int)2, SessionPoolUnbalancedTest.mockedSessions(1, 3, 4, 5, 6, 2, 2, 2), SessionPoolUnbalancedTest.mockedCheckedOutSessions(1, 2, 3, 4), (int)8));
        Assert.assertTrue((boolean)SessionPool.isUnbalanced((int)3, SessionPoolUnbalancedTest.mockedSessions(1, 2, 3, 3, 4, 5, 3, 6), SessionPoolUnbalancedTest.mockedCheckedOutSessions(1, 2, 3, 4), (int)8));
        Assert.assertTrue((boolean)SessionPool.isUnbalanced((int)4, SessionPoolUnbalancedTest.mockedSessions(1, 2, 3, 4, 5, 4, 5, 4), SessionPoolUnbalancedTest.mockedCheckedOutSessions(1, 2, 3, 4), (int)8));
        Assert.assertTrue((boolean)SessionPool.isUnbalanced((int)1, SessionPoolUnbalancedTest.mockedSessions(1, 2, 3, 4), SessionPoolUnbalancedTest.mockedCheckedOutSessions(1, 1, 2, 1), (int)4));
        Assert.assertTrue((boolean)SessionPool.isUnbalanced((int)2, SessionPoolUnbalancedTest.mockedSessions(1, 2, 3, 4), SessionPoolUnbalancedTest.mockedCheckedOutSessions(2, 2, 2, 4), (int)4));
        Assert.assertTrue((boolean)SessionPool.isUnbalanced((int)3, SessionPoolUnbalancedTest.mockedSessions(1, 2, 3, 4), SessionPoolUnbalancedTest.mockedCheckedOutSessions(1, 3, 3, 3), (int)4));
        Assert.assertTrue((boolean)SessionPool.isUnbalanced((int)4, SessionPoolUnbalancedTest.mockedSessions(1, 2, 3, 4), SessionPoolUnbalancedTest.mockedCheckedOutSessions(4, 2, 4, 4), (int)4));
        Assert.assertTrue((boolean)SessionPool.isUnbalanced((int)1, SessionPoolUnbalancedTest.mockedSessions(1, 2, 3, 4), SessionPoolUnbalancedTest.mockedCheckedOutSessions(1, 1, 2, 1, 1, 2, 3, 1), (int)4));
        Assert.assertTrue((boolean)SessionPool.isUnbalanced((int)1, SessionPoolUnbalancedTest.mockedSessions(1, 2, 3, 4, 5, 6, 7, 8), SessionPoolUnbalancedTest.mockedCheckedOutSessions(1, 1, 1, 3), (int)8));
        Assert.assertTrue((boolean)SessionPool.isUnbalanced((int)1, SessionPoolUnbalancedTest.mockedSessions(1, 2, 3, 4, 5, 6, 7, 8), SessionPoolUnbalancedTest.mockedCheckedOutSessions(1, 1, 1, 2, 3, 4, 5, 6, 7, 8, 1, 1), (int)8));
    }
}

