/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionManager;
import com.google.cloud.spanner.v1.SpannerClient;
import com.google.cloud.spanner.v1.SpannerSettings;
import com.google.protobuf.ByteString;
import com.google.protobuf.ListValue;
import com.google.protobuf.Value;
import com.google.spanner.v1.ResultSetMetadata;
import com.google.spanner.v1.StructType;
import com.google.spanner.v1.Type;
import com.google.spanner.v1.TypeCode;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.inprocess.InProcessServerBuilder;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TransactionManagerAbortedTest {
    private static final String PROJECT_ID = "PROJECT";
    private static final String INSTANCE_ID = "INSTANCE";
    private static final String DATABASE_ID = "DATABASE";
    private static final ResultSetMetadata READ_METADATA = ResultSetMetadata.newBuilder().setRowType(StructType.newBuilder().addFields(StructType.Field.newBuilder().setName("BAR").setType(Type.newBuilder().setCode(TypeCode.INT64).build()).build()).build()).build();
    private static final com.google.spanner.v1.ResultSet READ_RESULTSET = com.google.spanner.v1.ResultSet.newBuilder().addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("1").build()).build()).addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("2").build()).build()).setMetadata(READ_METADATA).build();
    private static final com.google.spanner.v1.ResultSet READ_ROW_RESULTSET = com.google.spanner.v1.ResultSet.newBuilder().addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("1").build()).build()).setMetadata(READ_METADATA).build();
    private static final Statement SELECT1AND2 = Statement.of((String)"SELECT 1 AS COL1 UNION ALL SELECT 2 AS COL1");
    private static final ResultSetMetadata SELECT1AND2_METADATA = ResultSetMetadata.newBuilder().setRowType(StructType.newBuilder().addFields(StructType.Field.newBuilder().setName("COL1").setType(Type.newBuilder().setCode(TypeCode.INT64).build()).build()).build()).build();
    private static final com.google.spanner.v1.ResultSet SELECT1AND2_RESULTSET = com.google.spanner.v1.ResultSet.newBuilder().addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("1").build()).build()).addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("2").build()).build()).setMetadata(SELECT1AND2_METADATA).build();
    private static final Statement UPDATE_STATEMENT = Statement.of((String)"UPDATE FOO SET BAR=1 WHERE BAZ=2");
    private static final long UPDATE_COUNT = 1L;
    private static final Statement UPDATE_ABORTED_STATEMENT = Statement.of((String)"UPDATE FOO SET BAR=1 WHERE BAZ=2 AND THIS_WILL_ABORT=TRUE");
    private static MockSpannerServiceImpl mockSpanner;
    private static Server server;
    private static LocalChannelProvider channelProvider;
    private static SpannerClient spannerClient;
    private static Spanner spanner;

    @BeforeClass
    public static void startStaticServer() throws IOException {
        mockSpanner = new MockSpannerServiceImpl();
        mockSpanner.setAbortProbability(0.0);
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.read("FOO", KeySet.all(), Collections.singletonList("BAR"), READ_RESULTSET));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.read("FOO", KeySet.singleKey((Key)Key.of((Object[])new Object[0])), Collections.singletonList("BAR"), READ_ROW_RESULTSET));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(SELECT1AND2, SELECT1AND2_RESULTSET));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(UPDATE_STATEMENT, 1L));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.exception(UPDATE_ABORTED_STATEMENT, mockSpanner.createAbortedException(ByteString.copyFromUtf8((String)"test"))));
        String uniqueName = InProcessServerBuilder.generateName();
        server = ((InProcessServerBuilder)InProcessServerBuilder.forName((String)uniqueName).scheduledExecutorService((ScheduledExecutorService)new ScheduledThreadPoolExecutor(1)).addService((BindableService)mockSpanner)).build().start();
        channelProvider = LocalChannelProvider.create((String)uniqueName);
        SpannerSettings settings = ((SpannerSettings.Builder)((SpannerSettings.Builder)SpannerSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        spannerClient = SpannerClient.create((SpannerSettings)settings);
    }

    @AfterClass
    public static void stopServer() throws InterruptedException {
        spannerClient.close();
        server.shutdown();
        server.awaitTermination();
    }

    @Before
    public void setUp() {
        mockSpanner.reset();
        mockSpanner.removeAllExecutionTimes();
        SpannerOptions.Builder builder = (SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId(PROJECT_ID)).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance());
        spanner = (Spanner)builder.build().getService();
    }

    @After
    public void tearDown() {
        spanner.close();
    }

    @Test
    public void testTransactionManagerAbortOnCommit() throws InterruptedException {
        DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)PROJECT_ID, (String)INSTANCE_ID, (String)DATABASE_ID));
        int attempts = 0;
        try (TransactionManager manager = client.transactionManager(new Options.TransactionOption[0]);){
            manager.begin();
            while (true) {
                ++attempts;
                try {
                    if (attempts == 1) {
                        mockSpanner.abortNextTransaction();
                    }
                    manager.commit();
                }
                catch (AbortedException e) {
                    Thread.sleep(e.getRetryDelayInMillis());
                    manager.resetForRetry();
                    continue;
                }
                break;
            }
        }
        MatcherAssert.assertThat((Object)attempts, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2)));
    }

    @Test
    public void testTransactionManagerAbortOnUpdate() throws InterruptedException {
        DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)PROJECT_ID, (String)INSTANCE_ID, (String)DATABASE_ID));
        int attempts = 0;
        try (TransactionManager manager = client.transactionManager(new Options.TransactionOption[0]);){
            TransactionContext txn = manager.begin();
            while (true) {
                ++attempts;
                try {
                    if (attempts == 1) {
                        mockSpanner.abortNextTransaction();
                    }
                    long updateCount = txn.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]);
                    MatcherAssert.assertThat((Object)updateCount, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1L)));
                    manager.commit();
                }
                catch (AbortedException e) {
                    Thread.sleep(e.getRetryDelayInMillis());
                    txn = manager.resetForRetry();
                    continue;
                }
                break;
            }
        }
        MatcherAssert.assertThat((Object)attempts, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2)));
    }

    @Test
    public void testTransactionManagerAbortOnBatchUpdate() throws InterruptedException {
        DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)PROJECT_ID, (String)INSTANCE_ID, (String)DATABASE_ID));
        int attempts = 0;
        try (TransactionManager manager = client.transactionManager(new Options.TransactionOption[0]);){
            TransactionContext txn = manager.begin();
            while (true) {
                ++attempts;
                try {
                    if (attempts == 1) {
                        mockSpanner.abortNextTransaction();
                    }
                    long[] updateCounts = txn.batchUpdate(Arrays.asList(UPDATE_STATEMENT, UPDATE_STATEMENT), new Options.UpdateOption[0]);
                    MatcherAssert.assertThat((Object)updateCounts, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)new long[]{1L, 1L})));
                    manager.commit();
                }
                catch (AbortedException e) {
                    Thread.sleep(e.getRetryDelayInMillis());
                    txn = manager.resetForRetry();
                    continue;
                }
                break;
            }
        }
        MatcherAssert.assertThat((Object)attempts, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2)));
    }

    @Test
    public void testTransactionManagerAbortOnBatchUpdateHalfway() throws InterruptedException {
        DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)PROJECT_ID, (String)INSTANCE_ID, (String)DATABASE_ID));
        int attempts = 0;
        try (TransactionManager manager = client.transactionManager(new Options.TransactionOption[0]);){
            TransactionContext txn = manager.begin();
            while (true) {
                ++attempts;
                try {
                    if (attempts == 1) {
                        txn.batchUpdate(Arrays.asList(UPDATE_STATEMENT, UPDATE_ABORTED_STATEMENT), new Options.UpdateOption[0]);
                        Assert.fail((String)"missing expected AbortedException");
                    }
                    long[] updateCounts = txn.batchUpdate(Arrays.asList(UPDATE_STATEMENT, UPDATE_STATEMENT), new Options.UpdateOption[0]);
                    MatcherAssert.assertThat((Object)updateCounts, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)new long[]{1L, 1L})));
                    manager.commit();
                }
                catch (AbortedException e) {
                    Thread.sleep(e.getRetryDelayInMillis());
                    txn = manager.resetForRetry();
                    continue;
                }
                break;
            }
        }
        MatcherAssert.assertThat((Object)attempts, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2)));
    }

    @Test
    public void testTransactionManagerAbortOnSelect() throws InterruptedException {
        DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)PROJECT_ID, (String)INSTANCE_ID, (String)DATABASE_ID));
        int attempts = 0;
        try (TransactionManager manager = client.transactionManager(new Options.TransactionOption[0]);){
            TransactionContext txn = manager.begin();
            while (true) {
                ++attempts;
                try {
                    if (attempts == 1) {
                        mockSpanner.abortNextTransaction();
                    }
                    try (ResultSet rs = txn.executeQuery(SELECT1AND2, new Options.QueryOption[0]);){
                        int rows = 0;
                        while (rs.next()) {
                            ++rows;
                        }
                        MatcherAssert.assertThat((Object)rows, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2)));
                    }
                    manager.commit();
                }
                catch (AbortedException e) {
                    Thread.sleep(e.getRetryDelayInMillis());
                    txn = manager.resetForRetry();
                    continue;
                }
                break;
            }
        }
        MatcherAssert.assertThat((Object)attempts, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2)));
    }

    @Test
    public void testTransactionManagerAbortOnRead() throws InterruptedException {
        DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)PROJECT_ID, (String)INSTANCE_ID, (String)DATABASE_ID));
        int attempts = 0;
        try (TransactionManager manager = client.transactionManager(new Options.TransactionOption[0]);){
            TransactionContext txn = manager.begin();
            while (true) {
                ++attempts;
                try {
                    if (attempts == 1) {
                        mockSpanner.abortNextTransaction();
                    }
                    try (ResultSet rs = txn.read("FOO", KeySet.all(), Collections.singletonList("BAR"), new Options.ReadOption[0]);){
                        int rows = 0;
                        while (rs.next()) {
                            ++rows;
                        }
                        MatcherAssert.assertThat((Object)rows, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2)));
                    }
                    manager.commit();
                }
                catch (AbortedException e) {
                    Thread.sleep(e.getRetryDelayInMillis());
                    txn = manager.resetForRetry();
                    continue;
                }
                break;
            }
        }
        MatcherAssert.assertThat((Object)attempts, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2)));
    }

    @Test
    public void testTransactionManagerAbortOnReadUsingIndex() throws InterruptedException {
        DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)PROJECT_ID, (String)INSTANCE_ID, (String)DATABASE_ID));
        int attempts = 0;
        try (TransactionManager manager = client.transactionManager(new Options.TransactionOption[0]);){
            TransactionContext txn = manager.begin();
            while (true) {
                ++attempts;
                try {
                    if (attempts == 1) {
                        mockSpanner.abortNextTransaction();
                    }
                    try (ResultSet rs = txn.readUsingIndex("FOO", "INDEX", KeySet.all(), Collections.singletonList("BAR"), new Options.ReadOption[0]);){
                        int rows = 0;
                        while (rs.next()) {
                            ++rows;
                        }
                        MatcherAssert.assertThat((Object)rows, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2)));
                    }
                    manager.commit();
                }
                catch (AbortedException e) {
                    Thread.sleep(e.getRetryDelayInMillis());
                    txn = manager.resetForRetry();
                    continue;
                }
                break;
            }
        }
        MatcherAssert.assertThat((Object)attempts, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2)));
    }

    @Test
    public void testTransactionManagerAbortOnReadRow() throws InterruptedException {
        DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)PROJECT_ID, (String)INSTANCE_ID, (String)DATABASE_ID));
        int attempts = 0;
        try (TransactionManager manager = client.transactionManager(new Options.TransactionOption[0]);){
            TransactionContext txn = manager.begin();
            while (true) {
                ++attempts;
                try {
                    if (attempts == 1) {
                        mockSpanner.abortNextTransaction();
                    }
                    Struct row = txn.readRow("FOO", Key.of((Object[])new Object[0]), Collections.singletonList("BAR"));
                    MatcherAssert.assertThat((Object)row.getLong(0), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1L)));
                    manager.commit();
                }
                catch (AbortedException e) {
                    Thread.sleep(e.getRetryDelayInMillis());
                    txn = manager.resetForRetry();
                    continue;
                }
                break;
            }
        }
        MatcherAssert.assertThat((Object)attempts, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2)));
    }

    @Test
    public void testTransactionManagerAbortOnReadRowUsingIndex() throws InterruptedException {
        DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)PROJECT_ID, (String)INSTANCE_ID, (String)DATABASE_ID));
        int attempts = 0;
        try (TransactionManager manager = client.transactionManager(new Options.TransactionOption[0]);){
            TransactionContext txn = manager.begin();
            while (true) {
                ++attempts;
                try {
                    if (attempts == 1) {
                        mockSpanner.abortNextTransaction();
                    }
                    Struct row = txn.readRowUsingIndex("FOO", "INDEX", Key.of((Object[])new Object[0]), Collections.singletonList("BAR"));
                    MatcherAssert.assertThat((Object)row.getLong(0), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1L)));
                    manager.commit();
                }
                catch (AbortedException e) {
                    Thread.sleep(e.getRetryDelayInMillis());
                    txn = manager.resetForRetry();
                    continue;
                }
                break;
            }
        }
        MatcherAssert.assertThat((Object)attempts, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2)));
    }
}

