/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.connection.ClientSideStatementImpl;
import com.google.cloud.spanner.connection.ClientSideStatementValueConverters;
import com.google.cloud.spanner.connection.ReadOnlyStalenessConverterTest;
import com.google.protobuf.Duration;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class PgDurationConverterTest {
    @Test
    public void testConvert() throws ClientSideStatementImpl.CompileException {
        String allowedValues = ReadOnlyStalenessConverterTest.getAllowedValues(ClientSideStatementValueConverters.PgDurationConverter.class, Dialect.POSTGRESQL);
        Assert.assertNotNull((Object)allowedValues);
        ClientSideStatementValueConverters.PgDurationConverter converter = new ClientSideStatementValueConverters.PgDurationConverter(allowedValues);
        Assert.assertEquals((Object)Duration.newBuilder().setNanos(1000000).build(), (Object)converter.convert("1"));
        Assert.assertEquals((Object)Duration.newBuilder().setSeconds(1L).build(), (Object)converter.convert("1000"));
        Assert.assertEquals((Object)Duration.newBuilder().setSeconds(1L).setNanos(1000000).build(), (Object)converter.convert("1001"));
        Assert.assertEquals((Object)Duration.newBuilder().setNanos((int)TimeUnit.MILLISECONDS.toNanos(100L)).build(), (Object)converter.convert("'100ms'"));
        Assert.assertNull((Object)converter.convert("'0ms'"));
        Assert.assertNull((Object)converter.convert("'-100ms'"));
        Assert.assertEquals((Object)Duration.newBuilder().setSeconds(315576000000L).build(), (Object)converter.convert("'315576000000000ms'"));
        Assert.assertEquals((Object)Duration.newBuilder().setSeconds(1L).build(), (Object)converter.convert("'1s'"));
        Assert.assertEquals((Object)Duration.newBuilder().setSeconds(1L).setNanos((int)TimeUnit.MILLISECONDS.toNanos(1L)).build(), (Object)converter.convert("'1001ms'"));
        Assert.assertEquals((Object)Duration.newBuilder().setNanos(1).build(), (Object)converter.convert("'1ns'"));
        Assert.assertEquals((Object)Duration.newBuilder().setNanos(1000).build(), (Object)converter.convert("'1us'"));
        Assert.assertEquals((Object)Duration.newBuilder().setNanos(1000000).build(), (Object)converter.convert("'1ms'"));
        Assert.assertEquals((Object)Duration.newBuilder().setNanos(999999999).build(), (Object)converter.convert("'999999999ns'"));
        Assert.assertEquals((Object)Duration.newBuilder().setSeconds(1L).build(), (Object)converter.convert("'1s'"));
        Assert.assertNull((Object)converter.convert("''"));
        Assert.assertNull((Object)converter.convert("' '"));
        Assert.assertNull((Object)converter.convert("'random string'"));
        Assert.assertEquals((Object)Duration.getDefaultInstance(), (Object)converter.convert("default"));
        Assert.assertEquals((Object)Duration.getDefaultInstance(), (Object)converter.convert("DEFAULT"));
        Assert.assertEquals((Object)Duration.getDefaultInstance(), (Object)converter.convert("Default"));
        Assert.assertNull((Object)converter.convert("'default'"));
        Assert.assertNull((Object)converter.convert("'DEFAULT'"));
        Assert.assertNull((Object)converter.convert("'Default'"));
    }
}

