/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection.it;

import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ParallelIntegrationTest;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.connection.ITAbstractSpannerTest;
import com.google.cloud.spanner.connection.SqlScriptVerifier;
import com.google.cloud.spanner.testing.EmulatorSpannerHelper;
import java.math.BigInteger;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@Category(value={ParallelIntegrationTest.class})
@RunWith(value=JUnit4.class)
public class ITReadOnlySpannerTest
extends ITAbstractSpannerTest {
    private static final long TEST_ROWS_COUNT = 1000L;

    @Override
    protected void appendConnectionUri(StringBuilder url) {
        url.append(";readOnly=true");
    }

    @Before
    public void createTestTables() throws Exception {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            if (!this.tableExists(connection, "NUMBERS") || !this.tableExists(connection, "PRIME_NUMBERS")) {
                long number;
                SqlScriptVerifier verifier = new SqlScriptVerifier(new ITAbstractSpannerTest.ITConnectionProvider(this));
                verifier.verifyStatementsInFile("ITReadOnlySpannerTest_CreateTables.sql", SqlScriptVerifier.class, false);
                connection.setAutocommit(false);
                connection.setReadOnly(false);
                for (number = 1L; number <= 1000L; ++number) {
                    connection.bufferedWrite(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"NUMBERS").set("number").to(number)).set("name").to(Long.toBinaryString(number))).build());
                }
                for (number = 1L; number <= 1000L; ++number) {
                    if (!BigInteger.valueOf(number).isProbablePrime(Integer.MAX_VALUE)) continue;
                    connection.bufferedWrite(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"PRIME_NUMBERS").set("prime_number").to(number)).set("binary_representation").to(Long.toBinaryString(number))).build());
                }
                connection.commit();
            }
        }
    }

    @Test
    public void testSqlScript() throws Exception {
        Thread.sleep(100L);
        SqlScriptVerifier verifier = new SqlScriptVerifier(new ITAbstractSpannerTest.ITConnectionProvider(this));
        verifier.verifyStatementsInFile("ITReadOnlySpannerTest.sql", SqlScriptVerifier.class, false);
    }

    @Test
    public void testStatementTimeoutTransactional() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.beginTransaction();
            connection.setStatementTimeout(1L, TimeUnit.MILLISECONDS);
            try (ResultSet rs = connection.executeQuery(Statement.of((String)"SELECT (SELECT COUNT(*) FROM PRIME_NUMBERS)/(SELECT COUNT(*) FROM NUMBERS) AS PRIME_NUMBER_RATIO"), new Options.QueryOption[0]);){
                Assert.fail((String)"Expected exception");
            }
            connection.commit();
        }
        catch (SpannerException ex) {
            Assert.assertEquals((Object)ErrorCode.DEADLINE_EXCEEDED, (Object)ex.getErrorCode());
        }
    }

    @Test
    public void testStatementTimeoutTransactionalMultipleStatements() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.beginTransaction();
            for (int i = 0; i < 3; ++i) {
                connection.setStatementTimeout(1L, TimeUnit.MICROSECONDS);
                try (ResultSet rs = connection.executeQuery(Statement.of((String)"SELECT (SELECT COUNT(*) FROM PRIME_NUMBERS)/(SELECT COUNT(*) FROM NUMBERS) AS PRIME_NUMBER_RATIO"), new Options.QueryOption[0]);){
                    Assert.fail((String)"Missing expected exception");
                    continue;
                }
                catch (SpannerException e) {
                    MatcherAssert.assertThat((Object)e.getErrorCode(), (Matcher)CoreMatchers.is((Object)ErrorCode.DEADLINE_EXCEEDED));
                }
            }
            connection.commit();
        }
    }

    @Test
    public void testStatementTimeoutAutocommit() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            MatcherAssert.assertThat((Object)connection.isAutocommit(), (Matcher)CoreMatchers.is((Object)true));
            connection.setStatementTimeout(1L, TimeUnit.MILLISECONDS);
            try (ResultSet rs = connection.executeQuery(Statement.of((String)"SELECT (SELECT COUNT(*) FROM PRIME_NUMBERS)/(SELECT COUNT(*) FROM NUMBERS) AS PRIME_NUMBER_RATIO"), new Options.QueryOption[0]);){
                Assert.fail((String)"Expected exception");
            }
            catch (SpannerException ex) {
                Assert.assertEquals((Object)ErrorCode.DEADLINE_EXCEEDED, (Object)ex.getErrorCode());
            }
        }
    }

    @Test
    public void testAnalyzeQuery() {
        Assume.assumeFalse((String)"analyze query is not supported on the emulator", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            for (ReadContext.QueryAnalyzeMode mode : ReadContext.QueryAnalyzeMode.values()) {
                try (ResultSet rs = connection.analyzeQuery(Statement.of((String)"SELECT (SELECT COUNT(*) FROM PRIME_NUMBERS)/(SELECT COUNT(*) FROM NUMBERS) AS PRIME_NUMBER_RATIO"), mode);){
                    MatcherAssert.assertThat((Object)rs.getStats(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
                    while (rs.next()) {
                    }
                    MatcherAssert.assertThat((Object)rs.getStats(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
                }
            }
        }
    }

    @Test
    public void testQueryWithOptions() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();
             ResultSet rs = connection.executeQuery(Statement.of((String)"SELECT (SELECT CAST(COUNT(*) AS FLOAT64) FROM PRIME_NUMBERS)/(SELECT COUNT(*) FROM NUMBERS) AS PRIME_NUMBER_RATIO"), new Options.QueryOption[]{Options.prefetchChunks((int)100000)});){
            MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)true));
            MatcherAssert.assertThat((Object)rs.getDouble(0), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
            MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)false));
        }
    }

    @Test
    public void testMultipleOpenResultSets() throws InterruptedException {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            ResultSet rs1 = connection.executeQuery(Statement.of((String)"SELECT * FROM PRIME_NUMBERS"), new Options.QueryOption[0]);
            ResultSet rs2 = connection.executeQuery(Statement.of((String)"SELECT * FROM NUMBERS"), new Options.QueryOption[0]);
            ExecutorService exec = Executors.newFixedThreadPool(2);
            exec.submit(() -> {
                while (rs1.next()) {
                }
            });
            exec.submit(() -> {
                while (rs2.next()) {
                }
            });
            exec.shutdown();
            exec.awaitTermination(1000L, TimeUnit.SECONDS);
            rs1.close();
            rs2.close();
        }
    }

    @Test
    public void testGetMetadataFromAnalyzeQuery() {
        Assume.assumeFalse((String)"analyze query is not supported on the emulator", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();
             ResultSet resultSet = connection.analyzeQuery(Statement.of((String)"SELECT number, name FROM NUMBERS"), ReadContext.QueryAnalyzeMode.PLAN);){
            Assert.assertEquals((long)2L, (long)resultSet.getColumnCount());
            Assert.assertEquals((long)0L, (long)resultSet.getColumnIndex("number"));
            Assert.assertEquals((Object)"number", (Object)((Type.StructField)resultSet.getType().getStructFields().get(0)).getName());
            Assert.assertEquals((Object)Type.int64(), (Object)resultSet.getColumnType(0));
            Assert.assertEquals((Object)Type.int64(), (Object)resultSet.getColumnType("number"));
            Assert.assertEquals((long)1L, (long)resultSet.getColumnIndex("name"));
            Assert.assertEquals((Object)"name", (Object)((Type.StructField)resultSet.getType().getStructFields().get(1)).getName());
            Assert.assertEquals((Object)Type.string(), (Object)resultSet.getColumnType(1));
            Assert.assertEquals((Object)Type.string(), (Object)resultSet.getColumnType("name"));
        }
    }
}

