/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.it;

import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.IntegrationTestWithClosedSessionsEnv;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ParallelIntegrationTest;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SessionNotFoundException;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionManager;
import com.google.cloud.spanner.TransactionRunner;
import com.google.common.truth.Truth;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@Category(value={ParallelIntegrationTest.class})
@RunWith(value=JUnit4.class)
public class ITClosedSessionTest {
    private static final int RUNS_PER_TEST_CASE = 2;
    @ClassRule
    public static IntegrationTestWithClosedSessionsEnv env = new IntegrationTestWithClosedSessionsEnv();
    private static Database db;
    private static IntegrationTestWithClosedSessionsEnv.DatabaseClientWithClosedSessionImpl client;

    @BeforeClass
    public static void setUpDatabase() {
        db = env.getTestHelper().createTestDatabase(new String[0]);
        client = (IntegrationTestWithClosedSessionsEnv.DatabaseClientWithClosedSessionImpl)env.getTestHelper().getDatabaseClient(db);
    }

    @Before
    public void setup() {
        client.setAllowSessionReplacing(true);
    }

    @Test
    public void testSingleUse() {
        client.invalidateNextSession();
        for (int run = 0; run < 2; ++run) {
            try (ResultSet rs = Statement.of((String)"SELECT 1").executeQuery(client.singleUse(), new Options.QueryOption[0]);){
                Truth.assertThat((Boolean)rs.next()).isTrue();
                Truth.assertThat((Long)rs.getLong(0)).isEqualTo((Object)1L);
                Truth.assertThat((Boolean)rs.next()).isFalse();
                continue;
            }
        }
    }

    @Test
    public void testSingleUseNoRecreation() {
        client.setAllowSessionReplacing(false);
        client.invalidateNextSession();
        try (ResultSet rs = Statement.of((String)"SELECT 1").executeQuery(client.singleUse(), new Options.QueryOption[0]);){
            rs.next();
            Assert.fail((String)"Expected exception");
        }
        catch (SessionNotFoundException ex) {
            Assert.assertNotNull((Object)ex.getMessage());
        }
    }

    @Test
    public void testSingleUseBound() {
        client.invalidateNextSession();
        for (int run = 0; run < 2; ++run) {
            try (ResultSet rs = Statement.of((String)"SELECT 1").executeQuery(client.singleUse(TimestampBound.ofExactStaleness((long)10L, (TimeUnit)TimeUnit.SECONDS)), new Options.QueryOption[0]);){
                Truth.assertThat((Boolean)rs.next()).isTrue();
                Truth.assertThat((Long)rs.getLong(0)).isEqualTo((Object)1L);
                Truth.assertThat((Boolean)rs.next()).isFalse();
                continue;
            }
        }
    }

    @Test
    public void testSingleUseReadOnlyTransaction() {
        client.invalidateNextSession();
        for (int run = 0; run < 2; ++run) {
            try (ReadOnlyTransaction txn = client.singleUseReadOnlyTransaction();){
                try (ResultSet rs = txn.executeQuery(Statement.of((String)"SELECT 1"), new Options.QueryOption[0]);){
                    Truth.assertThat((Boolean)rs.next()).isTrue();
                    Truth.assertThat((Long)rs.getLong(0)).isEqualTo((Object)1L);
                    Truth.assertThat((Boolean)rs.next()).isFalse();
                }
                Truth.assertThat((Comparable)txn.getReadTimestamp()).isNotNull();
                continue;
            }
        }
    }

    @Test
    public void testSingleUseReadOnlyTransactionBound() {
        client.invalidateNextSession();
        for (int run = 0; run < 2; ++run) {
            try (ReadOnlyTransaction txn = client.singleUseReadOnlyTransaction(TimestampBound.ofMaxStaleness((long)10L, (TimeUnit)TimeUnit.SECONDS));){
                try (ResultSet rs = txn.executeQuery(Statement.of((String)"SELECT 1"), new Options.QueryOption[0]);){
                    Truth.assertThat((Boolean)rs.next()).isTrue();
                    Truth.assertThat((Long)rs.getLong(0)).isEqualTo((Object)1L);
                    Truth.assertThat((Boolean)rs.next()).isFalse();
                }
                Truth.assertThat((Comparable)txn.getReadTimestamp()).isNotNull();
                continue;
            }
        }
    }

    @Test
    public void testReadOnlyTransaction() {
        client.invalidateNextSession();
        for (int run = 0; run < 2; ++run) {
            try (ReadOnlyTransaction txn = client.readOnlyTransaction();){
                for (int i = 0; i < 2; ++i) {
                    try (ResultSet rs = txn.executeQuery(Statement.of((String)"SELECT 1"), new Options.QueryOption[0]);){
                        Truth.assertThat((Boolean)rs.next()).isTrue();
                        Truth.assertThat((Long)rs.getLong(0)).isEqualTo((Object)1L);
                        Truth.assertThat((Boolean)rs.next()).isFalse();
                        continue;
                    }
                }
                Truth.assertThat((Comparable)txn.getReadTimestamp()).isNotNull();
                continue;
            }
        }
    }

    @Test
    public void testReadOnlyTransactionNoRecreation() {
        client.setAllowSessionReplacing(false);
        client.invalidateNextSession();
        try (ReadOnlyTransaction txn = client.readOnlyTransaction();){
            try (ResultSet rs = txn.executeQuery(Statement.of((String)"SELECT 1"), new Options.QueryOption[0]);){
                rs.next();
                Assert.fail((String)"Expected exception");
            }
            Assert.fail((String)"Expected exception");
        }
        catch (SessionNotFoundException ex) {
            Assert.assertNotNull((Object)ex.getMessage());
        }
    }

    @Test
    public void testReadOnlyTransactionBound() {
        client.invalidateNextSession();
        for (int run = 0; run < 2; ++run) {
            try (ReadOnlyTransaction txn = client.readOnlyTransaction(TimestampBound.ofExactStaleness((long)10L, (TimeUnit)TimeUnit.SECONDS));){
                for (int i = 0; i < 2; ++i) {
                    try (ResultSet rs = txn.executeQuery(Statement.of((String)"SELECT 1"), new Options.QueryOption[0]);){
                        Truth.assertThat((Boolean)rs.next()).isTrue();
                        Truth.assertThat((Long)rs.getLong(0)).isEqualTo((Object)1L);
                        Truth.assertThat((Boolean)rs.next()).isFalse();
                        continue;
                    }
                }
                Truth.assertThat((Comparable)txn.getReadTimestamp()).isNotNull();
                continue;
            }
        }
    }

    @Test
    public void testReadWriteTransaction() {
        client.invalidateNextSession();
        for (int run = 0; run < 2; ++run) {
            TransactionRunner txn = client.readWriteTransaction(new Options.TransactionOption[0]);
            txn.run(transaction -> {
                for (int i = 0; i < 2; ++i) {
                    try (ResultSet rs = transaction.executeQuery(Statement.of((String)"SELECT 1"), new Options.QueryOption[0]);){
                        Truth.assertThat((Boolean)rs.next()).isTrue();
                        Truth.assertThat((Long)rs.getLong(0)).isEqualTo((Object)1L);
                        Truth.assertThat((Boolean)rs.next()).isFalse();
                        continue;
                    }
                }
                return null;
            });
        }
    }

    @Test
    public void testReadWriteTransactionNoRecreation() {
        client.setAllowSessionReplacing(false);
        client.invalidateNextSession();
        try {
            TransactionRunner txn = client.readWriteTransaction(new Options.TransactionOption[0]);
            txn.run(transaction -> {
                try (ResultSet rs = transaction.executeQuery(Statement.of((String)"SELECT 1"), new Options.QueryOption[0]);){
                    rs.next();
                    Assert.fail((String)"Expected exception");
                }
                return null;
            });
            Assert.fail((String)"Expected exception");
        }
        catch (SessionNotFoundException ex) {
            Assert.assertNotNull((Object)ex.getMessage());
        }
    }

    @Test
    public void testTransactionManager() throws InterruptedException {
        client.invalidateNextSession();
        for (int run = 0; run < 2; ++run) {
            try (TransactionManager manager = client.transactionManager(new Options.TransactionOption[0]);){
                TransactionContext txn = manager.begin();
                try {
                    for (int i = 0; i < 2; ++i) {
                        try (ResultSet rs = txn.executeQuery(Statement.of((String)"SELECT 1"), new Options.QueryOption[0]);){
                            Truth.assertThat((Boolean)rs.next()).isTrue();
                            Truth.assertThat((Long)rs.getLong(0)).isEqualTo((Object)1L);
                            Truth.assertThat((Boolean)rs.next()).isFalse();
                            continue;
                        }
                    }
                    manager.commit();
                }
                catch (AbortedException e) {
                    long retryDelayInMillis = e.getRetryDelayInMillis();
                    if (retryDelayInMillis > 0L) {
                        Thread.sleep(retryDelayInMillis);
                    }
                    TransactionContext transactionContext = manager.resetForRetry();
                }
                continue;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void testTransactionManagerNoRecreation() {
        ITClosedSessionTest.client.setAllowSessionReplacing(false);
        ITClosedSessionTest.client.invalidateNextSession();
        try {
            manager = ITClosedSessionTest.client.transactionManager(new Options.TransactionOption[0]);
            try {
                txn = manager.begin();
                while (true) lbl-1000:
                // 3 sources

                {
                    rs = txn.executeQuery(Statement.of((String)"SELECT 1"), new Options.QueryOption[0]);
                    try {
                        rs.next();
                        Assert.fail((String)"Expected exception");
                    }
                    finally {
                        if (rs == null) continue;
                        rs.close();
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable var2_4) {
                if (manager != null) {
                    try {
                        manager.close();
                    }
                    catch (Throwable var3_6) {
                        var2_4.addSuppressed(var3_6);
                    }
                }
                throw var2_4;
            }
            ** GOTO lbl-1000
        }
        catch (SessionNotFoundException ex) {
            Assert.assertNotNull((Object)ex.getMessage());
            return;
        }
    }
}

