/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.SessionPoolOptions;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.admin.database.v1.MockDatabaseAdminImpl;
import com.google.cloud.spanner.admin.instance.v1.MockInstanceAdminImpl;
import com.google.longrunning.GetOperationRequest;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsGrpc;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Any;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.rpc.Status;
import com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.inprocess.InProcessServerBuilder;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;

abstract class AbstractMockServerTest {
    protected static MockSpannerServiceImpl mockSpanner;
    public static MockInstanceAdminImpl mockInstanceAdmin;
    public static MockDatabaseAdminImpl mockDatabaseAdmin;
    public static OperationsGrpc.OperationsImplBase mockOperations;
    protected static Server server;
    protected static LocalChannelProvider channelProvider;
    protected Spanner spanner;

    AbstractMockServerTest() {
    }

    @BeforeClass
    public static void startMockServer() throws IOException {
        mockSpanner = new MockSpannerServiceImpl();
        mockSpanner.setAbortProbability(0.0);
        mockInstanceAdmin = new MockInstanceAdminImpl();
        mockDatabaseAdmin = new MockDatabaseAdminImpl();
        mockOperations = new OperationsGrpc.OperationsImplBase(){
            AtomicBoolean done = new AtomicBoolean(false);

            public void getOperation(GetOperationRequest request, StreamObserver<Operation> responseObserver) {
                responseObserver.onNext((Object)Operation.newBuilder().setDone(this.done.getAndSet(!this.done.get())).setName(request.getName()).setMetadata(Any.pack((Message)UpdateDatabaseDdlMetadata.newBuilder().setDatabase("projects/proj/instances/inst/databases/db").build())).setResponse(Any.pack((Message)Empty.getDefaultInstance())).build());
                responseObserver.onCompleted();
            }
        };
        String uniqueName = InProcessServerBuilder.generateName();
        server = ((InProcessServerBuilder)((InProcessServerBuilder)((InProcessServerBuilder)((InProcessServerBuilder)InProcessServerBuilder.forName((String)uniqueName).addService((BindableService)mockSpanner)).addService((BindableService)mockInstanceAdmin)).addService((BindableService)mockDatabaseAdmin)).addService((BindableService)mockOperations)).build().start();
        channelProvider = LocalChannelProvider.create((String)uniqueName);
    }

    @AfterClass
    public static void stopMockServer() throws InterruptedException {
        server.shutdown();
        server.awaitTermination();
    }

    @Before
    public void createSpannerInstance() {
        this.spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("test-project")).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance())).setSessionPoolOption(SessionPoolOptions.newBuilder().setFailOnSessionLeak().build()).build().getService();
    }

    @After
    public void cleanup() {
        this.spanner.close();
        mockSpanner.reset();
        mockSpanner.removeAllExecutionTimes();
    }

    void addUpdateDdlResponse() {
        mockDatabaseAdmin.addResponse((AbstractMessage)Operation.newBuilder().setMetadata(Any.pack((Message)UpdateDatabaseDdlMetadata.newBuilder().setDatabase("projects/proj/instances/inst/databases/db").build())).setName("projects/proj/instances/inst/databases/db/operations/1").setDone(false).setResponse(Any.pack((Message)Empty.getDefaultInstance())).build());
    }

    void addUpdateDdlError() {
        mockDatabaseAdmin.addResponse((AbstractMessage)Operation.newBuilder().setMetadata(Any.pack((Message)UpdateDatabaseDdlMetadata.newBuilder().setDatabase("projects/proj/instances/inst/databases/db").build())).setName("projects/proj/instances/inst/databases/db/operations/1").setDone(true).setResponse(Any.pack((Message)Empty.getDefaultInstance())).setError(Status.newBuilder().setCode(9).setMessage("test error").build()).build());
    }
}

