/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.spanner.AsyncResultSet;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseClientImpl;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.DatabaseNotFoundException;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.MockSpannerTestUtil;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.SessionPoolOptions;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerApiFutures;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.TimestampBound;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.truth.Truth;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.Status;
import io.grpc.inprocess.InProcessServerBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ReadAsyncTest {
    private static MockSpannerServiceImpl mockSpanner;
    private static Server server;
    private static LocalChannelProvider channelProvider;
    private static ExecutorService executor;
    private Spanner spanner;
    private DatabaseClient client;

    @BeforeClass
    public static void setup() throws Exception {
        mockSpanner = new MockSpannerServiceImpl();
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(MockSpannerTestUtil.READ_ONE_KEY_VALUE_STATEMENT, MockSpannerTestUtil.READ_ONE_KEY_VALUE_RESULTSET));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(MockSpannerTestUtil.READ_ONE_EMPTY_KEY_VALUE_STATEMENT, MockSpannerTestUtil.EMPTY_KEY_VALUE_RESULTSET));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(MockSpannerTestUtil.READ_MULTIPLE_KEY_VALUE_STATEMENT, MockSpannerTestUtil.READ_MULTIPLE_KEY_VALUE_RESULTSET));
        String uniqueName = InProcessServerBuilder.generateName();
        server = ((InProcessServerBuilder)InProcessServerBuilder.forName((String)uniqueName).scheduledExecutorService((ScheduledExecutorService)new ScheduledThreadPoolExecutor(1)).addService((BindableService)mockSpanner)).build().start();
        channelProvider = LocalChannelProvider.create((String)uniqueName);
        executor = Executors.newScheduledThreadPool(8);
    }

    @AfterClass
    public static void teardown() throws Exception {
        executor.shutdown();
        server.shutdown();
        server.awaitTermination();
    }

    @Before
    public void before() {
        this.spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("my-project")).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance())).setSessionPoolOption(SessionPoolOptions.newBuilder().setFailOnSessionLeak().setMinSessions(0).build()).build().getService();
        this.client = this.spanner.getDatabaseClient(DatabaseId.of((String)"my-project", (String)"my-instance", (String)"my-database"));
    }

    @After
    public void after() {
        this.spanner.close();
        mockSpanner.removeAllExecutionTimes();
    }

    @Test
    public void readAsyncPropagatesError() throws Exception {
        ApiFuture result;
        try (AsyncResultSet resultSet = this.client.singleUse(TimestampBound.strong()).readAsync("EmptyTestTable", KeySet.singleKey((Key)Key.of((Object[])new Object[]{"k99"})), MockSpannerTestUtil.READ_COLUMN_NAMES, new Options.ReadOption[0]);){
            result = resultSet.setCallback((Executor)executor, ignored -> {
                throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.CANCELLED, (String)"Don't want the data");
            });
        }
        SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> SpannerApiFutures.get((ApiFuture)result));
        Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.CANCELLED);
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"Don't want the data");
    }

    @Test
    public void emptyReadAsync() throws Exception {
        ApiFuture result;
        try (AsyncResultSet resultSet = this.client.singleUse(TimestampBound.strong()).readAsync("EmptyTestTable", KeySet.singleKey((Key)Key.of((Object[])new Object[]{"k99"})), MockSpannerTestUtil.READ_COLUMN_NAMES, new Options.ReadOption[0]);){
            result = resultSet.setCallback((Executor)executor, rs -> {
                while (true) {
                    switch (rs.tryNext()) {
                        case OK: {
                            Assert.fail((String)"received unexpected data");
                        }
                        case NOT_READY: {
                            return AsyncResultSet.CallbackResponse.CONTINUE;
                        }
                        case DONE: {
                            Truth.assertThat((Object)rs.getType()).isEqualTo((Object)MockSpannerTestUtil.READ_TABLE_TYPE);
                            return AsyncResultSet.CallbackResponse.DONE;
                        }
                    }
                }
            });
        }
        Truth.assertThat((Object)result.get()).isNull();
    }

    @Test
    public void pointReadAsync() throws Exception {
        ApiFuture row = this.client.singleUse(TimestampBound.strong()).readRowAsync("TestTable", Key.of((Object[])new Object[]{"k1"}), MockSpannerTestUtil.READ_COLUMN_NAMES);
        Truth.assertThat((Object)row.get()).isNotNull();
        Truth.assertThat((String)((Struct)row.get()).getString(0)).isEqualTo((Object)"k1");
        Truth.assertThat((String)((Struct)row.get()).getString(1)).isEqualTo((Object)"v1");
    }

    @Test
    public void pointReadNotFound() throws Exception {
        ApiFuture row = this.client.singleUse(TimestampBound.strong()).readRowAsync("EmptyTestTable", Key.of((Object[])new Object[]{"k999"}), MockSpannerTestUtil.READ_COLUMN_NAMES);
        Truth.assertThat((Object)row.get()).isNull();
    }

    @Test
    public void invalidDatabase() {
        mockSpanner.setCreateSessionExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.stickyDatabaseNotFoundException("invalid-database"));
        mockSpanner.setBatchCreateSessionsExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.stickyDatabaseNotFoundException("invalid-database"));
        mockSpanner.freeze();
        DatabaseClient invalidClient = this.spanner.getDatabaseClient(DatabaseId.of((String)"my-project", (String)"my-instance", (String)"invalid-database"));
        ApiFuture row = invalidClient.singleUse(TimestampBound.strong()).readRowAsync("TestTable", Key.of((Object[])new Object[]{"k99"}), MockSpannerTestUtil.READ_COLUMN_NAMES);
        mockSpanner.unfreeze();
        Assert.assertThrows(DatabaseNotFoundException.class, () -> SpannerApiFutures.get((ApiFuture)row));
    }

    @Test
    public void tableNotFound() throws Exception {
        mockSpanner.setStreamingReadExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)((Object)Status.NOT_FOUND.withDescription("Table not found: BadTableName").asRuntimeException())));
        ApiFuture row = this.client.singleUse(TimestampBound.strong()).readRowAsync("BadTableName", Key.of((Object[])new Object[]{"k1"}), MockSpannerTestUtil.READ_COLUMN_NAMES);
        SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> SpannerApiFutures.get((ApiFuture)row));
        Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.NOT_FOUND);
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"BadTableName");
    }

    @Test
    public void closeTransactionBeforeEndOfAsyncQuery() throws Exception {
        ApiFuture closed;
        SynchronousQueue results = new SynchronousQueue();
        SettableApiFuture finished = SettableApiFuture.create();
        DatabaseClientImpl clientImpl = (DatabaseClientImpl)this.client;
        Truth.assertThat((Integer)clientImpl.pool.getNumberOfSessionsInUse()).isEqualTo((Object)0);
        CountDownLatch dataReceived = new CountDownLatch(1);
        try (ReadOnlyTransaction tx = this.client.readOnlyTransaction();){
            try (AsyncResultSet rs = tx.readAsync("TestTable", KeySet.all(), MockSpannerTestUtil.READ_COLUMN_NAMES, new Options.ReadOption[]{Options.bufferRows((int)1)});){
                closed = rs.setCallback((Executor)executor, resultSet -> {
                    try {
                        while (true) {
                            switch (resultSet.tryNext()) {
                                case DONE: {
                                    finished.set((Object)true);
                                    return AsyncResultSet.CallbackResponse.DONE;
                                }
                                case NOT_READY: {
                                    return AsyncResultSet.CallbackResponse.CONTINUE;
                                }
                                case OK: {
                                    dataReceived.countDown();
                                    results.put(resultSet.getString(0));
                                }
                            }
                        }
                    }
                    catch (Throwable t) {
                        finished.setException(t);
                        return AsyncResultSet.CallbackResponse.DONE;
                    }
                });
            }
            dataReceived.await();
            if (this.isMultiplexedSessionsEnabled()) {
                Truth.assertThat((Integer)clientImpl.pool.getNumberOfSessionsInUse()).isEqualTo((Object)0);
            } else {
                Truth.assertThat((Integer)clientImpl.pool.getNumberOfSessionsInUse()).isEqualTo((Object)1);
            }
        }
        if (this.isMultiplexedSessionsEnabled()) {
            Truth.assertThat((Integer)clientImpl.pool.getNumberOfSessionsInUse()).isEqualTo((Object)0);
        } else {
            Truth.assertThat((Integer)clientImpl.pool.getNumberOfSessionsInUse()).isEqualTo((Object)1);
        }
        ArrayList resultList = new ArrayList();
        do {
            results.drainTo(resultList);
        } while (!finished.isDone() || results.size() > 0);
        Truth.assertThat((Boolean)((Boolean)finished.get())).isTrue();
        Truth.assertThat(resultList).containsExactly(new Object[]{"k1", "k2", "k3"});
        closed.get();
        Truth.assertThat((Integer)clientImpl.pool.getNumberOfSessionsInUse()).isEqualTo((Object)0);
    }

    @Test
    public void readOnlyTransaction() throws Exception {
        ApiFuture values2;
        ApiFuture values1;
        Statement statement1 = Statement.of((String)"SELECT * FROM TestTable WHERE Key IN ('k10', 'k11', 'k12')");
        Statement statement2 = Statement.of((String)"SELECT * FROM TestTable WHERE Key IN ('k1', 'k2', 'k3");
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(statement1, MockSpannerTestUtil.generateKeyValueResultSet((Iterable<Integer>)ContiguousSet.closed((int)10, (int)12))));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(statement2, MockSpannerTestUtil.generateKeyValueResultSet((Iterable<Integer>)ContiguousSet.closed((int)1, (int)3))));
        try (ReadOnlyTransaction tx = this.client.readOnlyTransaction();){
            try (AsyncResultSet rs = tx.executeQueryAsync(statement1, new Options.QueryOption[0]);){
                values1 = rs.toListAsync(input -> input.getString("Value"), (Executor)executor);
            }
            rs = tx.executeQueryAsync(statement2, new Options.QueryOption[0]);
            try {
                values2 = rs.toListAsync(input -> input.getString("Value"), (Executor)executor);
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        ApiFuture allValuesAsList = ApiFutures.allAsList(Arrays.asList(values1, values2));
        ApiFuture allValues = ApiFutures.transform((ApiFuture)allValuesAsList, input -> Iterables.mergeSorted((Iterable)input, Comparator.comparing(o -> Integer.valueOf(o.substring(1)))), (Executor)executor);
        Truth.assertThat((Iterable)((Iterable)allValues.get())).containsExactly(new Object[]{"v1", "v2", "v3", "v10", "v11", "v12"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void pauseResume() throws Exception {
        ApiFuture evenFinished;
        ApiFuture unevenFinished;
        Statement unevenStatement = Statement.of((String)"SELECT * FROM TestTable WHERE MOD(CAST(SUBSTR(Key, 2) AS INT64), 2) = 1");
        Statement evenStatement = Statement.of((String)"SELECT * FROM TestTable WHERE MOD(CAST(SUBSTR(Key, 2) AS INT64), 2) = 0");
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(unevenStatement, MockSpannerTestUtil.generateKeyValueResultSet((Iterable<Integer>)ImmutableSet.of((Object)1, (Object)3, (Object)5, (Object)7, (Object)9))));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(evenStatement, MockSpannerTestUtil.generateKeyValueResultSet((Iterable<Integer>)ImmutableSet.of((Object)2, (Object)4, (Object)6, (Object)8, (Object)10))));
        Object lock = new Object();
        CountDownLatch unevenReturnedFirstRow = new CountDownLatch(1);
        ConcurrentLinkedDeque allValues = new ConcurrentLinkedDeque();
        try (ReadOnlyTransaction tx = this.client.readOnlyTransaction();
             AsyncResultSet evenRs = tx.executeQueryAsync(evenStatement, new Options.QueryOption[0]);
             AsyncResultSet unevenRs = tx.executeQueryAsync(unevenStatement, new Options.QueryOption[0]);){
            unevenFinished = unevenRs.setCallback((Executor)executor, resultSet -> {
                while (true) {
                    switch (resultSet.tryNext()) {
                        case DONE: {
                            return AsyncResultSet.CallbackResponse.DONE;
                        }
                        case NOT_READY: {
                            return AsyncResultSet.CallbackResponse.CONTINUE;
                        }
                        case OK: {
                            Object object = lock;
                            synchronized (object) {
                                allValues.add(resultSet.getString("Value"));
                            }
                            unevenReturnedFirstRow.countDown();
                            return AsyncResultSet.CallbackResponse.PAUSE;
                        }
                    }
                }
            });
            evenFinished = evenRs.setCallback((Executor)executor, resultSet -> {
                try {
                    unevenReturnedFirstRow.await();
                    while (true) {
                        switch (resultSet.tryNext()) {
                            case DONE: {
                                return AsyncResultSet.CallbackResponse.DONE;
                            }
                            case NOT_READY: {
                                return AsyncResultSet.CallbackResponse.CONTINUE;
                            }
                            case OK: {
                                Object object = lock;
                                synchronized (object) {
                                    allValues.add(resultSet.getString("Value"));
                                }
                                return AsyncResultSet.CallbackResponse.PAUSE;
                            }
                        }
                    }
                }
                catch (InterruptedException e) {
                    throw SpannerExceptionFactory.propagateInterrupt((InterruptedException)e);
                }
            });
            while (!evenFinished.isDone() || !unevenFinished.isDone()) {
                Object object = lock;
                synchronized (object) {
                    if (allValues.peekLast() != null) {
                        if (Integer.parseInt(((String)allValues.peekLast()).substring(1)) % 2 == 1) {
                            evenRs.resume();
                        } else {
                            unevenRs.resume();
                        }
                    }
                    if (allValues.size() == 10) {
                        unevenRs.resume();
                        evenRs.resume();
                    }
                }
            }
        }
        Truth.assertThat((Iterable)((Iterable)ApiFutures.allAsList(Arrays.asList(evenFinished, unevenFinished)).get())).containsExactly(new Object[]{null, null});
        Truth.assertThat(allValues).containsExactly(new Object[]{"v1", "v2", "v3", "v4", "v5", "v6", "v7", "v8", "v9", "v10"});
    }

    @Test
    public void cancel() throws Exception {
        ApiFuture res;
        LinkedList values = new LinkedList();
        CountDownLatch receivedFirstRow = new CountDownLatch(1);
        CountDownLatch cancelled = new CountDownLatch(1);
        try (AsyncResultSet rs = this.client.singleUse().readAsync("TestTable", KeySet.all(), MockSpannerTestUtil.READ_COLUMN_NAMES, new Options.ReadOption[0]);){
            res = rs.setCallback((Executor)executor, resultSet -> {
                try {
                    while (true) {
                        switch (resultSet.tryNext()) {
                            case DONE: {
                                return AsyncResultSet.CallbackResponse.DONE;
                            }
                            case NOT_READY: {
                                return AsyncResultSet.CallbackResponse.CONTINUE;
                            }
                            case OK: {
                                values.add(resultSet.getString("Value"));
                                receivedFirstRow.countDown();
                                cancelled.await();
                            }
                        }
                    }
                }
                catch (Throwable t) {
                    return AsyncResultSet.CallbackResponse.DONE;
                }
            });
            receivedFirstRow.await();
            rs.cancel();
        }
        cancelled.countDown();
        SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> SpannerApiFutures.get((ApiFuture)res));
        Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.CANCELLED);
        Truth.assertThat(values).containsExactly(new Object[]{"v1"});
    }

    private boolean isMultiplexedSessionsEnabled() {
        if (this.spanner.getOptions() == null || ((SpannerOptions)this.spanner.getOptions()).getSessionPoolOptions() == null) {
            return false;
        }
        return ((SpannerOptions)this.spanner.getOptions()).getSessionPoolOptions().getUseMultiplexedSession();
    }
}

