/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiFutures;
import com.google.api.core.NanoClock;
import com.google.api.gax.grpc.GrpcCallContext;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.cloud.Timestamp;
import com.google.cloud.grpc.GrpcTransportOptions;
import com.google.cloud.spanner.Clock;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.ISpan;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.OpenTelemetrySpan;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.Session;
import com.google.cloud.spanner.SessionImpl;
import com.google.cloud.spanner.SessionPoolOptions;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerImpl;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.TransactionRunner;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.spi.v1.SpannerRpc;
import com.google.cloud.spanner.v1.stub.SpannerStubSettings;
import com.google.common.truth.Truth;
import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import com.google.protobuf.ListValue;
import com.google.protobuf.Value;
import com.google.protobuf.util.Timestamps;
import com.google.spanner.v1.BeginTransactionRequest;
import com.google.spanner.v1.CommitRequest;
import com.google.spanner.v1.CommitResponse;
import com.google.spanner.v1.Mutation;
import com.google.spanner.v1.PartialResultSet;
import com.google.spanner.v1.ReadRequest;
import com.google.spanner.v1.ResultSetMetadata;
import com.google.spanner.v1.RollbackRequest;
import com.google.spanner.v1.Transaction;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Scope;
import java.text.ParseException;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@RunWith(value=JUnit4.class)
public class SessionImplTest {
    @Mock
    private SpannerRpc rpc;
    @Mock
    private SpannerOptions spannerOptions;
    private Session session;
    @Captor
    private ArgumentCaptor<Map<SpannerRpc.Option, Object>> optionsCaptor;
    private Map<SpannerRpc.Option, Object> options;

    @BeforeClass
    public static void setupOpenTelemetry() {
        SpannerOptions.resetActiveTracingFramework();
        SpannerOptions.enableOpenTelemetryTraces();
    }

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.spannerOptions.getNumChannels()).thenReturn((Object)4);
        Mockito.when((Object)this.spannerOptions.getPrefetchChunks()).thenReturn((Object)1);
        Mockito.when((Object)this.spannerOptions.getDatabaseRole()).thenReturn((Object)"role");
        Mockito.when((Object)this.spannerOptions.getRetrySettings()).thenReturn((Object)RetrySettings.newBuilder().build());
        Mockito.when((Object)this.spannerOptions.getClock()).thenReturn((Object)NanoClock.getDefaultClock());
        Mockito.when((Object)this.spannerOptions.getSessionLabels()).thenReturn(Collections.emptyMap());
        GrpcTransportOptions transportOptions = (GrpcTransportOptions)Mockito.mock(GrpcTransportOptions.class);
        Mockito.when((Object)transportOptions.getExecutorFactory()).thenReturn((Object)((GrpcTransportOptions.ExecutorFactory)Mockito.mock(GrpcTransportOptions.ExecutorFactory.class)));
        Mockito.when((Object)this.spannerOptions.getTransportOptions()).thenReturn((Object)transportOptions);
        SessionPoolOptions sessionPoolOptions = (SessionPoolOptions)Mockito.mock(SessionPoolOptions.class);
        Mockito.when((Object)sessionPoolOptions.getPoolMaintainerClock()).thenReturn((Object)Clock.INSTANCE);
        Mockito.when((Object)this.spannerOptions.getSessionPoolOptions()).thenReturn((Object)sessionPoolOptions);
        Mockito.when((Object)this.spannerOptions.getOpenTelemetry()).thenReturn((Object)OpenTelemetry.noop());
        SpannerImpl spanner = new SpannerImpl(this.rpc, this.spannerOptions);
        String dbName = "projects/p1/instances/i1/databases/d1";
        String sessionName = dbName + "/sessions/s1";
        DatabaseId db = DatabaseId.of((String)dbName);
        com.google.spanner.v1.Session sessionProto = com.google.spanner.v1.Session.newBuilder().setName(sessionName).build();
        Mockito.when((Object)this.rpc.createSession((String)Mockito.eq((Object)dbName), Mockito.anyString(), Mockito.anyMap(), (Map)this.optionsCaptor.capture())).thenReturn((Object)sessionProto);
        Transaction txn = Transaction.newBuilder().setId(ByteString.copyFromUtf8((String)"TEST")).build();
        Mockito.when((Object)this.rpc.beginTransactionAsync((BeginTransactionRequest)Mockito.any(BeginTransactionRequest.class), (Map)Mockito.any(Map.class), Mockito.anyBoolean())).thenReturn((Object)ApiFutures.immediateFuture((Object)txn));
        CommitResponse commitResponse = CommitResponse.newBuilder().setCommitTimestamp(com.google.protobuf.Timestamp.getDefaultInstance()).build();
        Mockito.when((Object)this.rpc.commitAsync((CommitRequest)Mockito.any(CommitRequest.class), (Map)Mockito.any(Map.class))).thenReturn((Object)ApiFutures.immediateFuture((Object)commitResponse));
        Mockito.when((Object)this.rpc.rollbackAsync((RollbackRequest)Mockito.any(RollbackRequest.class), Mockito.anyMap())).thenReturn((Object)ApiFutures.immediateFuture((Object)Empty.getDefaultInstance()));
        Mockito.when((Object)this.rpc.getReadRetrySettings()).thenReturn((Object)SpannerStubSettings.newBuilder().streamingReadSettings().getRetrySettings());
        Mockito.when((Object)this.rpc.getReadRetryableCodes()).thenReturn((Object)SpannerStubSettings.newBuilder().streamingReadSettings().getRetryableCodes());
        Mockito.when((Object)this.rpc.getExecuteQueryRetrySettings()).thenReturn((Object)SpannerStubSettings.newBuilder().executeStreamingSqlSettings().getRetrySettings());
        Mockito.when((Object)this.rpc.getExecuteQueryRetryableCodes()).thenReturn((Object)SpannerStubSettings.newBuilder().executeStreamingSqlSettings().getRetryableCodes());
        Mockito.when((Object)this.rpc.getCommitRetrySettings()).thenReturn((Object)SpannerStubSettings.newBuilder().commitSettings().getRetrySettings());
        this.session = spanner.getSessionClient(db).createSession();
        Span oTspan = (Span)Mockito.mock(Span.class);
        OpenTelemetrySpan span = new OpenTelemetrySpan(oTspan);
        Mockito.when((Object)oTspan.makeCurrent()).thenReturn((Object)((Scope)Mockito.mock(Scope.class)));
        ((SessionImpl)this.session).setCurrentSpan((ISpan)span);
        this.options = (Map)this.optionsCaptor.getValue();
    }

    private void doNestedRwTransaction() {
        this.session.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
            this.session.readWriteTransaction(new Options.TransactionOption[0]).run(transaction1 -> null);
            return null;
        });
    }

    @Test
    public void nestedReadWriteTxnThrows() {
        SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> this.doNestedRwTransaction());
        Assert.assertEquals((Object)ErrorCode.INTERNAL, (Object)e.getErrorCode());
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"not supported");
    }

    @Test
    public void nestedReadOnlyTxnThrows() {
        SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> this.session.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
            this.session.readOnlyTransaction().getReadTimestamp();
            return null;
        }));
        Assert.assertEquals((Object)ErrorCode.INTERNAL, (Object)e.getErrorCode());
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"not supported");
    }

    @Test
    public void nestedSingleUseReadTxnThrows() {
        SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> this.session.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
            this.session.singleUseReadOnlyTransaction();
            return null;
        }));
        Assert.assertEquals((Object)ErrorCode.INTERNAL, (Object)e.getErrorCode());
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"not supported");
    }

    @Test
    public void nestedTxnSucceedsWhenAllowed() {
        this.session.readWriteTransaction(new Options.TransactionOption[0]).allowNestedTransaction().run(transaction -> {
            this.session.singleUseReadOnlyTransaction();
            return null;
        });
    }

    @Test
    public void writeAtLeastOnce() throws ParseException {
        String timestampString = "2015-10-01T10:54:20.021Z";
        ArgumentCaptor commit = ArgumentCaptor.forClass(CommitRequest.class);
        CommitResponse response = CommitResponse.newBuilder().setCommitTimestamp(Timestamps.parse((String)timestampString)).build();
        Mockito.when((Object)this.rpc.commit((CommitRequest)commit.capture(), (Map)Mockito.eq(this.options))).thenReturn((Object)response);
        Timestamp timestamp = this.session.writeAtLeastOnce(Collections.singletonList(((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"T").set("C").to("x")).build()));
        Truth.assertThat((Long)timestamp.getSeconds()).isEqualTo((Object)SessionImplTest.utcTimeSeconds(2015, 9, 1, 10, 54, 20));
        Truth.assertThat((Integer)timestamp.getNanos()).isEqualTo((Object)TimeUnit.MILLISECONDS.toNanos(21L));
        CommitRequest request = (CommitRequest)commit.getValue();
        Truth.assertThat((Object)request.getSingleUseTransaction()).isNotNull();
        Truth.assertThat((Object)request.getSingleUseTransaction().getReadWrite()).isNotNull();
        com.google.spanner.v1.Mutation mutation = com.google.spanner.v1.Mutation.newBuilder().setInsert(Mutation.Write.newBuilder().setTable("T").addColumns("C").addValues(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("x")))).build();
        Truth.assertThat((Iterable)request.getMutationsList()).containsExactly(new Object[]{mutation});
    }

    @Test
    public void writeAtLeastOnceWithOptions() throws ParseException {
        String tag = "app=spanner,env=test";
        String timestampString = "2015-10-01T10:54:20.021Z";
        ArgumentCaptor commit = ArgumentCaptor.forClass(CommitRequest.class);
        CommitResponse response = CommitResponse.newBuilder().setCommitTimestamp(Timestamps.parse((String)timestampString)).build();
        Mockito.when((Object)this.rpc.commit((CommitRequest)commit.capture(), (Map)Mockito.eq(this.options))).thenReturn((Object)response);
        this.session.writeAtLeastOnceWithOptions(Collections.singletonList(((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"T").set("C").to("x")).build()), new Options.TransactionOption[]{Options.tag((String)tag)});
        CommitRequest request = (CommitRequest)commit.getValue();
        Truth.assertThat((String)request.getRequestOptions().getTransactionTag()).isEqualTo((Object)tag);
        com.google.spanner.v1.Mutation mutation = com.google.spanner.v1.Mutation.newBuilder().setInsert(Mutation.Write.newBuilder().setTable("T").addColumns("C").addValues(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("x")))).build();
        Truth.assertThat((Iterable)request.getMutationsList()).containsExactly(new Object[]{mutation});
    }

    private static long utcTimeSeconds(int year, int month, int day, int hour, int min, int secs) {
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        calendar.set(year, month, day, hour, min, secs);
        return calendar.getTimeInMillis() / 1000L;
    }

    @Test
    public void newSingleUseContextClosesOldSingleUseContext() {
        ReadContext ctx = this.session.singleUse(TimestampBound.strong());
        this.session.singleUse(TimestampBound.strong());
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> ctx.read("Dummy", KeySet.all(), Collections.singletonList("C"), new Options.ReadOption[0]));
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"invalidated");
    }

    @Test
    public void newSingleUseContextClosesOldSingleUseReadOnlyTransactionContext() {
        ReadOnlyTransaction ctx = this.session.singleUseReadOnlyTransaction(TimestampBound.strong());
        this.session.singleUse(TimestampBound.strong());
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> SessionImplTest.lambda$newSingleUseContextClosesOldSingleUseReadOnlyTransactionContext$9((ReadContext)ctx));
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"invalidated");
    }

    @Test
    public void newSingleUseContextClosesOldMultiUseReadOnlyTransactionContext() {
        ReadOnlyTransaction ctx = this.session.singleUseReadOnlyTransaction(TimestampBound.strong());
        this.session.singleUse(TimestampBound.strong());
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> SessionImplTest.lambda$newSingleUseContextClosesOldMultiUseReadOnlyTransactionContext$10((ReadContext)ctx));
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"invalidated");
    }

    @Test
    public void newSingleUseReadOnlyTransactionContextClosesOldSingleUseContext() {
        ReadContext ctx = this.session.singleUse(TimestampBound.strong());
        this.session.singleUseReadOnlyTransaction(TimestampBound.strong());
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> ctx.read("Dummy", KeySet.all(), Collections.singletonList("C"), new Options.ReadOption[0]));
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"invalidated");
    }

    @Test
    public void newMultiUseReadOnlyTransactionContextClosesOldSingleUseContext() {
        ReadContext ctx = this.session.singleUse(TimestampBound.strong());
        this.session.readOnlyTransaction(TimestampBound.strong());
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> ctx.read("Dummy", KeySet.all(), Collections.singletonList("C"), new Options.ReadOption[0]));
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"invalidated");
    }

    @Test
    public void writeClosesOldSingleUseContext() throws ParseException {
        ReadContext ctx = this.session.singleUse(TimestampBound.strong());
        Mockito.when((Object)this.rpc.commit((CommitRequest)Mockito.any(), (Map)Mockito.eq(this.options))).thenReturn((Object)CommitResponse.newBuilder().setCommitTimestamp(Timestamps.parse((String)"2015-10-01T10:54:20.021Z")).build());
        this.session.writeAtLeastOnce(Collections.emptyList());
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> ctx.read("Dummy", KeySet.all(), Collections.singletonList("C"), new Options.ReadOption[0]));
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"invalidated");
    }

    @Test
    public void transactionClosesOldSingleUseContext() {
        ReadContext ctx = this.session.singleUse(TimestampBound.strong());
        this.session.readWriteTransaction(new Options.TransactionOption[0]);
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> ctx.read("Dummy", KeySet.all(), Collections.singletonList("C"), new Options.ReadOption[0]));
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"invalidated");
    }

    @Test
    public void singleUseContextClosesTransaction() {
        TransactionRunner runner = this.session.readWriteTransaction(new Options.TransactionOption[0]);
        this.session.singleUse(TimestampBound.strong());
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> runner.run(transaction -> {
            Assert.fail((String)"Unexpected call to transaction body");
            return null;
        }));
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"invalidated");
    }

    private static ResultSetMetadata newMetadata(Type type) {
        return ResultSetMetadata.newBuilder().setRowType(type.toProto().getStructType()).build();
    }

    @Test
    public void singleUseReadOnlyTransactionDoesntReturnTransactionMetadata() {
        PartialResultSet resultSet = PartialResultSet.newBuilder().setMetadata(SessionImplTest.newMetadata(Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"C", (Type)Type.string())}))).build();
        this.mockRead(resultSet);
        ReadOnlyTransaction txn = this.session.singleUseReadOnlyTransaction(TimestampBound.strong());
        Truth.assertThat((Object)txn.readRow("Dummy", Key.of((Object[])new Object[0]), Collections.singletonList("C"))).isNull();
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> txn.getReadTimestamp());
        Assert.assertNotNull((Object)e.getMessage());
    }

    @Test
    public void singleUseReadOnlyTransactionReturnsEmptyTransactionMetadata() {
        PartialResultSet resultSet = PartialResultSet.newBuilder().setMetadata(SessionImplTest.newMetadata(Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"C", (Type)Type.string())})).toBuilder().setTransaction(Transaction.getDefaultInstance())).build();
        this.mockRead(resultSet);
        ReadOnlyTransaction txn = this.session.singleUseReadOnlyTransaction(TimestampBound.strong());
        SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> txn.readRow("Dummy", Key.of((Object[])new Object[0]), Collections.singletonList("C")));
        Assert.assertEquals((Object)ErrorCode.INTERNAL, (Object)e.getErrorCode());
    }

    private void mockRead(PartialResultSet myResultSet) {
        ArgumentCaptor consumer = ArgumentCaptor.forClass(SpannerRpc.ResultStreamConsumer.class);
        Mockito.when((Object)this.rpc.read((ReadRequest)Mockito.any(), (SpannerRpc.ResultStreamConsumer)consumer.capture(), (Map)Mockito.eq(this.options), ArgumentMatchers.eq((boolean)false))).then(invocation -> {
            ((SpannerRpc.ResultStreamConsumer)consumer.getValue()).onPartialResultSet(myResultSet);
            ((SpannerRpc.ResultStreamConsumer)consumer.getValue()).onCompleted();
            return new NoOpStreamingCall();
        });
    }

    @Test
    public void multiUseReadOnlyTransactionReturnsEmptyTransactionMetadata() {
        Transaction txnMetadata = Transaction.newBuilder().setId(ByteString.copyFromUtf8((String)"x")).build();
        PartialResultSet resultSet = PartialResultSet.newBuilder().setMetadata(SessionImplTest.newMetadata(Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"C", (Type)Type.string())}))).build();
        Mockito.when((Object)this.rpc.beginTransaction((BeginTransactionRequest)Mockito.any(), (Map)Mockito.eq(this.options), ArgumentMatchers.eq((boolean)false))).thenReturn((Object)txnMetadata);
        this.mockRead(resultSet);
        ReadOnlyTransaction txn = this.session.readOnlyTransaction(TimestampBound.strong());
        SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> txn.readRow("Dummy", Key.of((Object[])new Object[0]), Collections.singletonList("C")));
        Assert.assertEquals((Object)ErrorCode.INTERNAL, (Object)e.getErrorCode());
    }

    @Test
    public void multiUseReadOnlyTransactionReturnsMissingTimestamp() {
        Transaction txnMetadata = Transaction.newBuilder().setId(ByteString.copyFromUtf8((String)"x")).build();
        PartialResultSet resultSet = PartialResultSet.newBuilder().setMetadata(SessionImplTest.newMetadata(Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"C", (Type)Type.string())}))).build();
        Mockito.when((Object)this.rpc.beginTransaction((BeginTransactionRequest)Mockito.any(), (Map)Mockito.eq(this.options), ArgumentMatchers.eq((boolean)false))).thenReturn((Object)txnMetadata);
        this.mockRead(resultSet);
        ReadOnlyTransaction txn = this.session.readOnlyTransaction(TimestampBound.strong());
        SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> txn.readRow("Dummy", Key.of((Object[])new Object[0]), Collections.singletonList("C")));
        Assert.assertEquals((Object)ErrorCode.INTERNAL, (Object)e.getErrorCode());
    }

    @Test
    public void multiUseReadOnlyTransactionReturnsMissingTransactionId() throws ParseException {
        com.google.protobuf.Timestamp t = Timestamps.parse((String)"2015-10-01T10:54:20.021Z");
        Transaction txnMetadata = Transaction.newBuilder().setReadTimestamp(t).build();
        PartialResultSet resultSet = PartialResultSet.newBuilder().setMetadata(SessionImplTest.newMetadata(Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"C", (Type)Type.string())}))).build();
        Mockito.when((Object)this.rpc.beginTransaction((BeginTransactionRequest)Mockito.any(), (Map)Mockito.eq(this.options), ArgumentMatchers.eq((boolean)false))).thenReturn((Object)txnMetadata);
        this.mockRead(resultSet);
        ReadOnlyTransaction txn = this.session.readOnlyTransaction(TimestampBound.strong());
        SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> txn.readRow("Dummy", Key.of((Object[])new Object[0]), Collections.singletonList("C")));
        Assert.assertEquals((Object)ErrorCode.INTERNAL, (Object)e.getErrorCode());
    }

    private static /* synthetic */ void lambda$newSingleUseContextClosesOldMultiUseReadOnlyTransactionContext$10(ReadContext ctx) throws Throwable {
        ctx.read("Dummy", KeySet.all(), Collections.singletonList("C"), new Options.ReadOption[0]);
    }

    private static /* synthetic */ void lambda$newSingleUseContextClosesOldSingleUseReadOnlyTransactionContext$9(ReadContext ctx) throws Throwable {
        ctx.read("Dummy", KeySet.all(), Collections.singletonList("C"), new Options.ReadOption[0]);
    }

    private static class NoOpStreamingCall
    implements SpannerRpc.StreamingCall {
        private NoOpStreamingCall() {
        }

        public ApiCallContext getCallContext() {
            return GrpcCallContext.createDefault();
        }

        public void cancel(@Nullable String message) {
        }

        public void request(int numMessages) {
        }
    }
}

