/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.Distribution;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.monitoring.v3.MetricServiceClient;
import com.google.cloud.monitoring.v3.stub.MetricServiceStub;
import com.google.cloud.spanner.BuiltInMetricsConstant;
import com.google.cloud.spanner.SpannerCloudMonitoringExporter;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import com.google.monitoring.v3.CreateTimeSeriesRequest;
import com.google.monitoring.v3.TimeSeries;
import com.google.protobuf.Empty;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.HistogramData;
import io.opentelemetry.sdk.metrics.data.LongPointData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.data.SumData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableHistogramData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableHistogramPointData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableLongPointData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableMetricData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableSumData;
import io.opentelemetry.sdk.resources.Resource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;

public class SpannerCloudMonitoringExporterTest {
    private static final String projectId = "fake-project";
    private static final String instanceId = "fake-instance";
    private static final String locationId = "global";
    private static final String databaseId = "fake-database";
    private static final String clientName = "spanner-java";
    private static final String instanceConfigId = "fake-instance-config-id";
    @Rule
    public final MockitoRule mockitoRule = MockitoJUnit.rule();
    @Mock
    private MetricServiceStub mockMetricServiceStub;
    private MetricServiceClient fakeMetricServiceClient;
    private SpannerCloudMonitoringExporter exporter;
    private Attributes attributes;
    private Resource resource;
    private InstrumentationScopeInfo scope;

    @Before
    public void setUp() {
        this.fakeMetricServiceClient = new FakeMetricServiceClient(this.mockMetricServiceStub);
        this.exporter = new SpannerCloudMonitoringExporter(projectId, this.fakeMetricServiceClient);
        this.attributes = Attributes.builder().put(BuiltInMetricsConstant.PROJECT_ID_KEY, (Object)projectId).put(BuiltInMetricsConstant.INSTANCE_ID_KEY, (Object)instanceId).put(BuiltInMetricsConstant.LOCATION_ID_KEY, (Object)locationId).put(BuiltInMetricsConstant.INSTANCE_CONFIG_ID_KEY, (Object)instanceConfigId).put(BuiltInMetricsConstant.DATABASE_KEY, (Object)databaseId).put(BuiltInMetricsConstant.CLIENT_NAME_KEY, (Object)clientName).put(String.valueOf(BuiltInMetricsConstant.DIRECT_PATH_ENABLED_KEY), true).put(String.valueOf(BuiltInMetricsConstant.DIRECT_PATH_USED_KEY), true).build();
        this.resource = Resource.create((Attributes)Attributes.empty());
        this.scope = InstrumentationScopeInfo.create((String)"gax-java");
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testExportingSumData() {
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(CreateTimeSeriesRequest.class);
        UnaryCallable mockCallable = (UnaryCallable)Mockito.mock(UnaryCallable.class);
        Mockito.when((Object)this.mockMetricServiceStub.createServiceTimeSeriesCallable()).thenReturn((Object)mockCallable);
        ApiFuture future = ApiFutures.immediateFuture((Object)Empty.getDefaultInstance());
        Mockito.when((Object)mockCallable.futureCall((Object)((CreateTimeSeriesRequest)argumentCaptor.capture()))).thenReturn((Object)future);
        long fakeValue = 11L;
        long startEpoch = 10L;
        long endEpoch = 15L;
        LongPointData longPointData = ImmutableLongPointData.create((long)startEpoch, (long)endEpoch, (Attributes)this.attributes, (long)fakeValue);
        MetricData longData = ImmutableMetricData.createLongSum((Resource)this.resource, (InstrumentationScopeInfo)this.scope, (String)"spanner.googleapis.com/internal/client/operation_count", (String)"description", (String)"1", (SumData)ImmutableSumData.create((boolean)true, (AggregationTemporality)AggregationTemporality.CUMULATIVE, (Collection)ImmutableList.of((Object)longPointData)));
        this.exporter.export(Arrays.asList(longData));
        CreateTimeSeriesRequest request = (CreateTimeSeriesRequest)argumentCaptor.getValue();
        Truth.assertThat((Iterable)request.getTimeSeriesList()).hasSize(1);
        TimeSeries timeSeries = (TimeSeries)request.getTimeSeriesList().get(0);
        Truth.assertThat((Map)timeSeries.getResource().getLabelsMap()).containsExactly((Object)BuiltInMetricsConstant.PROJECT_ID_KEY.getKey(), (Object)projectId, new Object[]{BuiltInMetricsConstant.INSTANCE_ID_KEY.getKey(), instanceId, BuiltInMetricsConstant.LOCATION_ID_KEY.getKey(), locationId, BuiltInMetricsConstant.INSTANCE_CONFIG_ID_KEY.getKey(), instanceConfigId});
        Truth.assertThat((Map)timeSeries.getResource().getLabelsMap()).hasSize(4);
        Truth.assertThat((Map)timeSeries.getMetric().getLabelsMap()).containsExactly((Object)BuiltInMetricsConstant.DATABASE_KEY.getKey(), (Object)databaseId, new Object[]{BuiltInMetricsConstant.CLIENT_NAME_KEY.getKey(), clientName, BuiltInMetricsConstant.DIRECT_PATH_ENABLED_KEY.getKey(), "true", BuiltInMetricsConstant.DIRECT_PATH_USED_KEY.getKey(), "true"});
        Truth.assertThat((Map)timeSeries.getMetric().getLabelsMap()).hasSize(4);
        Truth.assertThat((Long)timeSeries.getPoints(0).getValue().getInt64Value()).isEqualTo((Object)fakeValue);
        Truth.assertThat((Integer)timeSeries.getPoints(0).getInterval().getStartTime().getNanos()).isEqualTo((Object)startEpoch);
        Truth.assertThat((Integer)timeSeries.getPoints(0).getInterval().getEndTime().getNanos()).isEqualTo((Object)endEpoch);
    }

    @Test
    public void testExportingHistogramData() {
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(CreateTimeSeriesRequest.class);
        UnaryCallable mockCallable = (UnaryCallable)Mockito.mock(UnaryCallable.class);
        Mockito.when((Object)this.mockMetricServiceStub.createServiceTimeSeriesCallable()).thenReturn((Object)mockCallable);
        ApiFuture future = ApiFutures.immediateFuture((Object)Empty.getDefaultInstance());
        Mockito.when((Object)mockCallable.futureCall((Object)((CreateTimeSeriesRequest)argumentCaptor.capture()))).thenReturn((Object)future);
        long startEpoch = 10L;
        long endEpoch = 15L;
        ImmutableHistogramPointData histogramPointData = ImmutableHistogramPointData.create((long)startEpoch, (long)endEpoch, (Attributes)this.attributes, (double)3.0, (boolean)true, (double)1.0, (boolean)true, (double)2.0, Arrays.asList(1.0), Arrays.asList(1L, 2L));
        MetricData histogramData = ImmutableMetricData.createDoubleHistogram((Resource)this.resource, (InstrumentationScopeInfo)this.scope, (String)"spanner.googleapis.com/internal/client/operation_latencies", (String)"description", (String)"ms", (HistogramData)ImmutableHistogramData.create((AggregationTemporality)AggregationTemporality.CUMULATIVE, (Collection)ImmutableList.of((Object)histogramPointData)));
        this.exporter.export(Arrays.asList(histogramData));
        CreateTimeSeriesRequest request = (CreateTimeSeriesRequest)argumentCaptor.getValue();
        Truth.assertThat((Iterable)request.getTimeSeriesList()).hasSize(1);
        TimeSeries timeSeries = (TimeSeries)request.getTimeSeriesList().get(0);
        Truth.assertThat((Map)timeSeries.getResource().getLabelsMap()).hasSize(4);
        Truth.assertThat((Map)timeSeries.getResource().getLabelsMap()).containsExactly((Object)BuiltInMetricsConstant.PROJECT_ID_KEY.getKey(), (Object)projectId, new Object[]{BuiltInMetricsConstant.INSTANCE_ID_KEY.getKey(), instanceId, BuiltInMetricsConstant.LOCATION_ID_KEY.getKey(), locationId, BuiltInMetricsConstant.INSTANCE_CONFIG_ID_KEY.getKey(), instanceConfigId});
        Truth.assertThat((Map)timeSeries.getMetric().getLabelsMap()).hasSize(4);
        Truth.assertThat((Map)timeSeries.getMetric().getLabelsMap()).containsExactly((Object)BuiltInMetricsConstant.DATABASE_KEY.getKey(), (Object)databaseId, new Object[]{BuiltInMetricsConstant.CLIENT_NAME_KEY.getKey(), clientName, BuiltInMetricsConstant.DIRECT_PATH_ENABLED_KEY.getKey(), "true", BuiltInMetricsConstant.DIRECT_PATH_USED_KEY.getKey(), "true"});
        Distribution distribution = timeSeries.getPoints(0).getValue().getDistributionValue();
        Truth.assertThat((Long)distribution.getCount()).isEqualTo((Object)3);
        Truth.assertThat((Integer)timeSeries.getPoints(0).getInterval().getStartTime().getNanos()).isEqualTo((Object)startEpoch);
        Truth.assertThat((Integer)timeSeries.getPoints(0).getInterval().getEndTime().getNanos()).isEqualTo((Object)endEpoch);
    }

    @Test
    public void testExportingSumDataInBatches() {
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(CreateTimeSeriesRequest.class);
        UnaryCallable mockCallable = (UnaryCallable)Mockito.mock(UnaryCallable.class);
        Mockito.when((Object)this.mockMetricServiceStub.createServiceTimeSeriesCallable()).thenReturn((Object)mockCallable);
        ApiFuture future = ApiFutures.immediateFuture((Object)Empty.getDefaultInstance());
        Mockito.when((Object)mockCallable.futureCall((Object)((CreateTimeSeriesRequest)argumentCaptor.capture()))).thenReturn((Object)future);
        long startEpoch = 10L;
        long endEpoch = 15L;
        ArrayList<MetricData> toExport = new ArrayList<MetricData>();
        for (int i = 0; i < 250; ++i) {
            LongPointData longPointData = ImmutableLongPointData.create((long)startEpoch, (long)endEpoch, (Attributes)this.attributes.toBuilder().put(BuiltInMetricsConstant.CLIENT_UID_KEY, (Object)("client_uid" + i)).build(), (long)i);
            MetricData longData = ImmutableMetricData.createLongSum((Resource)this.resource, (InstrumentationScopeInfo)this.scope, (String)"spanner.googleapis.com/internal/client/operation_count", (String)"description", (String)"1", (SumData)ImmutableSumData.create((boolean)true, (AggregationTemporality)AggregationTemporality.CUMULATIVE, (Collection)ImmutableList.of((Object)longPointData)));
            toExport.add(longData);
        }
        this.exporter.export(toExport);
        Truth.assertThat((Iterable)argumentCaptor.getAllValues()).hasSize(2);
        CreateTimeSeriesRequest firstRequest = (CreateTimeSeriesRequest)argumentCaptor.getAllValues().get(0);
        CreateTimeSeriesRequest secondRequest = (CreateTimeSeriesRequest)argumentCaptor.getAllValues().get(1);
        Truth.assertThat((Iterable)firstRequest.getTimeSeriesList()).hasSize(200);
        Truth.assertThat((Iterable)secondRequest.getTimeSeriesList()).hasSize(50);
        for (int i = 0; i < 250; ++i) {
            TimeSeries timeSeries = i < 200 ? (TimeSeries)firstRequest.getTimeSeriesList().get(i) : (TimeSeries)secondRequest.getTimeSeriesList().get(i - 200);
            Truth.assertThat((Map)timeSeries.getResource().getLabelsMap()).hasSize(4);
            Truth.assertThat((Map)timeSeries.getResource().getLabelsMap()).containsExactly((Object)BuiltInMetricsConstant.PROJECT_ID_KEY.getKey(), (Object)projectId, new Object[]{BuiltInMetricsConstant.INSTANCE_ID_KEY.getKey(), instanceId, BuiltInMetricsConstant.LOCATION_ID_KEY.getKey(), locationId, BuiltInMetricsConstant.INSTANCE_CONFIG_ID_KEY.getKey(), instanceConfigId});
            Truth.assertThat((Map)timeSeries.getMetric().getLabelsMap()).hasSize(5);
            Truth.assertThat((Map)timeSeries.getMetric().getLabelsMap()).containsExactly((Object)BuiltInMetricsConstant.DATABASE_KEY.getKey(), (Object)databaseId, new Object[]{BuiltInMetricsConstant.CLIENT_NAME_KEY.getKey(), clientName, BuiltInMetricsConstant.DIRECT_PATH_ENABLED_KEY.getKey(), "true", BuiltInMetricsConstant.DIRECT_PATH_USED_KEY.getKey(), "true", BuiltInMetricsConstant.CLIENT_UID_KEY.getKey(), "client_uid" + i});
            Truth.assertThat((Long)timeSeries.getPoints(0).getValue().getInt64Value()).isEqualTo((Object)i);
            Truth.assertThat((Integer)timeSeries.getPoints(0).getInterval().getStartTime().getNanos()).isEqualTo((Object)startEpoch);
            Truth.assertThat((Integer)timeSeries.getPoints(0).getInterval().getEndTime().getNanos()).isEqualTo((Object)endEpoch);
        }
    }

    @Test
    public void getAggregationTemporality() throws IOException {
        SpannerCloudMonitoringExporter actualExporter = SpannerCloudMonitoringExporter.create((String)projectId, null);
        Truth.assertThat((Comparable)actualExporter.getAggregationTemporality(InstrumentType.COUNTER)).isEqualTo((Object)AggregationTemporality.CUMULATIVE);
    }

    private static class FakeMetricServiceClient
    extends MetricServiceClient {
        protected FakeMetricServiceClient(MetricServiceStub stub) {
            super(stub);
        }
    }
}

