/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.spanner.ThreadFactoryUtil;
import com.google.common.util.concurrent.SettableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ThreadFactoryUtilTest {
    @Test
    public void testCreateThreadFactory() throws Exception {
        ThreadFactory threadFactory = ThreadFactoryUtil.createVirtualOrPlatformDaemonThreadFactory((String)"test-thread", (boolean)true);
        Assert.assertNotNull((Object)threadFactory);
        SettableFuture future = SettableFuture.create();
        Thread thread = threadFactory.newThread(() -> future.set((Object)true));
        Assert.assertNotNull((Object)thread);
        Assert.assertTrue((boolean)thread.isDaemon());
        thread.start();
        Assert.assertTrue((boolean)((Boolean)future.get(1L, TimeUnit.SECONDS)));
        if (ThreadFactoryUtilTest.isJava21OrHigher()) {
            ThreadFactory virtualFactory = ThreadFactoryUtil.tryCreateVirtualThreadFactory((String)"test-thread");
            Assert.assertNotNull((Object)virtualFactory);
            Assert.assertEquals(virtualFactory.getClass(), threadFactory.getClass());
        } else {
            Assert.assertNull((Object)ThreadFactoryUtil.tryCreateVirtualThreadFactory((String)"test-thread"));
        }
    }

    @Test
    public void testTryCreateVirtualThreadPerTaskExecutor() {
        if (ThreadFactoryUtilTest.isJava21OrHigher()) {
            Assert.assertNotNull((Object)ThreadFactoryUtil.tryCreateVirtualThreadPerTaskExecutor((String)"test-virtual-thread"));
        } else {
            Assert.assertNull((Object)ThreadFactoryUtil.tryCreateVirtualThreadPerTaskExecutor((String)"test-virtual-thread"));
        }
    }

    private static boolean isJava21OrHigher() {
        String[] versionElements = System.getProperty("java.version").split("\\.");
        int majorVersion = Integer.parseInt(versionElements[0]);
        if (majorVersion == 1) {
            majorVersion = Integer.parseInt(versionElements[1]);
        }
        return majorVersion >= 21;
    }
}

