/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.connection.AbstractMockServerTest;
import com.google.cloud.spanner.connection.Connection;
import com.google.cloud.spanner.connection.DirectedReadOptionsUtil;
import com.google.cloud.spanner.connection.ITAbstractSpannerTest;
import com.google.cloud.spanner.connection.Repeat;
import com.google.cloud.spanner.connection.SpannerPool;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.ListValue;
import com.google.protobuf.Value;
import com.google.spanner.v1.DirectedReadOptions;
import com.google.spanner.v1.ExecuteSqlRequest;
import com.google.spanner.v1.ResultSetMetadata;
import com.google.spanner.v1.ResultSetStats;
import com.google.spanner.v1.StructType;
import com.google.spanner.v1.Type;
import com.google.spanner.v1.TypeCode;
import java.util.Collection;
import java.util.List;
import junit.framework.TestCase;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class DirectedReadTest
extends AbstractMockServerTest {
    private static final Statement READ_STATEMENT = Statement.of((String)"SELECT 1 AS C");
    private static final Statement GOOGLESQL_DML_STATEMENT = Statement.of((String)"INSERT INTO T (id) VALUES (1) THEN RETURN ID");
    private static final Statement POSTGRESQL_DML_STATEMENT = Statement.of((String)"INSERT INTO T (id) VALUES (1) RETURNING ID");
    @Parameterized.Parameter
    public Dialect dialect;
    private Dialect currentDialect;

    @Parameterized.Parameters(name="dialect = {0}")
    public static Collection<Object[]> data() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Dialect dialect : Dialect.values()) {
            builder.add((Object)new Object[]{dialect});
        }
        return builder.build();
    }

    @BeforeClass
    public static void setupQueryResults() {
        com.google.spanner.v1.ResultSet resultSet = com.google.spanner.v1.ResultSet.newBuilder().setMetadata(ResultSetMetadata.newBuilder().setRowType(StructType.newBuilder().addFields(StructType.Field.newBuilder().setName("C").setType(Type.newBuilder().setCode(TypeCode.INT64).build()).build()).build()).build()).addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("1").build()).build()).build();
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(READ_STATEMENT, resultSet));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(GOOGLESQL_DML_STATEMENT, resultSet.toBuilder().setStats(ResultSetStats.newBuilder().setRowCountExact(1L).build()).build()));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(POSTGRESQL_DML_STATEMENT, resultSet.toBuilder().setStats(ResultSetStats.newBuilder().setRowCountExact(1L).build()).build()));
    }

    @Before
    public void setupDialect() {
        if (this.currentDialect != this.dialect) {
            SpannerPool.closeSpannerPool();
            mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.detectDialectResult(this.dialect));
            this.currentDialect = this.dialect;
        }
    }

    private String getVariablePrefix() {
        return this.dialect == Dialect.POSTGRESQL ? "spanner." : "";
    }

    private Statement getDmlStatement() {
        return this.dialect == Dialect.POSTGRESQL ? POSTGRESQL_DML_STATEMENT : GOOGLESQL_DML_STATEMENT;
    }

    @After
    public void clearRequests() {
        mockSpanner.clearRequests();
    }

    @Test
    public void testNoDirectedReadByDefault() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            for (boolean readOnly : new boolean[]{true, false}) {
                for (boolean autocommit : new boolean[]{true, false}) {
                    connection.setAutocommit(autocommit);
                    connection.setReadOnly(readOnly);
                    this.executeReadQuery(connection);
                    this.assertDirectedReadOptions(DirectedReadOptions.getDefaultInstance());
                    if (!autocommit) {
                        connection.commit();
                    }
                    mockSpanner.clearRequests();
                }
            }
        }
    }

    @Test
    public void testSetDirectedRead() {
        for (DirectedReadOptions expected : new DirectedReadOptions[]{DirectedReadOptions.newBuilder().setIncludeReplicas(DirectedReadOptions.IncludeReplicas.newBuilder().addReplicaSelections(DirectedReadOptions.ReplicaSelection.newBuilder().setLocation("eu-west1").setType(DirectedReadOptions.ReplicaSelection.Type.READ_ONLY).build()).build()).build(), DirectedReadOptions.newBuilder().setExcludeReplicas(DirectedReadOptions.ExcludeReplicas.newBuilder().addReplicaSelections(DirectedReadOptions.ReplicaSelection.newBuilder().setLocation("eu-west1").setType(DirectedReadOptions.ReplicaSelection.Type.READ_ONLY).build()).build()).build(), DirectedReadOptions.newBuilder().build()}) {
            try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
                connection.setAutocommit(true);
                connection.execute(Statement.of((String)String.format("set %sdirected_read='%s'", this.getVariablePrefix(), DirectedReadOptionsUtil.toString((DirectedReadOptions)expected))));
                Repeat.twice(() -> {
                    this.executeReadQuery(connection);
                    this.assertDirectedReadOptions(expected);
                    mockSpanner.clearRequests();
                });
                connection.execute(Statement.of((String)String.format("set %sdirected_read=''", this.getVariablePrefix())));
                this.executeReadQuery(connection);
                this.assertDirectedReadOptions(DirectedReadOptions.getDefaultInstance());
                mockSpanner.clearRequests();
            }
        }
    }

    @Test
    public void testDirectedReadIsIgnoredForDmlInAutoCommit() {
        DirectedReadOptions options = DirectedReadOptions.newBuilder().setExcludeReplicas(DirectedReadOptions.ExcludeReplicas.newBuilder().addReplicaSelections(DirectedReadOptions.ReplicaSelection.newBuilder().setLocation("eu-west1").setType(DirectedReadOptions.ReplicaSelection.Type.READ_ONLY).build()).build()).build();
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            connection.execute(Statement.of((String)String.format("set %sdirected_read='%s'", this.getVariablePrefix(), DirectedReadOptionsUtil.toString((DirectedReadOptions)options))));
            this.executeDmlQuery(connection);
            this.assertDirectedReadOptions(DirectedReadOptions.getDefaultInstance());
        }
    }

    @Test
    public void testDirectedReadIsIgnoredInReadWriteTransaction() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(false);
            connection.setReadOnly(false);
            for (Statement statement : new Statement[]{READ_STATEMENT, this.getDmlStatement()}) {
                connection.execute(Statement.of((String)String.format("set %sdirected_read='%s'", this.getVariablePrefix(), DirectedReadOptionsUtil.toString((DirectedReadOptions)DirectedReadOptions.newBuilder().setIncludeReplicas(DirectedReadOptions.IncludeReplicas.newBuilder().addReplicaSelections(DirectedReadOptions.ReplicaSelection.newBuilder().setType(DirectedReadOptions.ReplicaSelection.Type.READ_WRITE).setLocation("us-west1").build()).build()).build()))));
                this.executeQuery(connection, statement);
                this.assertDirectedReadOptions(DirectedReadOptions.getDefaultInstance());
                connection.commit();
                mockSpanner.clearRequests();
            }
        }
    }

    @Test
    public void testDirectedReadIsUsedInReadOnlyTransaction() {
        DirectedReadOptions expected = DirectedReadOptions.newBuilder().setIncludeReplicas(DirectedReadOptions.IncludeReplicas.newBuilder().addReplicaSelections(DirectedReadOptions.ReplicaSelection.newBuilder().setType(DirectedReadOptions.ReplicaSelection.Type.READ_WRITE).setLocation("us-west1").build()).build()).build();
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(false);
            connection.setReadOnly(true);
            connection.execute(Statement.of((String)String.format("set %sdirected_read='%s'", this.getVariablePrefix(), DirectedReadOptionsUtil.toString((DirectedReadOptions)expected))));
            Repeat.twice(() -> {
                this.executeReadQuery(connection);
                this.assertDirectedReadOptions(expected);
                mockSpanner.clearRequests();
            });
        }
    }

    private void executeReadQuery(Connection connection) {
        this.executeQuery(connection, READ_STATEMENT);
    }

    private void executeDmlQuery(Connection connection) {
        this.executeQuery(connection, this.getDmlStatement());
    }

    private void executeQuery(Connection connection, Statement statement) {
        try (ResultSet resultSet = connection.executeQuery(statement, new Options.QueryOption[0]);){
            while (resultSet.next()) {
            }
        }
    }

    private void assertDirectedReadOptions(DirectedReadOptions expected) {
        List<ExecuteSqlRequest> requests = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class);
        TestCase.assertEquals((int)1, (int)requests.size());
        ExecuteSqlRequest request = requests.get(0);
        TestCase.assertEquals((Object)expected, (Object)request.getDirectedReadOptions());
    }
}

