/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.SpannerApiFutures;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.connection.AbstractStatementParser;
import com.google.cloud.spanner.connection.AnalyzeMode;
import com.google.cloud.spanner.connection.DmlBatch;
import com.google.cloud.spanner.connection.StatementExecutor;
import com.google.cloud.spanner.connection.UnitOfWork;
import io.opentelemetry.api.trace.Span;
import java.util.Arrays;
import java.util.Collections;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class DmlBatchTest {
    private final AbstractStatementParser.ParsedStatement statement1 = AbstractStatementParser.getInstance((Dialect)Dialect.GOOGLE_STANDARD_SQL).parse(Statement.of((String)"UPDATE FOO SET BAR=1 WHERE BAZ=2"));
    private final AbstractStatementParser.ParsedStatement statement2 = AbstractStatementParser.getInstance((Dialect)Dialect.GOOGLE_STANDARD_SQL).parse(Statement.of((String)"UPDATE FOO SET BAR=2 WHERE BAZ=3"));

    private DmlBatch createSubject() {
        UnitOfWork transaction = (UnitOfWork)Mockito.mock(UnitOfWork.class);
        Mockito.when((Object)transaction.executeBatchUpdateAsync((UnitOfWork.CallType)ArgumentMatchers.any(), (Iterable)ArgumentMatchers.eq(Arrays.asList(this.statement1, this.statement2)), new Options.UpdateOption[0])).thenReturn((Object)ApiFutures.immediateFuture((Object)new long[]{3L, 5L}));
        return this.createSubject(transaction);
    }

    private DmlBatch createSubject(UnitOfWork transaction) {
        return ((DmlBatch.Builder)((DmlBatch.Builder)DmlBatch.newBuilder().setTransaction(transaction).withStatementExecutor(new StatementExecutor())).setSpan(Span.getInvalid())).build();
    }

    @Test
    public void testExecuteQuery() {
        DmlBatch batch = this.createSubject();
        try {
            batch.executeQueryAsync(UnitOfWork.CallType.SYNC, (AbstractStatementParser.ParsedStatement)Mockito.mock(AbstractStatementParser.ParsedStatement.class), AnalyzeMode.NONE, new Options.QueryOption[0]);
            Assert.fail((String)"Expected exception");
        }
        catch (SpannerException e) {
            Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)e.getErrorCode());
        }
    }

    @Test
    public void testExecuteDdl() {
        DmlBatch batch = this.createSubject();
        try {
            batch.executeDdlAsync(UnitOfWork.CallType.SYNC, (AbstractStatementParser.ParsedStatement)Mockito.mock(AbstractStatementParser.ParsedStatement.class));
            Assert.fail((String)"Expected exception");
        }
        catch (SpannerException e) {
            Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)e.getErrorCode());
        }
    }

    @Test
    public void testGetReadTimestamp() {
        DmlBatch batch = this.createSubject();
        SpannerApiFutures.get((ApiFuture)batch.runBatchAsync(UnitOfWork.CallType.SYNC));
        try {
            batch.getReadTimestamp();
            Assert.fail((String)"Expected exception");
        }
        catch (SpannerException e) {
            Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)e.getErrorCode());
        }
    }

    @Test
    public void testIsReadOnly() {
        DmlBatch batch = this.createSubject();
        MatcherAssert.assertThat((Object)batch.isReadOnly(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testGetCommitTimestamp() {
        DmlBatch batch = this.createSubject();
        SpannerApiFutures.get((ApiFuture)batch.runBatchAsync(UnitOfWork.CallType.SYNC));
        try {
            batch.getCommitTimestamp();
            Assert.fail((String)"Expected exception");
        }
        catch (SpannerException e) {
            Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)e.getErrorCode());
        }
    }

    @Test
    public void testGetCommitResponse() {
        DmlBatch batch = this.createSubject();
        SpannerApiFutures.get((ApiFuture)batch.runBatchAsync(UnitOfWork.CallType.SYNC));
        try {
            batch.getCommitResponse();
            Assert.fail((String)"Expected exception");
        }
        catch (SpannerException e) {
            Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)e.getErrorCode());
        }
    }

    @Test
    public void testGetCommitResponseOrNull() {
        DmlBatch batch = this.createSubject();
        SpannerApiFutures.get((ApiFuture)batch.runBatchAsync(UnitOfWork.CallType.SYNC));
        Assert.assertNull((Object)batch.getCommitResponseOrNull());
    }

    @Test
    public void testWriteIterable() {
        DmlBatch batch = this.createSubject();
        try {
            batch.writeAsync(UnitOfWork.CallType.SYNC, Collections.singletonList(Mutation.newInsertBuilder((String)"foo").build()));
            Assert.fail((String)"Expected exception");
        }
        catch (SpannerException e) {
            Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)e.getErrorCode());
        }
    }

    @Test
    public void testGetStateAndIsActive() {
        DmlBatch batch = this.createSubject();
        MatcherAssert.assertThat((Object)batch.getState(), (Matcher)CoreMatchers.is((Object)UnitOfWork.UnitOfWorkState.STARTED));
        MatcherAssert.assertThat((Object)batch.isActive(), (Matcher)CoreMatchers.is((Object)true));
        SpannerApiFutures.get((ApiFuture)batch.runBatchAsync(UnitOfWork.CallType.SYNC));
        MatcherAssert.assertThat((Object)batch.getState(), (Matcher)CoreMatchers.is((Object)UnitOfWork.UnitOfWorkState.RAN));
        MatcherAssert.assertThat((Object)batch.isActive(), (Matcher)CoreMatchers.is((Object)false));
        batch = this.createSubject();
        MatcherAssert.assertThat((Object)batch.getState(), (Matcher)CoreMatchers.is((Object)UnitOfWork.UnitOfWorkState.STARTED));
        MatcherAssert.assertThat((Object)batch.isActive(), (Matcher)CoreMatchers.is((Object)true));
        batch.abortBatch();
        MatcherAssert.assertThat((Object)batch.getState(), (Matcher)CoreMatchers.is((Object)UnitOfWork.UnitOfWorkState.ABORTED));
        MatcherAssert.assertThat((Object)batch.isActive(), (Matcher)CoreMatchers.is((Object)false));
        UnitOfWork tx = (UnitOfWork)Mockito.mock(UnitOfWork.class);
        Mockito.when((Object)tx.executeBatchUpdateAsync((UnitOfWork.CallType)ArgumentMatchers.any(), (Iterable)Mockito.anyList(), new Options.UpdateOption[0])).thenReturn((Object)ApiFutures.immediateFailedFuture((Throwable)((Throwable)Mockito.mock(SpannerException.class))));
        batch = this.createSubject(tx);
        MatcherAssert.assertThat((Object)batch.getState(), (Matcher)CoreMatchers.is((Object)UnitOfWork.UnitOfWorkState.STARTED));
        MatcherAssert.assertThat((Object)batch.isActive(), (Matcher)CoreMatchers.is((Object)true));
        AbstractStatementParser.ParsedStatement statement = (AbstractStatementParser.ParsedStatement)Mockito.mock(AbstractStatementParser.ParsedStatement.class);
        Mockito.when((Object)statement.getStatement()).thenReturn((Object)Statement.of((String)"UPDATE TEST SET COL1=2"));
        Mockito.when((Object)statement.getSqlWithoutComments()).thenReturn((Object)"UPDATE TEST SET COL1=2");
        Mockito.when((Object)statement.getType()).thenReturn((Object)AbstractStatementParser.StatementType.UPDATE);
        SpannerApiFutures.get((ApiFuture)batch.executeUpdateAsync(UnitOfWork.CallType.SYNC, statement, new Options.UpdateOption[0]));
        boolean exception = false;
        try {
            SpannerApiFutures.get((ApiFuture)batch.runBatchAsync(UnitOfWork.CallType.SYNC));
        }
        catch (SpannerException e) {
            exception = true;
        }
        MatcherAssert.assertThat((Object)exception, (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)batch.getState(), (Matcher)CoreMatchers.is((Object)UnitOfWork.UnitOfWorkState.RUN_FAILED));
        MatcherAssert.assertThat((Object)batch.isActive(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testCommit() {
        DmlBatch batch = this.createSubject();
        try {
            batch.commitAsync(UnitOfWork.CallType.SYNC);
            Assert.fail((String)"Expected exception");
        }
        catch (SpannerException e) {
            Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)e.getErrorCode());
        }
    }

    @Test
    public void testRollback() {
        DmlBatch batch = this.createSubject();
        try {
            batch.rollbackAsync(UnitOfWork.CallType.SYNC);
            Assert.fail((String)"Expected exception");
        }
        catch (SpannerException e) {
            Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)e.getErrorCode());
        }
    }
}

