/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.ForwardingResultSet;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.ResultSetsHelper;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.connection.Connection;
import com.google.cloud.spanner.connection.MergedResultSet;
import com.google.cloud.spanner.connection.RandomResultSetGenerator;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class MergedResultSetTest {
    @Parameterized.Parameter(value=0)
    public int numPartitions;
    @Parameterized.Parameter(value=1)
    public int maxRowsPerPartition;
    @Parameterized.Parameter(value=2)
    public int maxParallelism;

    @Parameterized.Parameters(name="numPartitions = {0}, maxRowsPerPartition = {1}, maxParallelism = {2}")
    public static Collection<Object[]> parameters() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (int numPartitions : new int[]{0, 1, 2, 5, 8}) {
            for (int maxRowsPerPartition : new int[]{0, 1, 5, 10, 100}) {
                for (int maxParallelism : new int[]{0, 1, 2, 4, 8}) {
                    params.add(new Object[]{numPartitions, maxRowsPerPartition, maxParallelism});
                }
            }
        }
        return params;
    }

    private MockedResults setupResults(boolean withErrors) {
        Random random = new Random();
        Connection connection = (Connection)Mockito.mock(Connection.class);
        ArrayList<String> partitions = new ArrayList<String>();
        ArrayList<Struct> allRows = new ArrayList<Struct>();
        int minErrorIndex = Integer.MAX_VALUE;
        for (int index = 0; index < this.numPartitions; ++index) {
            String partition = String.valueOf(index);
            partitions.add(partition);
            int numRows = this.maxRowsPerPartition == 0 ? 0 : random.nextInt(this.maxRowsPerPartition) + 1;
            RandomResultSetGenerator generator = new RandomResultSetGenerator(numRows);
            com.google.spanner.v1.ResultSet proto = generator.generate();
            if (withErrors) {
                int errorIndex = numRows == 0 ? 0 : random.nextInt(numRows);
                minErrorIndex = Math.min(minErrorIndex, errorIndex);
                Mockito.when((Object)connection.runPartition(partition)).thenReturn((Object)new ResultSetWithError(ResultSetsHelper.fromProto(proto), errorIndex));
                continue;
            }
            Mockito.when((Object)connection.runPartition(partition)).thenReturn((Object)ResultSetsHelper.fromProto(proto));
            try (ResultSet resultSet = ResultSetsHelper.fromProto(proto);){
                while (resultSet.next()) {
                    allRows.add(resultSet.getCurrentRowAsStruct());
                }
                continue;
            }
        }
        return new MockedResults(connection, partitions, allRows, minErrorIndex);
    }

    @Test
    public void testAllResultsAreReturned() {
        MockedResults results = this.setupResults(false);
        BitSet rowsFound = new BitSet(results.allRows.size());
        try (MergedResultSet resultSet = new MergedResultSet(results.connection, results.partitions, this.maxParallelism);){
            while (resultSet.next()) {
                this.assertRowExists(results.allRows, resultSet.getCurrentRowAsStruct(), rowsFound);
            }
            Assert.assertNotNull((Object)resultSet.getMetadata());
            if (this.numPartitions == 0) {
                Assert.assertEquals((long)0L, (long)resultSet.getColumnCount());
            } else {
                Assert.assertEquals((long)24L, (long)resultSet.getColumnCount());
                Assert.assertEquals((Object)Type.bool(), (Object)resultSet.getColumnType(0));
                Assert.assertEquals((Object)Type.bool(), (Object)resultSet.getColumnType("COL0"));
                Assert.assertEquals((long)10L, (long)resultSet.getColumnIndex("COL10"));
            }
            Assert.assertEquals((long)results.allRows.size(), (long)rowsFound.nextClearBit(0));
            Assert.assertEquals((long)this.numPartitions, (long)resultSet.getNumPartitions());
            if (this.maxParallelism > 0) {
                Assert.assertEquals((long)Math.min(this.numPartitions, this.maxParallelism), (long)resultSet.getParallelism());
            } else {
                int processors = Runtime.getRuntime().availableProcessors();
                Assert.assertEquals((long)Math.min(this.numPartitions, processors), (long)resultSet.getParallelism());
            }
        }
    }

    @Test
    public void testResultSetStopsAfterFirstError() {
        MockedResults results = this.setupResults(true);
        try (MergedResultSet resultSet = new MergedResultSet(results.connection, results.partitions, this.maxParallelism);){
            if (this.numPartitions > 0) {
                AtomicInteger rowCount = new AtomicInteger();
                SpannerException exception = (SpannerException)Assert.assertThrows(SpannerException.class, () -> {
                    while (resultSet.next()) {
                        rowCount.getAndIncrement();
                    }
                });
                Assert.assertEquals((Object)ErrorCode.INTERNAL, (Object)exception.getErrorCode());
                Assert.assertTrue((String)exception.getMessage(), (boolean)exception.getMessage().contains("test error"));
                SpannerException nextException = (SpannerException)Assert.assertThrows(SpannerException.class, () -> ((MergedResultSet)resultSet).next());
                Assert.assertEquals((Object)((Object)exception), (Object)((Object)nextException));
                Assert.assertTrue((rowCount.get() >= results.minErrorIndex ? 1 : 0) != 0);
            }
        }
    }

    private void assertRowExists(List<Struct> expectedRows, Struct row, BitSet rowsFound) {
        for (int i = 0; i < expectedRows.size(); ++i) {
            if (!row.equals((Object)expectedRows.get(i))) continue;
            rowsFound.set(i);
            return;
        }
        Assert.fail((String)("row not found: " + row));
    }

    private static final class ResultSetWithError
    extends ForwardingResultSet {
        private final int errorIndex;
        private int currentIndex = 0;

        ResultSetWithError(ResultSet delegate, int errorIndex) {
            super(delegate);
            this.errorIndex = errorIndex;
        }

        public boolean next() {
            if (this.currentIndex == this.errorIndex) {
                throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.INTERNAL, (String)"test error");
            }
            ++this.currentIndex;
            return super.next();
        }
    }

    private static final class MockedResults {
        final Connection connection;
        final List<String> partitions;
        final List<Struct> allRows;
        final int minErrorIndex;

        MockedResults(Connection connection, List<String> partitions, List<Struct> allRows, int minErrorIndex) {
            this.connection = connection;
            this.partitions = partitions;
            this.allRows = allRows;
            this.minErrorIndex = minErrorIndex;
        }
    }
}

