/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.ResultSets;
import com.google.cloud.spanner.SingerProto;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.connection.ReplaceableForwardingResultSet;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.ProtocolMessageEnum;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class ReplaceableForwardingResultSetTest {
    private ReplaceableForwardingResultSet createSubject() {
        ResultSet delegate = ResultSets.forRows((Type)Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"test", (Type)Type.int64())}), Collections.singletonList(((Struct.Builder)Struct.newBuilder().set("test").to(1L)).build()));
        return new ReplaceableForwardingResultSet(delegate);
    }

    @Test
    public void testReplace() {
        ResultSet delegate1 = ResultSets.forRows((Type)Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"test", (Type)Type.int64())}), Arrays.asList(((Struct.Builder)Struct.newBuilder().set("test").to(1L)).build(), ((Struct.Builder)Struct.newBuilder().set("test").to(2L)).build()));
        try (ReplaceableForwardingResultSet rs = new ReplaceableForwardingResultSet(delegate1);){
            MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)true));
            MatcherAssert.assertThat((Object)rs.getLong("test"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1L)));
            MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)true));
            MatcherAssert.assertThat((Object)rs.getLong("test"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)2L)));
            MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)false));
        }
        delegate1 = ResultSets.forRows((Type)Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"test", (Type)Type.int64())}), Arrays.asList(((Struct.Builder)Struct.newBuilder().set("test").to(1L)).build(), ((Struct.Builder)Struct.newBuilder().set("test").to(2L)).build()));
        ResultSet delegate2 = ResultSets.forRows((Type)Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"test", (Type)Type.int64())}), Arrays.asList(((Struct.Builder)Struct.newBuilder().set("test").to(1L)).build(), ((Struct.Builder)Struct.newBuilder().set("test").to(3L)).build()));
        try (ReplaceableForwardingResultSet rs = new ReplaceableForwardingResultSet(delegate1);){
            MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)true));
            MatcherAssert.assertThat((Object)rs.getLong("test"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1L)));
            delegate2.next();
            rs.replaceDelegate(delegate2);
            MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)true));
            MatcherAssert.assertThat((Object)rs.getLong("test"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)3L)));
            MatcherAssert.assertThat((Object)rs.next(), (Matcher)CoreMatchers.is((Object)false));
        }
    }

    @Test
    public void testMethodCallBeforeNext() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        List<String> excludedMethods = Arrays.asList("canGetProtobufValue", "getStats", "getMetadata", "next", "close", "equals", "hashCode");
        ReplaceableForwardingResultSet subject = this.createSubject();
        this.callMethods(subject, excludedMethods, IllegalStateException.class);
    }

    @Test
    public void testMethodCallAfterClose() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        List<String> excludedMethods = Arrays.asList("canGetProtobufValue", "getStats", "getMetadata", "next", "close", "getType", "getColumnCount", "getColumnIndex", "getColumnType", "ofResultSet", "equals", "hashCode");
        ReplaceableForwardingResultSet subject = this.createSubject();
        subject.next();
        subject.close();
        this.callMethods(subject, excludedMethods, SpannerException.class);
    }

    @Test
    public void testMethodCallAfterNextHasReturnedFalse() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        List<String> excludedMethods = Arrays.asList("canGetProtobufValue", "getStats", "getMetadata", "next", "close", "getType", "getColumnCount", "getColumnIndex", "getColumnType", "ofResultSet", "equals", "hashCode");
        ReplaceableForwardingResultSet subject = this.createSubject();
        subject.next();
        subject.next();
        this.callMethods(subject, excludedMethods, IndexOutOfBoundsException.class);
    }

    private void callMethods(ReplaceableForwardingResultSet subject, List<String> excludedMethods, Class<? extends Exception> expectedException) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        for (Method method : ReplaceableForwardingResultSet.class.getDeclaredMethods()) {
            if (!Modifier.isPublic(method.getModifiers()) || excludedMethods.contains(method.getName())) continue;
            boolean exception = false;
            int numberOfParameters = method.getParameterTypes().length;
            Class<?> firstParameterType = null;
            if (numberOfParameters >= 1) {
                firstParameterType = method.getParameterTypes()[0];
            }
            try {
                switch (numberOfParameters) {
                    case 0: {
                        method.invoke((Object)subject, new Object[0]);
                        break;
                    }
                    case 1: {
                        if (firstParameterType == String.class) {
                            method.invoke((Object)subject, "test");
                            break;
                        }
                        if (firstParameterType == Integer.TYPE) {
                            method.invoke((Object)subject, 0);
                            break;
                        }
                        Assert.fail((String)"unknown parameter type");
                        break;
                    }
                    case 2: {
                        Class<?> secondParameterType = method.getParameterTypes()[1];
                        Object firstArgument = null;
                        Object secondArgument = null;
                        if (firstParameterType == String.class) {
                            firstArgument = "test";
                        } else if (firstParameterType == Integer.TYPE) {
                            firstArgument = 0;
                        }
                        if (secondParameterType == Function.class) {
                            Function<Long, ProtocolMessageEnum> lambdaFunction = val -> SingerProto.Genre.forNumber(val.intValue());
                            secondArgument = lambdaFunction;
                        } else if (secondParameterType == AbstractMessage.class) {
                            secondArgument = SingerProto.SingerInfo.getDefaultInstance();
                        }
                        if (firstArgument != null && secondArgument != null) {
                            method.invoke((Object)subject, firstArgument, secondArgument);
                            break;
                        }
                        Assert.fail((String)"unknown parameter type");
                        break;
                    }
                    default: {
                        Assert.fail((String)"method with more than 2 parameters is unknown");
                        break;
                    }
                }
            }
            catch (InvocationTargetException e) {
                if (e.getCause().getClass().equals(expectedException)) {
                    exception = true;
                }
                throw e;
            }
            MatcherAssert.assertThat((String)(method.getName() + " did not throw an IllegalStateException"), (Object)exception, (Matcher)CoreMatchers.is((Object)true));
        }
    }

    @Test
    public void testValidMethodCall() throws IllegalArgumentException {
        ResultSet delegate = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)delegate.next()).thenReturn((Object)true, (Object[])new Boolean[]{true, false});
        try (ReplaceableForwardingResultSet subject = new ReplaceableForwardingResultSet(delegate);){
            subject.next();
            subject.getBoolean(0);
            ((ResultSet)Mockito.verify((Object)delegate)).getBoolean(0);
            subject.getBoolean("test0");
            ((ResultSet)Mockito.verify((Object)delegate)).getBoolean("test0");
            subject.getBooleanArray(1);
            ((ResultSet)Mockito.verify((Object)delegate)).getBooleanArray(1);
            subject.getBooleanArray("test1");
            ((ResultSet)Mockito.verify((Object)delegate)).getBooleanArray("test1");
            subject.getBooleanList(2);
            ((ResultSet)Mockito.verify((Object)delegate)).getBooleanList(2);
            subject.getBooleanList("test2");
            ((ResultSet)Mockito.verify((Object)delegate)).getBooleanList("test2");
            subject.getBytes(0);
            ((ResultSet)Mockito.verify((Object)delegate)).getBytes(0);
            subject.getBytes("test0");
            ((ResultSet)Mockito.verify((Object)delegate)).getBytes("test0");
            subject.getBytesList(2);
            ((ResultSet)Mockito.verify((Object)delegate)).getBytesList(2);
            subject.getBytesList("test2");
            ((ResultSet)Mockito.verify((Object)delegate)).getBytesList("test2");
            subject.getDate(0);
            ((ResultSet)Mockito.verify((Object)delegate)).getDate(0);
            subject.getDate("test0");
            ((ResultSet)Mockito.verify((Object)delegate)).getDate("test0");
            subject.getDateList(2);
            ((ResultSet)Mockito.verify((Object)delegate)).getDateList(2);
            subject.getDateList("test2");
            ((ResultSet)Mockito.verify((Object)delegate)).getDateList("test2");
            subject.getDouble(0);
            ((ResultSet)Mockito.verify((Object)delegate)).getDouble(0);
            subject.getDouble("test0");
            ((ResultSet)Mockito.verify((Object)delegate)).getDouble("test0");
            subject.getDoubleArray(1);
            ((ResultSet)Mockito.verify((Object)delegate)).getDoubleArray(1);
            subject.getDoubleArray("test1");
            ((ResultSet)Mockito.verify((Object)delegate)).getDoubleArray("test1");
            subject.getDoubleList(2);
            ((ResultSet)Mockito.verify((Object)delegate)).getDoubleList(2);
            subject.getDoubleList("test2");
            ((ResultSet)Mockito.verify((Object)delegate)).getDoubleList("test2");
            subject.getBigDecimal(0);
            ((ResultSet)Mockito.verify((Object)delegate)).getBigDecimal(0);
            subject.getBigDecimal("test0");
            ((ResultSet)Mockito.verify((Object)delegate)).getBigDecimal("test0");
            subject.getBigDecimalList(1);
            ((ResultSet)Mockito.verify((Object)delegate)).getBigDecimalList(1);
            subject.getBigDecimalList("test1");
            ((ResultSet)Mockito.verify((Object)delegate)).getBigDecimalList("test1");
            subject.getBigDecimalList(2);
            ((ResultSet)Mockito.verify((Object)delegate)).getBigDecimalList(2);
            subject.getBigDecimalList("test2");
            ((ResultSet)Mockito.verify((Object)delegate)).getBigDecimalList("test2");
            subject.getLong(0);
            ((ResultSet)Mockito.verify((Object)delegate)).getLong(0);
            subject.getLong("test0");
            ((ResultSet)Mockito.verify((Object)delegate)).getLong("test0");
            subject.getLongArray(1);
            ((ResultSet)Mockito.verify((Object)delegate)).getLongArray(1);
            subject.getLongArray("test1");
            ((ResultSet)Mockito.verify((Object)delegate)).getLongArray("test1");
            subject.getLongList(2);
            ((ResultSet)Mockito.verify((Object)delegate)).getLongList(2);
            subject.getLongList("test2");
            ((ResultSet)Mockito.verify((Object)delegate)).getLongList("test2");
            subject.getString(0);
            ((ResultSet)Mockito.verify((Object)delegate)).getString(0);
            subject.getString("test0");
            ((ResultSet)Mockito.verify((Object)delegate)).getString("test0");
            subject.getStringList(2);
            ((ResultSet)Mockito.verify((Object)delegate)).getStringList(2);
            subject.getStringList("test2");
            ((ResultSet)Mockito.verify((Object)delegate)).getStringList("test2");
            subject.getJson(0);
            ((ResultSet)Mockito.verify((Object)delegate)).getJson(0);
            subject.getJson("test0");
            ((ResultSet)Mockito.verify((Object)delegate)).getJson("test0");
            subject.getJsonList(2);
            ((ResultSet)Mockito.verify((Object)delegate)).getJsonList(2);
            subject.getJsonList("test2");
            ((ResultSet)Mockito.verify((Object)delegate)).getJsonList("test2");
            subject.getProtoMessage(0, (AbstractMessage)SingerProto.SingerInfo.getDefaultInstance());
            ((ResultSet)Mockito.verify((Object)delegate)).getProtoMessage(0, (AbstractMessage)SingerProto.SingerInfo.getDefaultInstance());
            subject.getProtoMessage("test0", (AbstractMessage)SingerProto.SingerInfo.getDefaultInstance());
            ((ResultSet)Mockito.verify((Object)delegate)).getProtoMessage("test0", (AbstractMessage)SingerProto.SingerInfo.getDefaultInstance());
            subject.getProtoMessageList(0, (AbstractMessage)SingerProto.SingerInfo.getDefaultInstance());
            ((ResultSet)Mockito.verify((Object)delegate)).getProtoMessageList(0, (AbstractMessage)SingerProto.SingerInfo.getDefaultInstance());
            subject.getProtoMessageList("test0", (AbstractMessage)SingerProto.SingerInfo.getDefaultInstance());
            ((ResultSet)Mockito.verify((Object)delegate)).getProtoMessageList("test0", (AbstractMessage)SingerProto.SingerInfo.getDefaultInstance());
            Function<Integer, ProtocolMessageEnum> lambdaFunction = SingerProto.Genre::forNumber;
            subject.getProtoEnum(0, lambdaFunction);
            ((ResultSet)Mockito.verify((Object)delegate)).getProtoEnum(0, lambdaFunction);
            subject.getProtoEnum("test0", lambdaFunction);
            ((ResultSet)Mockito.verify((Object)delegate)).getProtoEnum("test0", lambdaFunction);
            subject.getProtoEnumList(0, lambdaFunction);
            ((ResultSet)Mockito.verify((Object)delegate)).getProtoEnumList(0, lambdaFunction);
            subject.getProtoEnumList("test0", lambdaFunction);
            ((ResultSet)Mockito.verify((Object)delegate)).getProtoEnumList("test0", lambdaFunction);
            subject.getStructList(0);
            subject.getStructList("test0");
            subject.getTimestamp(0);
            ((ResultSet)Mockito.verify((Object)delegate)).getTimestamp(0);
            subject.getTimestamp("test0");
            ((ResultSet)Mockito.verify((Object)delegate)).getTimestamp("test0");
            subject.getTimestampList(2);
            ((ResultSet)Mockito.verify((Object)delegate)).getTimestampList(2);
            subject.getTimestampList("test2");
            ((ResultSet)Mockito.verify((Object)delegate)).getTimestampList("test2");
            subject.getColumnCount();
            ((ResultSet)Mockito.verify((Object)delegate)).getColumnCount();
            subject.getColumnIndex("test");
            ((ResultSet)Mockito.verify((Object)delegate)).getColumnIndex("test");
            subject.getColumnType(100);
            ((ResultSet)Mockito.verify((Object)delegate)).getColumnType(100);
            subject.getColumnType("test");
            ((ResultSet)Mockito.verify((Object)delegate)).getColumnType("test");
            subject.getCurrentRowAsStruct();
            ((ResultSet)Mockito.verify((Object)delegate)).getCurrentRowAsStruct();
            subject.getType();
            ((ResultSet)Mockito.verify((Object)delegate)).getType();
            subject.isNull(50);
            ((ResultSet)Mockito.verify((Object)delegate)).isNull(50);
            subject.isNull("test");
            ((ResultSet)Mockito.verify((Object)delegate)).isNull("test");
            while (subject.next()) {
            }
            subject.getStats();
            ((ResultSet)Mockito.verify((Object)delegate)).getStats();
        }
    }
}

