/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection.it;

import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ParallelIntegrationTest;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.connection.ITAbstractSpannerTest;
import com.google.cloud.spanner.connection.SavepointSupport;
import com.google.common.collect.ImmutableList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@Category(value={ParallelIntegrationTest.class})
@RunWith(value=JUnit4.class)
public class ITSavepointTest
extends ITAbstractSpannerTest {
    @Override
    public void appendConnectionUri(StringBuilder uri) {
        uri.append(";autocommit=false");
    }

    @Override
    public boolean doCreateDefaultTestTable() {
        return true;
    }

    @Before
    public void clearTestData() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.bufferedWrite(Mutation.delete((String)"TEST", (KeySet)KeySet.all()));
            connection.commit();
        }
    }

    @Test
    public void testRollbackDmlStatement() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setSavepointSupport(SavepointSupport.ENABLED);
            Assert.assertEquals((long)1L, (long)connection.executeUpdate(((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)"insert into test (id, name) values (@id, @name)").bind("id").to(1L)).bind("name").to("One")).build()));
            connection.savepoint("s1");
            Assert.assertEquals((long)1L, (long)connection.executeUpdate(((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)"insert into test (id, name) values (@id, @name)").bind("id").to(2L)).bind("name").to("Two")).build()));
            connection.rollbackToSavepoint("s1");
            connection.commit();
            try (ResultSet resultSet = connection.executeQuery(Statement.of((String)"select * from test"), new Options.QueryOption[0]);){
                Assert.assertTrue((boolean)resultSet.next());
                Assert.assertEquals((long)1L, (long)resultSet.getLong(0));
                Assert.assertEquals((Object)"One", (Object)resultSet.getString(1));
                Assert.assertFalse((boolean)resultSet.next());
            }
        }
    }

    @Test
    public void testRollbackMutations() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setSavepointSupport(SavepointSupport.ENABLED);
            connection.bufferedWrite(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"test").set("id").to(1L)).set("name").to("One")).build());
            connection.savepoint("s1");
            connection.bufferedWrite(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"test").set("id").to(2L)).set("name").to("Two")).build());
            connection.savepoint("s2");
            connection.bufferedWrite(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"test").set("id").to(3L)).set("name").to("Three")).build());
            connection.savepoint("s3");
            connection.bufferedWrite(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"test").set("id").to(4L)).set("name").to("Four")).build());
            connection.savepoint("s4");
            connection.rollbackToSavepoint("s2");
            connection.commit();
            try (ResultSet resultSet = connection.executeQuery(Statement.of((String)"select * from test order by id"), new Options.QueryOption[0]);){
                Assert.assertTrue((boolean)resultSet.next());
                Assert.assertEquals((long)1L, (long)resultSet.getLong(0));
                Assert.assertEquals((Object)"One", (Object)resultSet.getString(1));
                Assert.assertTrue((boolean)resultSet.next());
                Assert.assertEquals((long)2L, (long)resultSet.getLong(0));
                Assert.assertEquals((Object)"Two", (Object)resultSet.getString(1));
                Assert.assertFalse((boolean)resultSet.next());
            }
        }
    }

    @Test
    public void testRollbackBatchDmlStatement() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setSavepointSupport(SavepointSupport.ENABLED);
            Assert.assertArrayEquals((long[])new long[]{1L, 1L}, (long[])connection.executeBatchUpdate((Iterable)ImmutableList.of((Object)((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)"insert into test (id, name) values (@id, @name)").bind("id").to(1L)).bind("name").to("One")).build(), (Object)((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)"insert into test (id, name) values (@id, @name)").bind("id").to(2L)).bind("name").to("Two")).build())));
            connection.savepoint("s1");
            Assert.assertArrayEquals((long[])new long[]{1L, 1L}, (long[])connection.executeBatchUpdate((Iterable)ImmutableList.of((Object)((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)"insert into test (id, name) values (@id, @name)").bind("id").to(3L)).bind("name").to("Three")).build(), (Object)((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)"insert into test (id, name) values (@id, @name)").bind("id").to(4L)).bind("name").to("Four")).build())));
            connection.rollbackToSavepoint("s1");
            connection.commit();
            try (ResultSet resultSet = connection.executeQuery(Statement.of((String)"select * from test order by id"), new Options.QueryOption[0]);){
                Assert.assertTrue((boolean)resultSet.next());
                Assert.assertEquals((long)1L, (long)resultSet.getLong(0));
                Assert.assertEquals((Object)"One", (Object)resultSet.getString(1));
                Assert.assertTrue((boolean)resultSet.next());
                Assert.assertEquals((long)2L, (long)resultSet.getLong(0));
                Assert.assertEquals((Object)"Two", (Object)resultSet.getString(1));
                Assert.assertFalse((boolean)resultSet.next());
            }
        }
    }
}

