/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.it;

import com.google.api.gax.rpc.PermissionDeniedException;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.InstanceId;
import com.google.cloud.spanner.IntegrationTestEnv;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ParallelIntegrationTest;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.admin.database.v1.DatabaseAdminClient;
import com.google.cloud.spanner.admin.instance.v1.InstanceAdminClient;
import com.google.cloud.spanner.testing.EmulatorSpannerHelper;
import com.google.cloud.spanner.testing.RemoteSpannerHelper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.truth.Truth;
import com.google.spanner.admin.database.v1.CreateDatabaseRequest;
import com.google.spanner.admin.database.v1.Database;
import com.google.spanner.admin.database.v1.DatabaseDialect;
import com.google.spanner.admin.database.v1.DatabaseName;
import com.google.spanner.admin.database.v1.InstanceName;
import com.google.spanner.admin.instance.v1.InstanceConfig;
import com.google.spanner.admin.instance.v1.ProjectName;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={ParallelIntegrationTest.class})
@RunWith(value=Parameterized.class)
public class ITAutogeneratedAdminClientTest {
    @ClassRule
    public static IntegrationTestEnv env = new IntegrationTestEnv();
    private static DatabaseAdminClient dbAdminClient;
    private static InstanceAdminClient instanceAdminClient;
    private static RemoteSpannerHelper testHelper;
    private static List<DatabaseName> databasesToDrop;
    @Parameterized.Parameter
    public DatabaseDialect dialect;

    @Parameterized.Parameters(name="Dialect = {0}")
    public static List<DatabaseDialect> data() {
        return ImmutableList.of((Object)DatabaseDialect.GOOGLE_STANDARD_SQL, (Object)DatabaseDialect.POSTGRESQL);
    }

    @BeforeClass
    public static void setUp() {
        Assume.assumeFalse((String)"Emulator does not support database roles", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        testHelper = env.getTestHelper();
        dbAdminClient = testHelper.getClient().createDatabaseAdminClient();
        instanceAdminClient = testHelper.getClient().createInstanceAdminClient();
        databasesToDrop = new ArrayList<DatabaseName>();
    }

    @AfterClass
    public static void cleanup() throws Exception {
        if (databasesToDrop != null) {
            for (DatabaseName databaseName : databasesToDrop) {
                try {
                    dbAdminClient.dropDatabase(databaseName);
                }
                catch (Exception e) {
                    System.err.println("Failed to drop database " + databaseName + ", skipping...: " + e.getMessage());
                }
            }
        }
    }

    @Test
    public void grantAndRevokeDatabaseRolePermissions() throws Exception {
        String dbRoleParent = "parent";
        String databaseId = testHelper.getUniqueDatabaseId();
        InstanceId instanceId = testHelper.getInstanceId();
        String createTableT = this.getCreateTableStatement();
        String createRoleParent = String.format("CREATE ROLE %s", "parent");
        String grantSelectOnTableToParent = this.dialect == DatabaseDialect.POSTGRESQL ? String.format("GRANT SELECT ON TABLE T TO %s", "parent") : String.format("GRANT SELECT ON TABLE T TO ROLE %s", "parent");
        Database createdDatabase = this.createAndUpdateDatabase(testHelper.getOptions().getProjectId(), instanceId, databaseId, (List<String>)ImmutableList.of((Object)createTableT, (Object)createRoleParent, (Object)grantSelectOnTableToParent));
        SpannerOptions options = testHelper.getOptions().toBuilder().setDatabaseRole("parent").build();
        Spanner spanner = (Spanner)options.getService();
        DatabaseId id = DatabaseId.of((String)createdDatabase.getName());
        DatabaseClient dbClient = spanner.getDatabaseClient(id);
        try (ResultSet rs = dbClient.singleUse().executeQuery(Statement.of((String)"SELECT COUNT(*) as cnt FROM T"), new Options.QueryOption[0]);){
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)dbClient.getDatabaseRole(), (Object)"parent");
        }
        catch (PermissionDeniedException e) {
            Assert.fail((String)"Got PermissionDeniedException when it should not have occurred.");
        }
        String revokeSelectOnTableFromParent = this.dialect == DatabaseDialect.POSTGRESQL ? String.format("REVOKE SELECT ON TABLE T FROM %s", "parent") : String.format("REVOKE SELECT ON TABLE T FROM ROLE %s", "parent");
        dbAdminClient.updateDatabaseDdlAsync(DatabaseName.of((String)options.getProjectId(), (String)instanceId.getInstance(), (String)databaseId), (List)ImmutableList.of((Object)revokeSelectOnTableFromParent)).get(5L, TimeUnit.MINUTES);
        try (ResultSet rs = dbClient.singleUse().executeQuery(Statement.of((String)"SELECT COUNT(*) as cnt FROM T"), new Options.QueryOption[0]);){
            SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> rs.next());
            Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.PERMISSION_DENIED);
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"parent");
        }
        String dropTableT = "DROP TABLE T";
        String dropRoleParent = String.format("DROP ROLE %s", "parent");
        dbAdminClient.updateDatabaseDdlAsync(DatabaseName.of((String)options.getProjectId(), (String)instanceId.getInstance(), (String)databaseId), (List)ImmutableList.of((Object)"DROP TABLE T", (Object)dropRoleParent)).get(5L, TimeUnit.MINUTES);
        databasesToDrop.add(DatabaseName.parse((String)createdDatabase.getName()));
    }

    @Test
    public void roleWithNoPermissions() throws Exception {
        String dbRoleOrphan = testHelper.getUniqueDatabaseRole();
        String databaseId = testHelper.getUniqueDatabaseId();
        InstanceId instanceId = testHelper.getInstanceId();
        String createTableT = this.getCreateTableStatement();
        String createRoleOrphan = String.format("CREATE ROLE %s", dbRoleOrphan);
        Database createdDatabase = this.createAndUpdateDatabase(testHelper.getOptions().getProjectId(), instanceId, databaseId, (List<String>)ImmutableList.of((Object)createTableT, (Object)createRoleOrphan));
        SpannerOptions options = testHelper.getOptions().toBuilder().setDatabaseRole(dbRoleOrphan).build();
        Spanner spanner = (Spanner)options.getService();
        DatabaseId id = DatabaseId.of((String)createdDatabase.getName());
        DatabaseClient dbClient = spanner.getDatabaseClient(id);
        try (ResultSet rs = dbClient.singleUse().executeQuery(Statement.of((String)"SELECT COUNT(*) as cnt FROM T"), new Options.QueryOption[0]);){
            SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> rs.next());
            Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.PERMISSION_DENIED);
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)dbRoleOrphan);
        }
        String dropTableT = "DROP TABLE T";
        String dropRoleParent = String.format("DROP ROLE %s", dbRoleOrphan);
        dbAdminClient.updateDatabaseDdlAsync(DatabaseName.of((String)options.getProjectId(), (String)instanceId.getInstance(), (String)databaseId), (List)ImmutableList.of((Object)"DROP TABLE T", (Object)dropRoleParent)).get(5L, TimeUnit.MINUTES);
        databasesToDrop.add(DatabaseName.parse((String)createdDatabase.getName()));
    }

    @Test
    public void instanceConfigOperations() {
        ArrayList configs = new ArrayList();
        Iterators.addAll(configs, instanceAdminClient.listInstanceConfigs(ProjectName.of((String)testHelper.getOptions().getProjectId())).iterateAll().iterator());
        Truth.assertThat((Boolean)configs.isEmpty()).isFalse();
        InstanceConfig config = instanceAdminClient.getInstanceConfig(((InstanceConfig)configs.get(0)).getName());
        Truth.assertThat((String)config.getName()).isEqualTo((Object)((InstanceConfig)configs.get(0)).getName());
    }

    private Database createAndUpdateDatabase(String projectId, InstanceId instanceId, String databaseId, List<String> statements) throws Exception {
        if (this.dialect == DatabaseDialect.POSTGRESQL) {
            CreateDatabaseRequest createDatabaseRequest = CreateDatabaseRequest.newBuilder().setParent(InstanceName.of((String)projectId, (String)instanceId.getInstance()).toString()).setCreateStatement(ITAutogeneratedAdminClientTest.getCreateDatabaseStatement(databaseId, this.dialect)).setDatabaseDialect(this.dialect).build();
            Database database = (Database)dbAdminClient.createDatabaseAsync(createDatabaseRequest).get(10L, TimeUnit.MINUTES);
            dbAdminClient.updateDatabaseDdlAsync(database.getName(), statements).get(5L, TimeUnit.MINUTES);
            return database;
        }
        CreateDatabaseRequest createDatabaseRequest = CreateDatabaseRequest.newBuilder().setParent(InstanceName.of((String)projectId, (String)instanceId.getInstance()).toString()).setCreateStatement(ITAutogeneratedAdminClientTest.getCreateDatabaseStatement(databaseId, this.dialect)).setDatabaseDialect(this.dialect).addAllExtraStatements(statements).build();
        return (Database)dbAdminClient.createDatabaseAsync(createDatabaseRequest).get(10L, TimeUnit.MINUTES);
    }

    private String getCreateTableStatement() {
        if (this.dialect == DatabaseDialect.POSTGRESQL) {
            return "CREATE TABLE IF NOT EXISTS T (  \"K\"    VARCHAR PRIMARY KEY)";
        }
        return "CREATE TABLE IF NOT EXISTS T (  K    STRING(MAX)) PRIMARY KEY (K)";
    }

    static String getCreateDatabaseStatement(String databaseName, DatabaseDialect dialect) {
        if (dialect == DatabaseDialect.GOOGLE_STANDARD_SQL) {
            return "CREATE DATABASE `" + databaseName + "`";
        }
        return "CREATE DATABASE \"" + databaseName + "\"";
    }
}

