/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.it;

import com.google.cloud.ByteArray;
import com.google.cloud.Date;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.IntegrationTestEnv;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ParallelIntegrationTest;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.Value;
import com.google.cloud.spanner.connection.ConnectionOptions;
import com.google.cloud.spanner.it.DialectTestParameter;
import com.google.cloud.spanner.testing.EmulatorSpannerHelper;
import com.google.common.primitives.Doubles;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={ParallelIntegrationTest.class})
@RunWith(value=Parameterized.class)
public class ITResultSetGetValue {
    @Parameterized.Parameter
    public DialectTestParameter dialect;
    @ClassRule
    public static IntegrationTestEnv env = new IntegrationTestEnv();
    private static final double DELTA = 1.0E-15;
    private static final String TABLE_NAME = "TestTable";
    private static DatabaseClient googleStandardSQLClient;
    private static DatabaseClient postgreSQLClient;
    private DatabaseClient databaseClient;

    @Parameterized.Parameters(name="Dialect = {0}")
    public static List<DialectTestParameter> data() {
        ArrayList<DialectTestParameter> params = new ArrayList<DialectTestParameter>();
        params.add(new DialectTestParameter(Dialect.GOOGLE_STANDARD_SQL));
        if (!EmulatorSpannerHelper.isUsingEmulator()) {
            params.add(new DialectTestParameter(Dialect.POSTGRESQL));
        }
        return params;
    }

    @BeforeClass
    public static void beforeClass() throws ExecutionException, InterruptedException, TimeoutException {
        Database googleStandardSqlDatabase = env.getTestHelper().createTestDatabase(new String[]{"CREATE TABLE TestTable(Id INT64 NOT NULL,bool BOOL,int64 INT64,float64 FLOAT64,numeric NUMERIC,string STRING(MAX),bytes BYTES(MAX),timestamp TIMESTAMP,date DATE,json JSON,boolArray ARRAY<BOOL>,int64Array ARRAY<INT64>,float64Array ARRAY<FLOAT64>,numericArray ARRAY<NUMERIC>,stringArray ARRAY<STRING(MAX)>,bytesArray ARRAY<BYTES(MAX)>,timestampArray ARRAY<TIMESTAMP>,dateArray ARRAY<DATE>,jsonArray ARRAY<JSON>) PRIMARY KEY (Id)"});
        googleStandardSQLClient = env.getTestHelper().getDatabaseClient(googleStandardSqlDatabase);
        if (!EmulatorSpannerHelper.isUsingEmulator()) {
            Database postgreSQLDatabase = env.getTestHelper().createTestDatabase(Dialect.POSTGRESQL, Collections.singletonList("CREATE TABLE TestTable(id BIGINT PRIMARY KEY,bool BOOL,int64 BIGINT,float64 DOUBLE PRECISION,numeric NUMERIC,string VARCHAR,bytes BYTEA,timestamp TIMESTAMPTZ,date DATE,boolArray BOOL[],int64Array BIGINT[],float64Array DOUBLE PRECISION[],numericArray NUMERIC[],stringArray VARCHAR[],bytesArray BYTEA[],dateArray DATE[],timestampArray TIMESTAMPTZ[])"));
            postgreSQLClient = env.getTestHelper().getDatabaseClient(postgreSQLDatabase);
        }
    }

    @Before
    public void before() {
        this.databaseClient = this.dialect.dialect == Dialect.GOOGLE_STANDARD_SQL ? googleStandardSQLClient : postgreSQLClient;
    }

    @AfterClass
    public static void teardown() {
        ConnectionOptions.closeSpanner();
    }

    @Test
    public void testReadNonNullValuesGoogleStandardSQL() {
        Assume.assumeTrue((this.dialect.dialect == Dialect.GOOGLE_STANDARD_SQL ? 1 : 0) != 0);
        this.databaseClient.write(Collections.singletonList(((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)TABLE_NAME).set("Id").to(1L)).set("bool").to(true)).set("int64").to(10L)).set("float64").to(20.0)).set("numeric").to(new BigDecimal("30"))).set("string").to("stringValue")).set("bytes").to(ByteArray.copyFrom((String)"bytesValue"))).set("timestamp").to(Timestamp.ofTimeSecondsAndNanos((long)1L, (int)0))).set("date").to(Date.fromYearMonthDay((int)2021, (int)1, (int)2))).set("json").to(Value.json((String)"{\"key\":\"value\"}"))).set("boolArray").toBoolArray(new boolean[]{false, true})).set("int64Array").toInt64Array(new long[]{100L, 200L})).set("float64Array").toFloat64Array(new double[]{1000.0, 2000.0})).set("numericArray").toNumericArray(Arrays.asList(new BigDecimal("10000"), new BigDecimal("20000")))).set("stringArray").toStringArray(Arrays.asList("string1", "string2"))).set("bytesArray").toBytesArray(Arrays.asList(ByteArray.copyFrom((String)"bytes1"), ByteArray.copyFrom((String)"bytes2")))).set("timestampArray").toTimestampArray(Arrays.asList(Timestamp.ofTimeSecondsAndNanos((long)10L, (int)0), Timestamp.ofTimeSecondsAndNanos((long)20L, (int)0)))).set("dateArray").toDateArray(Arrays.asList(Date.fromYearMonthDay((int)2021, (int)2, (int)3), Date.fromYearMonthDay((int)2021, (int)3, (int)4)))).set("jsonArray").toJsonArray(Arrays.asList("{\"key1\":\"value1\"}", "{\"key2\":\"value2\"}"))).build()));
        try (ResultSet resultSet = this.databaseClient.singleUse().executeQuery(Statement.of((String)"SELECT * FROM TestTable WHERE Id = 1"), new Options.QueryOption[0]);){
            resultSet.next();
            Assert.assertEquals((Object)Value.int64((long)1L), (Object)resultSet.getValue("Id"));
            Assert.assertEquals((Object)Value.bool((boolean)true), (Object)resultSet.getValue("bool"));
            Assert.assertEquals((Object)Value.int64((long)10L), (Object)resultSet.getValue("int64"));
            Assert.assertEquals((double)20.0, (double)resultSet.getValue("float64").getFloat64(), (double)1.0E-15);
            Assert.assertEquals((Object)Value.numeric((BigDecimal)new BigDecimal("30")), (Object)resultSet.getValue("numeric"));
            Assert.assertEquals((Object)Value.string((String)"stringValue"), (Object)resultSet.getValue("string"));
            Assert.assertEquals((Object)Value.bytes((ByteArray)ByteArray.copyFrom((String)"bytesValue")), (Object)resultSet.getValue("bytes"));
            Assert.assertEquals((Object)Value.timestamp((Timestamp)Timestamp.ofTimeSecondsAndNanos((long)1L, (int)0)), (Object)resultSet.getValue("timestamp"));
            Assert.assertEquals((Object)Value.date((Date)Date.fromYearMonthDay((int)2021, (int)1, (int)2)), (Object)resultSet.getValue("date"));
            Assert.assertEquals((Object)Value.json((String)"{\"key\":\"value\"}"), (Object)resultSet.getValue("json"));
            Assert.assertEquals((Object)Value.boolArray((boolean[])new boolean[]{false, true}), (Object)resultSet.getValue("boolArray"));
            Assert.assertEquals((Object)Value.int64Array((long[])new long[]{100L, 200L}), (Object)resultSet.getValue("int64Array"));
            Assert.assertArrayEquals((double[])new double[]{1000.0, 2000.0}, (double[])Doubles.toArray((Collection)resultSet.getValue("float64Array").getFloat64Array()), (double)1.0E-15);
            Assert.assertEquals((Object)Value.numericArray(Arrays.asList(new BigDecimal("10000"), new BigDecimal("20000"))), (Object)resultSet.getValue("numericArray"));
            Assert.assertEquals((Object)Value.stringArray(Arrays.asList("string1", "string2")), (Object)resultSet.getValue("stringArray"));
            Assert.assertEquals((Object)Value.bytesArray(Arrays.asList(ByteArray.copyFrom((String)"bytes1"), ByteArray.copyFrom((String)"bytes2"))), (Object)resultSet.getValue("bytesArray"));
            Assert.assertEquals((Object)Value.timestampArray(Arrays.asList(Timestamp.ofTimeSecondsAndNanos((long)10L, (int)0), Timestamp.ofTimeSecondsAndNanos((long)20L, (int)0))), (Object)resultSet.getValue("timestampArray"));
            Assert.assertEquals((Object)Value.dateArray(Arrays.asList(Date.fromYearMonthDay((int)2021, (int)2, (int)3), Date.fromYearMonthDay((int)2021, (int)3, (int)4))), (Object)resultSet.getValue("dateArray"));
            Assert.assertEquals((Object)Value.jsonArray(Arrays.asList("{\"key1\":\"value1\"}", "{\"key2\":\"value2\"}")), (Object)resultSet.getValue("jsonArray"));
        }
    }

    @Test
    public void testReadNonNullValuesPostgreSQL() {
        Assume.assumeTrue((this.dialect.dialect == Dialect.POSTGRESQL ? 1 : 0) != 0);
        this.databaseClient.write(Collections.singletonList(((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)TABLE_NAME).set("id").to(1L)).set("bool").to(true)).set("int64").to(10L)).set("float64").to(20.0)).set("numeric").to(new BigDecimal("30"))).set("string").to("stringValue")).set("bytes").to(ByteArray.copyFrom((String)"bytesValue"))).set("date").to(Date.fromYearMonthDay((int)2021, (int)1, (int)2))).set("timestamp").to(Timestamp.ofTimeSecondsAndNanos((long)1L, (int)0))).set("boolArray").toBoolArray(new boolean[]{false, true})).set("int64Array").toInt64Array(new long[]{100L, 200L})).set("float64Array").toFloat64Array(new double[]{1000.0, 2000.0})).set("numericArray").toNumericArray(Arrays.asList(new BigDecimal("10000"), new BigDecimal("20000")))).set("stringArray").toStringArray(Arrays.asList("string1", "string2"))).set("bytesArray").toBytesArray(Arrays.asList(ByteArray.copyFrom((String)"bytes1"), ByteArray.copyFrom((String)"bytes2")))).set("timestampArray").toTimestampArray(Arrays.asList(Timestamp.ofTimeSecondsAndNanos((long)10L, (int)0), Timestamp.ofTimeSecondsAndNanos((long)20L, (int)0)))).set("dateArray").toDateArray(Arrays.asList(Date.fromYearMonthDay((int)2021, (int)2, (int)3), Date.fromYearMonthDay((int)2021, (int)3, (int)4)))).build()));
        try (ResultSet resultSet = this.databaseClient.singleUse().executeQuery(Statement.of((String)"SELECT * FROM TestTable WHERE id = 1"), new Options.QueryOption[0]);){
            resultSet.next();
            Assert.assertEquals((Object)Value.int64((long)1L), (Object)resultSet.getValue("id"));
            Assert.assertEquals((Object)Value.bool((boolean)true), (Object)resultSet.getValue("bool"));
            Assert.assertEquals((Object)Value.int64((long)10L), (Object)resultSet.getValue("int64"));
            Assert.assertEquals((double)20.0, (double)resultSet.getValue("float64").getFloat64(), (double)1.0E-15);
            Assert.assertEquals((Object)Value.pgNumeric((String)"30"), (Object)resultSet.getValue("numeric"));
            Assert.assertEquals((Object)Value.string((String)"stringValue"), (Object)resultSet.getValue("string"));
            Assert.assertEquals((Object)Value.bytes((ByteArray)ByteArray.copyFrom((String)"bytesValue")), (Object)resultSet.getValue("bytes"));
            Assert.assertEquals((Object)Value.timestamp((Timestamp)Timestamp.ofTimeSecondsAndNanos((long)1L, (int)0)), (Object)resultSet.getValue("timestamp"));
            Assert.assertEquals((Object)Value.date((Date)Date.fromYearMonthDay((int)2021, (int)1, (int)2)), (Object)resultSet.getValue("date"));
            Assert.assertEquals((Object)Value.boolArray((boolean[])new boolean[]{false, true}), (Object)resultSet.getValue("boolarray"));
            Assert.assertEquals((Object)Value.int64Array((long[])new long[]{100L, 200L}), (Object)resultSet.getValue("int64array"));
            Assert.assertArrayEquals((double[])new double[]{1000.0, 2000.0}, (double[])Doubles.toArray((Collection)resultSet.getValue("float64array").getFloat64Array()), (double)1.0E-15);
            Assert.assertEquals((Object)Value.pgNumericArray(Arrays.asList("10000", "20000")), (Object)resultSet.getValue("numericarray"));
            Assert.assertEquals((Object)Value.stringArray(Arrays.asList("string1", "string2")), (Object)resultSet.getValue("stringarray"));
            Assert.assertEquals((Object)Value.bytesArray(Arrays.asList(ByteArray.copyFrom((String)"bytes1"), ByteArray.copyFrom((String)"bytes2"))), (Object)resultSet.getValue("bytesarray"));
            Assert.assertEquals((Object)Value.timestampArray(Arrays.asList(Timestamp.ofTimeSecondsAndNanos((long)10L, (int)0), Timestamp.ofTimeSecondsAndNanos((long)20L, (int)0))), (Object)resultSet.getValue("timestamparray"));
            Assert.assertEquals((Object)Value.dateArray(Arrays.asList(Date.fromYearMonthDay((int)2021, (int)2, (int)3), Date.fromYearMonthDay((int)2021, (int)3, (int)4))), (Object)resultSet.getValue("datearray"));
        }
    }

    @Test
    public void testReadNullValuesGoogleStandardSQL() {
        Assume.assumeTrue((this.dialect.dialect == Dialect.GOOGLE_STANDARD_SQL ? 1 : 0) != 0);
        this.databaseClient.write(Collections.singletonList(((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)TABLE_NAME).set("Id").to(2L)).build()));
        try (ResultSet resultSet = this.databaseClient.singleUse().executeQuery(Statement.of((String)"SELECT * FROM TestTable WHERE Id = 2"), new Options.QueryOption[0]);){
            resultSet.next();
            Assert.assertEquals((Object)Value.int64((long)2L), (Object)resultSet.getValue("Id"));
            Assert.assertTrue((boolean)resultSet.getValue("bool").isNull());
            Assert.assertThrows(IllegalStateException.class, () -> resultSet.getValue("bool").getBool());
            Assert.assertTrue((boolean)resultSet.getValue("int64").isNull());
            Assert.assertThrows(IllegalStateException.class, () -> resultSet.getValue("int64").getInt64());
            Assert.assertTrue((boolean)resultSet.getValue("float64").isNull());
            Assert.assertThrows(IllegalStateException.class, () -> resultSet.getValue("float64").getFloat64());
            Assert.assertTrue((boolean)resultSet.getValue("numeric").isNull());
            Assert.assertThrows(IllegalStateException.class, () -> resultSet.getValue("numeric").getNumeric());
            Assert.assertTrue((boolean)resultSet.getValue("string").isNull());
            Assert.assertThrows(IllegalStateException.class, () -> resultSet.getValue("string").getString());
            Assert.assertTrue((boolean)resultSet.getValue("bytes").isNull());
            Assert.assertThrows(IllegalStateException.class, () -> resultSet.getValue("bytes").getBytes());
            Assert.assertTrue((boolean)resultSet.getValue("timestamp").isNull());
            Assert.assertThrows(IllegalStateException.class, () -> resultSet.getValue("timestamp").getTimestamp());
            Assert.assertTrue((boolean)resultSet.getValue("date").isNull());
            Assert.assertThrows(IllegalStateException.class, () -> resultSet.getValue("date").getDate());
            Assert.assertTrue((boolean)resultSet.getValue("json").isNull());
            Assert.assertThrows(IllegalStateException.class, () -> resultSet.getValue("json").getJson());
            Assert.assertTrue((boolean)resultSet.getValue("boolArray").isNull());
            Assert.assertThrows(IllegalStateException.class, () -> resultSet.getValue("boolArray").getBoolArray());
            Assert.assertTrue((boolean)resultSet.getValue("int64Array").isNull());
            Assert.assertThrows(IllegalStateException.class, () -> resultSet.getValue("int64Array").getInt64Array());
            Assert.assertTrue((boolean)resultSet.getValue("float64Array").isNull());
            Assert.assertThrows(IllegalStateException.class, () -> resultSet.getValue("float64Array").getFloat64Array());
            Assert.assertTrue((boolean)resultSet.getValue("numericArray").isNull());
            Assert.assertThrows(IllegalStateException.class, () -> resultSet.getValue("numericArray").getNumericArray());
            Assert.assertTrue((boolean)resultSet.getValue("stringArray").isNull());
            Assert.assertThrows(IllegalStateException.class, () -> resultSet.getValue("stringArray").getStringArray());
            Assert.assertTrue((boolean)resultSet.getValue("bytesArray").isNull());
            Assert.assertThrows(IllegalStateException.class, () -> resultSet.getValue("bytesArray").getBytesArray());
            Assert.assertTrue((boolean)resultSet.getValue("timestampArray").isNull());
            Assert.assertThrows(IllegalStateException.class, () -> resultSet.getValue("timestampArray").getTimestampArray());
            Assert.assertTrue((boolean)resultSet.getValue("dateArray").isNull());
            Assert.assertThrows(IllegalStateException.class, () -> resultSet.getValue("dateArray").getDateArray());
            Assert.assertTrue((boolean)resultSet.getValue("jsonArray").isNull());
            Assert.assertThrows(IllegalStateException.class, () -> resultSet.getValue("jsonArray").getJsonArray());
        }
    }

    @Test
    public void testReadNullValuesPostgreSQL() {
        Assume.assumeTrue((this.dialect.dialect == Dialect.POSTGRESQL ? 1 : 0) != 0);
        this.databaseClient.write(Collections.singletonList(((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)TABLE_NAME).set("id").to(2L)).build()));
        try (ResultSet resultSet = this.databaseClient.singleUse().executeQuery(Statement.of((String)"SELECT * FROM TestTable WHERE id = 2"), new Options.QueryOption[0]);){
            resultSet.next();
            Assert.assertEquals((Object)Value.int64((long)2L), (Object)resultSet.getValue("id"));
            Assert.assertTrue((boolean)resultSet.getValue("bool").isNull());
            Assert.assertThrows(IllegalStateException.class, () -> resultSet.getValue("bool").getBool());
            Assert.assertTrue((boolean)resultSet.getValue("int64").isNull());
            Assert.assertThrows(IllegalStateException.class, () -> resultSet.getValue("int64").getInt64());
            Assert.assertTrue((boolean)resultSet.getValue("float64").isNull());
            Assert.assertThrows(IllegalStateException.class, () -> resultSet.getValue("float64").getFloat64());
            Assert.assertTrue((boolean)resultSet.getValue("numeric").isNull());
            Assert.assertThrows(IllegalStateException.class, () -> resultSet.getValue("numeric").getNumeric());
            Assert.assertTrue((boolean)resultSet.getValue("string").isNull());
            Assert.assertThrows(IllegalStateException.class, () -> resultSet.getValue("string").getString());
            Assert.assertTrue((boolean)resultSet.getValue("bytes").isNull());
            Assert.assertThrows(IllegalStateException.class, () -> resultSet.getValue("bytes").getBytes());
            Assert.assertTrue((boolean)resultSet.getValue("timestamp").isNull());
            Assert.assertThrows(IllegalStateException.class, () -> resultSet.getValue("timestamp").getTimestamp());
            Assert.assertTrue((boolean)resultSet.getValue("date").isNull());
            Assert.assertThrows(IllegalStateException.class, () -> resultSet.getValue("date").getDate());
            Assert.assertTrue((boolean)resultSet.getValue("boolarray").isNull());
            Assert.assertThrows(IllegalStateException.class, () -> resultSet.getValue("boolarray").getBoolArray());
            Assert.assertTrue((boolean)resultSet.getValue("int64array").isNull());
            Assert.assertThrows(IllegalStateException.class, () -> resultSet.getValue("int64array").getInt64Array());
            Assert.assertTrue((boolean)resultSet.getValue("float64array").isNull());
            Assert.assertThrows(IllegalStateException.class, () -> resultSet.getValue("float64array").getFloat64Array());
            Assert.assertTrue((boolean)resultSet.getValue("numericarray").isNull());
            Assert.assertThrows(IllegalStateException.class, () -> resultSet.getValue("numericarray").getNumericArray());
            Assert.assertTrue((boolean)resultSet.getValue("stringarray").isNull());
            Assert.assertThrows(IllegalStateException.class, () -> resultSet.getValue("stringarray").getStringArray());
            Assert.assertTrue((boolean)resultSet.getValue("bytesarray").isNull());
            Assert.assertThrows(IllegalStateException.class, () -> resultSet.getValue("bytesarray").getBytesArray());
            Assert.assertTrue((boolean)resultSet.getValue("timestamparray").isNull());
            Assert.assertThrows(IllegalStateException.class, () -> resultSet.getValue("timestamparray").getTimestampArray());
            Assert.assertTrue((boolean)resultSet.getValue("datearray").isNull());
            Assert.assertThrows(IllegalStateException.class, () -> resultSet.getValue("datearray").getDateArray());
        }
    }

    @Test
    public void testReadNullValuesInArraysGoogleStandardSQL() {
        Assume.assumeTrue((this.dialect.dialect == Dialect.GOOGLE_STANDARD_SQL ? 1 : 0) != 0);
        this.databaseClient.write(Collections.singletonList(((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)TABLE_NAME).set("Id").to(3L)).set("boolArray").toBoolArray(Arrays.asList(true, null))).set("int64Array").toInt64Array(Arrays.asList(null, 2L))).set("float64Array").toFloat64Array(Arrays.asList(null, 10.0))).set("numericArray").toNumericArray(Arrays.asList(new BigDecimal("10000"), null))).set("stringArray").toStringArray(Arrays.asList(null, "string2"))).set("bytesArray").toBytesArray(Arrays.asList(ByteArray.copyFrom((String)"bytes1"), null))).set("timestampArray").toTimestampArray(Arrays.asList(null, Timestamp.ofTimeSecondsAndNanos((long)20L, (int)0)))).set("dateArray").toDateArray(Arrays.asList(Date.fromYearMonthDay((int)2021, (int)2, (int)3), null))).set("jsonArray").toJsonArray(Arrays.asList("{\"key1\":\"value1\"}", null))).build()));
        try (ResultSet resultSet = this.databaseClient.singleUse().executeQuery(Statement.of((String)"SELECT * FROM TestTable WHERE Id = 3"), new Options.QueryOption[0]);){
            resultSet.next();
            Assert.assertEquals((Object)Value.int64((long)3L), (Object)resultSet.getValue("Id"));
            Assert.assertEquals((Object)Value.boolArray(Arrays.asList(true, null)), (Object)resultSet.getValue("boolArray"));
            Assert.assertEquals((Object)Value.int64Array(Arrays.asList(null, 2L)), (Object)resultSet.getValue("int64Array"));
            Assert.assertNull(resultSet.getValue("float64Array").getFloat64Array().get(0));
            Assert.assertEquals((double)10.0, (double)((Double)resultSet.getValue("float64Array").getFloat64Array().get(1)), (double)1.0E-15);
            Assert.assertEquals((Object)Value.numericArray(Arrays.asList(new BigDecimal("10000"), null)), (Object)resultSet.getValue("numericArray"));
            Assert.assertEquals((Object)Value.stringArray(Arrays.asList(null, "string2")), (Object)resultSet.getValue("stringArray"));
            Assert.assertEquals((Object)Value.bytesArray(Arrays.asList(ByteArray.copyFrom((String)"bytes1"), null)), (Object)resultSet.getValue("bytesArray"));
            Assert.assertEquals((Object)Value.timestampArray(Arrays.asList(null, Timestamp.ofTimeSecondsAndNanos((long)20L, (int)0))), (Object)resultSet.getValue("timestampArray"));
            Assert.assertEquals((Object)Value.dateArray(Arrays.asList(Date.fromYearMonthDay((int)2021, (int)2, (int)3), null)), (Object)resultSet.getValue("dateArray"));
            Assert.assertEquals((Object)Value.jsonArray(Arrays.asList("{\"key1\":\"value1\"}", null)), (Object)resultSet.getValue("jsonArray"));
        }
    }

    @Test
    public void testReadNullValuesInArraysPostgreSQL() {
        Assume.assumeTrue((this.dialect.dialect == Dialect.POSTGRESQL ? 1 : 0) != 0);
        this.databaseClient.write(Collections.singletonList(((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)TABLE_NAME).set("Id").to(3L)).set("boolArray").toBoolArray(Arrays.asList(true, null))).set("int64Array").toInt64Array(Arrays.asList(null, 2L))).set("float64Array").toFloat64Array(Arrays.asList(null, 10.0))).set("numericArray").toNumericArray(Arrays.asList(new BigDecimal("10000"), null))).set("stringArray").toStringArray(Arrays.asList(null, "string2"))).set("bytesArray").toBytesArray(Arrays.asList(ByteArray.copyFrom((String)"bytes1"), null))).set("timestampArray").toTimestampArray(Arrays.asList(null, Timestamp.ofTimeSecondsAndNanos((long)20L, (int)0)))).set("dateArray").toDateArray(Arrays.asList(Date.fromYearMonthDay((int)2021, (int)2, (int)3), null))).build()));
        try (ResultSet resultSet = this.databaseClient.singleUse().executeQuery(Statement.of((String)"SELECT * FROM TestTable WHERE Id = 3"), new Options.QueryOption[0]);){
            resultSet.next();
            Assert.assertEquals((Object)Value.int64((long)3L), (Object)resultSet.getValue("id"));
            Assert.assertEquals((Object)Value.boolArray(Arrays.asList(true, null)), (Object)resultSet.getValue("boolarray"));
            Assert.assertEquals((Object)Value.int64Array(Arrays.asList(null, 2L)), (Object)resultSet.getValue("int64array"));
            Assert.assertNull(resultSet.getValue("float64array").getFloat64Array().get(0));
            Assert.assertEquals((double)10.0, (double)((Double)resultSet.getValue("float64array").getFloat64Array().get(1)), (double)1.0E-15);
            Assert.assertEquals((Object)Value.pgNumericArray(Arrays.asList("10000", null)), (Object)resultSet.getValue("numericarray"));
            Assert.assertEquals((Object)Value.stringArray(Arrays.asList(null, "string2")), (Object)resultSet.getValue("stringarray"));
            Assert.assertEquals((Object)Value.bytesArray(Arrays.asList(ByteArray.copyFrom((String)"bytes1"), null)), (Object)resultSet.getValue("bytesarray"));
            Assert.assertEquals((Object)Value.timestampArray(Arrays.asList(null, Timestamp.ofTimeSecondsAndNanos((long)20L, (int)0))), (Object)resultSet.getValue("timestamparray"));
            Assert.assertEquals((Object)Value.dateArray(Arrays.asList(Date.fromYearMonthDay((int)2021, (int)2, (int)3), null)), (Object)resultSet.getValue("datearray"));
        }
    }

    @Test
    public void testReadNonFloat64LiteralsGoogleStandardSQL() {
        Assume.assumeTrue((this.dialect.dialect == Dialect.GOOGLE_STANDARD_SQL ? 1 : 0) != 0);
        try (ResultSet resultSet = this.databaseClient.singleUse().executeQuery(Statement.of((String)"SELECT TRUE AS bool,1 AS int64,CAST('100' AS NUMERIC) AS numeric,'stringValue' AS string,CAST('bytesValue' AS BYTES) AS bytes,CAST('1970-01-01T00:00:01Z' AS TIMESTAMP) AS timestamp,CAST('2021-02-03' AS DATE) AS date,[false, true] AS boolArray,[1, 2] AS int64Array,[CAST('100' AS NUMERIC), CAST('200' AS NUMERIC)] AS numericArray,['string1', 'string2'] AS stringArray,[CAST('bytes1' AS BYTES), CAST('bytes2' AS BYTES)] AS bytesArray,[CAST('1970-01-01T00:00:01.000000002Z' AS TIMESTAMP), CAST('1970-01-01T00:00:02.000000003Z' AS TIMESTAMP)] AS timestampArray,[CAST('2020-01-02' AS DATE), CAST('2021-02-03' AS DATE)] AS dateArray,ARRAY(SELECT STRUCT(  TRUE AS structBool,  1 AS structInt64,  CAST('100' AS NUMERIC) AS structNumeric,  'stringValue' AS structString,  CAST('bytesValue' AS BYTES) AS structBytes,  CAST('1970-01-01T00:00:01Z' AS TIMESTAMP) AS structTimestamp,  CAST('2020-01-02' AS DATE) AS structDate,  [false, true] AS structBoolArray,  [1, 2] AS structInt64Array,  [CAST('100' AS NUMERIC), CAST('200' AS NUMERIC)] AS structNumericArray,  ['string1', 'string2'] AS structStringArray,  [CAST('bytes1' AS BYTES), CAST('bytes2' AS BYTES)] AS structBytesArray,  [CAST('1970-01-01T00:00:01.000000002Z' AS TIMESTAMP), CAST('1970-01-01T00:00:02.000000003Z' AS TIMESTAMP)] AS structTimestampArray,  [CAST('2020-01-02' AS DATE), CAST('2021-02-03' AS DATE)] AS structDateArray)) AS structArray"), new Options.QueryOption[0]);){
            resultSet.next();
            Assert.assertEquals((Object)Value.bool((boolean)true), (Object)resultSet.getValue("bool"));
            Assert.assertEquals((Object)Value.int64((long)1L), (Object)resultSet.getValue("int64"));
            Assert.assertEquals((Object)Value.numeric((BigDecimal)new BigDecimal("100")), (Object)resultSet.getValue("numeric"));
            Assert.assertEquals((Object)Value.string((String)"stringValue"), (Object)resultSet.getValue("string"));
            Assert.assertEquals((Object)Value.bytes((ByteArray)ByteArray.copyFrom((String)"bytesValue")), (Object)resultSet.getValue("bytes"));
            Assert.assertEquals((Object)Value.timestamp((Timestamp)Timestamp.ofTimeSecondsAndNanos((long)1L, (int)0)), (Object)resultSet.getValue("timestamp"));
            Assert.assertEquals((Object)Value.date((Date)Date.fromYearMonthDay((int)2021, (int)2, (int)3)), (Object)resultSet.getValue("date"));
            Assert.assertEquals((Object)Value.boolArray((boolean[])new boolean[]{false, true}), (Object)resultSet.getValue("boolArray"));
            Assert.assertEquals((Object)Value.int64Array((long[])new long[]{1L, 2L}), (Object)resultSet.getValue("int64Array"));
            Assert.assertEquals((Object)Value.numericArray(Arrays.asList(new BigDecimal("100"), new BigDecimal("200"))), (Object)resultSet.getValue("numericArray"));
            Assert.assertEquals((Object)Value.stringArray(Arrays.asList("string1", "string2")), (Object)resultSet.getValue("stringArray"));
            Assert.assertEquals((Object)Value.bytesArray(Arrays.asList(ByteArray.copyFrom((String)"bytes1"), ByteArray.copyFrom((String)"bytes2"))), (Object)resultSet.getValue("bytesArray"));
            Assert.assertEquals((Object)Value.timestampArray(Arrays.asList(Timestamp.ofTimeSecondsAndNanos((long)1L, (int)2), Timestamp.ofTimeSecondsAndNanos((long)2L, (int)3))), (Object)resultSet.getValue("timestampArray"));
            Assert.assertEquals((Object)Value.dateArray(Arrays.asList(Date.fromYearMonthDay((int)2020, (int)1, (int)2), Date.fromYearMonthDay((int)2021, (int)2, (int)3))), (Object)resultSet.getValue("dateArray"));
            Assert.assertEquals((Object)Value.structArray((Type)Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"structBool", (Type)Type.bool()), Type.StructField.of((String)"structInt64", (Type)Type.int64()), Type.StructField.of((String)"structNumeric", (Type)Type.numeric()), Type.StructField.of((String)"structString", (Type)Type.string()), Type.StructField.of((String)"structBytes", (Type)Type.bytes()), Type.StructField.of((String)"structTimestamp", (Type)Type.timestamp()), Type.StructField.of((String)"structDate", (Type)Type.date()), Type.StructField.of((String)"structBoolArray", (Type)Type.array((Type)Type.bool())), Type.StructField.of((String)"structInt64Array", (Type)Type.array((Type)Type.int64())), Type.StructField.of((String)"structNumericArray", (Type)Type.array((Type)Type.numeric())), Type.StructField.of((String)"structStringArray", (Type)Type.array((Type)Type.string())), Type.StructField.of((String)"structBytesArray", (Type)Type.array((Type)Type.bytes())), Type.StructField.of((String)"structTimestampArray", (Type)Type.array((Type)Type.timestamp())), Type.StructField.of((String)"structDateArray", (Type)Type.array((Type)Type.date()))}), Collections.singletonList(((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("structBool").to(Value.bool((boolean)true))).set("structInt64").to(Value.int64((long)1L))).set("structNumeric").to(new BigDecimal("100"))).set("structString").to("stringValue")).set("structBytes").to(ByteArray.copyFrom((String)"bytesValue"))).set("structTimestamp").to(Timestamp.ofTimeSecondsAndNanos((long)1L, (int)0))).set("structDate").to(Date.fromYearMonthDay((int)2020, (int)1, (int)2))).set("structBoolArray").toBoolArray(new boolean[]{false, true})).set("structInt64Array").toInt64Array(new long[]{1L, 2L})).set("structNumericArray").toNumericArray(Arrays.asList(new BigDecimal("100"), new BigDecimal("200")))).set("structStringArray").toStringArray(Arrays.asList("string1", "string2"))).set("structBytesArray").toBytesArray(Arrays.asList(ByteArray.copyFrom((String)"bytes1"), ByteArray.copyFrom((String)"bytes2")))).set("structTimestampArray").toTimestampArray(Arrays.asList(Timestamp.ofTimeSecondsAndNanos((long)1L, (int)2), Timestamp.ofTimeSecondsAndNanos((long)2L, (int)3)))).set("structDateArray").toDateArray(Arrays.asList(Date.fromYearMonthDay((int)2020, (int)1, (int)2), Date.fromYearMonthDay((int)2021, (int)2, (int)3)))).build())), (Object)resultSet.getValue("structArray"));
        }
    }

    @Test
    public void testReadNonFloat64LiteralsPostgreSQL() {
        Assume.assumeTrue((this.dialect.dialect == Dialect.POSTGRESQL ? 1 : 0) != 0);
        try (ResultSet resultSet = this.databaseClient.singleUse().executeQuery(Statement.of((String)"SELECT TRUE AS bool,1 AS int64,CAST('100' AS numeric) AS numeric,'stringValue' AS string,CAST('bytesValue' AS BYTEA) AS bytes,CAST('1970-01-01T00:00:01 UTC' AS TIMESTAMPTZ) AS timestamp,CAST('2021-02-03' AS DATE) AS date,ARRAY[false, true] AS boolArray,ARRAY[1, 2] AS int64Array,ARRAY[CAST('100' AS NUMERIC), CAST('200' AS NUMERIC)] AS numericArray,ARRAY['string1', 'string2'] AS stringArray,ARRAY[CAST('bytes1' AS BYTEA), CAST('bytes2' AS BYTEA)] AS bytesArray,ARRAY[CAST('1970-01-01T00:00:01 UTC' AS TIMESTAMPTZ), CAST('1970-01-01T00:00:02 UTC' AS TIMESTAMPTZ)] AS timestampArray,ARRAY[CAST('2020-01-02' AS DATE), CAST('2021-02-03' AS DATE)] AS dateArray"), new Options.QueryOption[0]);){
            resultSet.next();
            Assert.assertEquals((Object)Value.bool((boolean)true), (Object)resultSet.getValue("bool"));
            Assert.assertEquals((Object)Value.int64((long)1L), (Object)resultSet.getValue("int64"));
            Assert.assertEquals((Object)Value.pgNumeric((String)"100"), (Object)resultSet.getValue("numeric"));
            Assert.assertEquals((Object)Value.string((String)"stringValue"), (Object)resultSet.getValue("string"));
            Assert.assertEquals((Object)Value.bytes((ByteArray)ByteArray.copyFrom((String)"bytesValue")), (Object)resultSet.getValue("bytes"));
            Assert.assertEquals((Object)Value.timestamp((Timestamp)Timestamp.ofTimeSecondsAndNanos((long)1L, (int)0)), (Object)resultSet.getValue("timestamp"));
            Assert.assertEquals((Object)Value.date((Date)Date.fromYearMonthDay((int)2021, (int)2, (int)3)), (Object)resultSet.getValue("date"));
            Assert.assertEquals((Object)Value.boolArray((boolean[])new boolean[]{false, true}), (Object)resultSet.getValue("boolarray"));
            Assert.assertEquals((Object)Value.int64Array((long[])new long[]{1L, 2L}), (Object)resultSet.getValue("int64array"));
            Assert.assertEquals((Object)Value.pgNumericArray(Arrays.asList("100", "200")), (Object)resultSet.getValue("numericarray"));
            Assert.assertEquals((Object)Value.stringArray(Arrays.asList("string1", "string2")), (Object)resultSet.getValue("stringarray"));
            Assert.assertEquals((Object)Value.bytesArray(Arrays.asList(ByteArray.copyFrom((String)"bytes1"), ByteArray.copyFrom((String)"bytes2"))), (Object)resultSet.getValue("bytesarray"));
            Assert.assertEquals((Object)Value.timestampArray(Arrays.asList(Timestamp.ofTimeSecondsAndNanos((long)1L, (int)0), Timestamp.ofTimeSecondsAndNanos((long)2L, (int)0))), (Object)resultSet.getValue("timestamparray"));
            Assert.assertEquals((Object)Value.dateArray(Arrays.asList(Date.fromYearMonthDay((int)2020, (int)1, (int)2), Date.fromYearMonthDay((int)2021, (int)2, (int)3))), (Object)resultSet.getValue("datearray"));
        }
    }

    @Test
    public void testReadFloat64LiteralsGoogleStandardSQL() {
        Assume.assumeTrue((this.dialect.dialect == Dialect.GOOGLE_STANDARD_SQL ? 1 : 0) != 0);
        try (ResultSet resultSet = this.databaseClient.singleUse().executeQuery(Statement.of((String)"SELECT 10.0 AS float64,[20.0, 30.0] AS float64Array,ARRAY(SELECT STRUCT(  40.0 AS structFloat64,  [50.0, 60.0] AS structFloat64Array)) AS structArray"), new Options.QueryOption[0]);){
            resultSet.next();
            Struct struct = (Struct)resultSet.getValue("structArray").getStructArray().get(0);
            Assert.assertEquals((double)10.0, (double)resultSet.getValue("float64").getFloat64(), (double)1.0E-15);
            Assert.assertArrayEquals((double[])new double[]{20.0, 30.0}, (double[])Doubles.toArray((Collection)resultSet.getValue("float64Array").getFloat64Array()), (double)1.0E-15);
            Assert.assertEquals((double)40.0, (double)struct.getDouble("structFloat64"), (double)1.0E-15);
            Assert.assertArrayEquals((double[])new double[]{50.0, 60.0}, (double[])struct.getDoubleArray("structFloat64Array"), (double)1.0E-15);
        }
    }

    @Test
    public void testReadFloat64LiteralsPostgreSQL() {
        Assume.assumeTrue((this.dialect.dialect == Dialect.POSTGRESQL ? 1 : 0) != 0);
        try (ResultSet resultSet = this.databaseClient.singleUse().executeQuery(Statement.of((String)"SELECT 10.0 AS float64, ARRAY[20.0, 30.0] AS float64Array"), new Options.QueryOption[0]);){
            resultSet.next();
            Assert.assertEquals((double)10.0, (double)resultSet.getValue("float64").getFloat64(), (double)1.0E-15);
            Assert.assertArrayEquals((double[])new double[]{20.0, 30.0}, (double[])Doubles.toArray((Collection)resultSet.getValue("float64array").getFloat64Array()), (double)1.0E-15);
        }
    }
}

