/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tpu.v1;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.tpu.v1.AcceleratorType;
import com.google.cloud.tpu.v1.AcceleratorTypeName;
import com.google.cloud.tpu.v1.CreateNodeRequest;
import com.google.cloud.tpu.v1.DeleteNodeRequest;
import com.google.cloud.tpu.v1.GetAcceleratorTypeRequest;
import com.google.cloud.tpu.v1.GetNodeRequest;
import com.google.cloud.tpu.v1.GetTensorFlowVersionRequest;
import com.google.cloud.tpu.v1.ListAcceleratorTypesRequest;
import com.google.cloud.tpu.v1.ListAcceleratorTypesResponse;
import com.google.cloud.tpu.v1.ListNodesRequest;
import com.google.cloud.tpu.v1.ListNodesResponse;
import com.google.cloud.tpu.v1.ListTensorFlowVersionsRequest;
import com.google.cloud.tpu.v1.ListTensorFlowVersionsResponse;
import com.google.cloud.tpu.v1.LocationName;
import com.google.cloud.tpu.v1.MockTpu;
import com.google.cloud.tpu.v1.Node;
import com.google.cloud.tpu.v1.NodeName;
import com.google.cloud.tpu.v1.ReimageNodeRequest;
import com.google.cloud.tpu.v1.SchedulingConfig;
import com.google.cloud.tpu.v1.StartNodeRequest;
import com.google.cloud.tpu.v1.StopNodeRequest;
import com.google.cloud.tpu.v1.TensorFlowVersion;
import com.google.cloud.tpu.v1.TensorFlowVersionName;
import com.google.cloud.tpu.v1.TpuClient;
import com.google.cloud.tpu.v1.TpuSettings;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Any;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TpuClientTest {
    private static MockServiceHelper mockServiceHelper;
    private static MockTpu mockTpu;
    private LocalChannelProvider channelProvider;
    private TpuClient client;

    @BeforeClass
    public static void startStaticServer() {
        mockTpu = new MockTpu();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockTpu));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        TpuSettings settings = ((TpuSettings.Builder)((TpuSettings.Builder)TpuSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = TpuClient.create((TpuSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void listNodesTest() throws Exception {
        Node responsesElement = Node.newBuilder().build();
        ListNodesResponse expectedResponse = ListNodesResponse.newBuilder().setNextPageToken("").addAllNodes(Arrays.asList(responsesElement)).build();
        mockTpu.addResponse((AbstractMessage)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        TpuClient.ListNodesPagedResponse pagedListResponse = this.client.listNodes(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getNodesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockTpu.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListNodesRequest actualRequest = (ListNodesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listNodesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTpu.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            this.client.listNodes(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listNodesTest2() throws Exception {
        Node responsesElement = Node.newBuilder().build();
        ListNodesResponse expectedResponse = ListNodesResponse.newBuilder().setNextPageToken("").addAllNodes(Arrays.asList(responsesElement)).build();
        mockTpu.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        TpuClient.ListNodesPagedResponse pagedListResponse = this.client.listNodes(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getNodesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockTpu.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListNodesRequest actualRequest = (ListNodesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listNodesExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTpu.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listNodes(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getNodeTest() throws Exception {
        Node expectedResponse = Node.newBuilder().setName(NodeName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NODE]").toString()).setDescription("description-1724546052").setAcceleratorType("acceleratorType-82462651").setIpAddress("ipAddress1634032845").setPort("port3446913").setHealthDescription("healthDescription1231837184").setTensorflowVersion("tensorflowVersion-470125103").setNetwork("network1843485230").setCidrBlock("cidrBlock1646183801").setServiceAccount("serviceAccount1079137720").setCreateTime(Timestamp.newBuilder().build()).setSchedulingConfig(SchedulingConfig.newBuilder().build()).addAllNetworkEndpoints(new ArrayList()).putAllLabels(new HashMap()).setUseServiceNetworking(true).addAllSymptoms(new ArrayList()).build();
        mockTpu.addResponse((AbstractMessage)expectedResponse);
        NodeName name = NodeName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NODE]");
        Node actualResponse = this.client.getNode(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTpu.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetNodeRequest actualRequest = (GetNodeRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getNodeExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTpu.addException((Exception)exception);
        try {
            NodeName name = NodeName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NODE]");
            this.client.getNode(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getNodeTest2() throws Exception {
        Node expectedResponse = Node.newBuilder().setName(NodeName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NODE]").toString()).setDescription("description-1724546052").setAcceleratorType("acceleratorType-82462651").setIpAddress("ipAddress1634032845").setPort("port3446913").setHealthDescription("healthDescription1231837184").setTensorflowVersion("tensorflowVersion-470125103").setNetwork("network1843485230").setCidrBlock("cidrBlock1646183801").setServiceAccount("serviceAccount1079137720").setCreateTime(Timestamp.newBuilder().build()).setSchedulingConfig(SchedulingConfig.newBuilder().build()).addAllNetworkEndpoints(new ArrayList()).putAllLabels(new HashMap()).setUseServiceNetworking(true).addAllSymptoms(new ArrayList()).build();
        mockTpu.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Node actualResponse = this.client.getNode(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTpu.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetNodeRequest actualRequest = (GetNodeRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getNodeExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTpu.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getNode(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createNodeTest() throws Exception {
        Node expectedResponse = Node.newBuilder().setName(NodeName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NODE]").toString()).setDescription("description-1724546052").setAcceleratorType("acceleratorType-82462651").setIpAddress("ipAddress1634032845").setPort("port3446913").setHealthDescription("healthDescription1231837184").setTensorflowVersion("tensorflowVersion-470125103").setNetwork("network1843485230").setCidrBlock("cidrBlock1646183801").setServiceAccount("serviceAccount1079137720").setCreateTime(Timestamp.newBuilder().build()).setSchedulingConfig(SchedulingConfig.newBuilder().build()).addAllNetworkEndpoints(new ArrayList()).putAllLabels(new HashMap()).setUseServiceNetworking(true).addAllSymptoms(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("createNodeTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockTpu.addResponse((AbstractMessage)resultOperation);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        Node node = Node.newBuilder().build();
        String nodeId = "nodeId-1040171331";
        Node actualResponse = (Node)this.client.createNodeAsync(parent, node, nodeId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTpu.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateNodeRequest actualRequest = (CreateNodeRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)node, (Object)actualRequest.getNode());
        Assert.assertEquals((Object)nodeId, (Object)actualRequest.getNodeId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createNodeExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTpu.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            Node node = Node.newBuilder().build();
            String nodeId = "nodeId-1040171331";
            this.client.createNodeAsync(parent, node, nodeId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void createNodeTest2() throws Exception {
        Node expectedResponse = Node.newBuilder().setName(NodeName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NODE]").toString()).setDescription("description-1724546052").setAcceleratorType("acceleratorType-82462651").setIpAddress("ipAddress1634032845").setPort("port3446913").setHealthDescription("healthDescription1231837184").setTensorflowVersion("tensorflowVersion-470125103").setNetwork("network1843485230").setCidrBlock("cidrBlock1646183801").setServiceAccount("serviceAccount1079137720").setCreateTime(Timestamp.newBuilder().build()).setSchedulingConfig(SchedulingConfig.newBuilder().build()).addAllNetworkEndpoints(new ArrayList()).putAllLabels(new HashMap()).setUseServiceNetworking(true).addAllSymptoms(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("createNodeTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockTpu.addResponse((AbstractMessage)resultOperation);
        String parent = "parent-995424086";
        Node node = Node.newBuilder().build();
        String nodeId = "nodeId-1040171331";
        Node actualResponse = (Node)this.client.createNodeAsync(parent, node, nodeId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTpu.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateNodeRequest actualRequest = (CreateNodeRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)node, (Object)actualRequest.getNode());
        Assert.assertEquals((Object)nodeId, (Object)actualRequest.getNodeId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createNodeExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTpu.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            Node node = Node.newBuilder().build();
            String nodeId = "nodeId-1040171331";
            this.client.createNodeAsync(parent, node, nodeId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteNodeTest() throws Exception {
        Node expectedResponse = Node.newBuilder().setName(NodeName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NODE]").toString()).setDescription("description-1724546052").setAcceleratorType("acceleratorType-82462651").setIpAddress("ipAddress1634032845").setPort("port3446913").setHealthDescription("healthDescription1231837184").setTensorflowVersion("tensorflowVersion-470125103").setNetwork("network1843485230").setCidrBlock("cidrBlock1646183801").setServiceAccount("serviceAccount1079137720").setCreateTime(Timestamp.newBuilder().build()).setSchedulingConfig(SchedulingConfig.newBuilder().build()).addAllNetworkEndpoints(new ArrayList()).putAllLabels(new HashMap()).setUseServiceNetworking(true).addAllSymptoms(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("deleteNodeTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockTpu.addResponse((AbstractMessage)resultOperation);
        NodeName name = NodeName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NODE]");
        Node actualResponse = (Node)this.client.deleteNodeAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTpu.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteNodeRequest actualRequest = (DeleteNodeRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteNodeExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTpu.addException((Exception)exception);
        try {
            NodeName name = NodeName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NODE]");
            this.client.deleteNodeAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteNodeTest2() throws Exception {
        Node expectedResponse = Node.newBuilder().setName(NodeName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NODE]").toString()).setDescription("description-1724546052").setAcceleratorType("acceleratorType-82462651").setIpAddress("ipAddress1634032845").setPort("port3446913").setHealthDescription("healthDescription1231837184").setTensorflowVersion("tensorflowVersion-470125103").setNetwork("network1843485230").setCidrBlock("cidrBlock1646183801").setServiceAccount("serviceAccount1079137720").setCreateTime(Timestamp.newBuilder().build()).setSchedulingConfig(SchedulingConfig.newBuilder().build()).addAllNetworkEndpoints(new ArrayList()).putAllLabels(new HashMap()).setUseServiceNetworking(true).addAllSymptoms(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("deleteNodeTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockTpu.addResponse((AbstractMessage)resultOperation);
        String name = "name3373707";
        Node actualResponse = (Node)this.client.deleteNodeAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTpu.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteNodeRequest actualRequest = (DeleteNodeRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteNodeExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTpu.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteNodeAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void reimageNodeTest() throws Exception {
        Node expectedResponse = Node.newBuilder().setName(NodeName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NODE]").toString()).setDescription("description-1724546052").setAcceleratorType("acceleratorType-82462651").setIpAddress("ipAddress1634032845").setPort("port3446913").setHealthDescription("healthDescription1231837184").setTensorflowVersion("tensorflowVersion-470125103").setNetwork("network1843485230").setCidrBlock("cidrBlock1646183801").setServiceAccount("serviceAccount1079137720").setCreateTime(Timestamp.newBuilder().build()).setSchedulingConfig(SchedulingConfig.newBuilder().build()).addAllNetworkEndpoints(new ArrayList()).putAllLabels(new HashMap()).setUseServiceNetworking(true).addAllSymptoms(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("reimageNodeTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockTpu.addResponse((AbstractMessage)resultOperation);
        ReimageNodeRequest request = ReimageNodeRequest.newBuilder().setName("name3373707").setTensorflowVersion("tensorflowVersion-470125103").build();
        Node actualResponse = (Node)this.client.reimageNodeAsync(request).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTpu.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ReimageNodeRequest actualRequest = (ReimageNodeRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getName(), (Object)actualRequest.getName());
        Assert.assertEquals((Object)request.getTensorflowVersion(), (Object)actualRequest.getTensorflowVersion());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void reimageNodeExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTpu.addException((Exception)exception);
        try {
            ReimageNodeRequest request = ReimageNodeRequest.newBuilder().setName("name3373707").setTensorflowVersion("tensorflowVersion-470125103").build();
            this.client.reimageNodeAsync(request).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void stopNodeTest() throws Exception {
        Node expectedResponse = Node.newBuilder().setName(NodeName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NODE]").toString()).setDescription("description-1724546052").setAcceleratorType("acceleratorType-82462651").setIpAddress("ipAddress1634032845").setPort("port3446913").setHealthDescription("healthDescription1231837184").setTensorflowVersion("tensorflowVersion-470125103").setNetwork("network1843485230").setCidrBlock("cidrBlock1646183801").setServiceAccount("serviceAccount1079137720").setCreateTime(Timestamp.newBuilder().build()).setSchedulingConfig(SchedulingConfig.newBuilder().build()).addAllNetworkEndpoints(new ArrayList()).putAllLabels(new HashMap()).setUseServiceNetworking(true).addAllSymptoms(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("stopNodeTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockTpu.addResponse((AbstractMessage)resultOperation);
        StopNodeRequest request = StopNodeRequest.newBuilder().setName("name3373707").build();
        Node actualResponse = (Node)this.client.stopNodeAsync(request).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTpu.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        StopNodeRequest actualRequest = (StopNodeRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getName(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void stopNodeExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTpu.addException((Exception)exception);
        try {
            StopNodeRequest request = StopNodeRequest.newBuilder().setName("name3373707").build();
            this.client.stopNodeAsync(request).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void startNodeTest() throws Exception {
        Node expectedResponse = Node.newBuilder().setName(NodeName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NODE]").toString()).setDescription("description-1724546052").setAcceleratorType("acceleratorType-82462651").setIpAddress("ipAddress1634032845").setPort("port3446913").setHealthDescription("healthDescription1231837184").setTensorflowVersion("tensorflowVersion-470125103").setNetwork("network1843485230").setCidrBlock("cidrBlock1646183801").setServiceAccount("serviceAccount1079137720").setCreateTime(Timestamp.newBuilder().build()).setSchedulingConfig(SchedulingConfig.newBuilder().build()).addAllNetworkEndpoints(new ArrayList()).putAllLabels(new HashMap()).setUseServiceNetworking(true).addAllSymptoms(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("startNodeTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockTpu.addResponse((AbstractMessage)resultOperation);
        StartNodeRequest request = StartNodeRequest.newBuilder().setName("name3373707").build();
        Node actualResponse = (Node)this.client.startNodeAsync(request).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTpu.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        StartNodeRequest actualRequest = (StartNodeRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getName(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void startNodeExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTpu.addException((Exception)exception);
        try {
            StartNodeRequest request = StartNodeRequest.newBuilder().setName("name3373707").build();
            this.client.startNodeAsync(request).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void listTensorFlowVersionsTest() throws Exception {
        TensorFlowVersion responsesElement = TensorFlowVersion.newBuilder().build();
        ListTensorFlowVersionsResponse expectedResponse = ListTensorFlowVersionsResponse.newBuilder().setNextPageToken("").addAllTensorflowVersions(Arrays.asList(responsesElement)).build();
        mockTpu.addResponse((AbstractMessage)expectedResponse);
        TensorFlowVersionName parent = TensorFlowVersionName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[TENSOR_FLOW_VERSION]");
        TpuClient.ListTensorFlowVersionsPagedResponse pagedListResponse = this.client.listTensorFlowVersions(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getTensorflowVersionsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockTpu.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListTensorFlowVersionsRequest actualRequest = (ListTensorFlowVersionsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listTensorFlowVersionsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTpu.addException((Exception)exception);
        try {
            TensorFlowVersionName parent = TensorFlowVersionName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[TENSOR_FLOW_VERSION]");
            this.client.listTensorFlowVersions(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listTensorFlowVersionsTest2() throws Exception {
        TensorFlowVersion responsesElement = TensorFlowVersion.newBuilder().build();
        ListTensorFlowVersionsResponse expectedResponse = ListTensorFlowVersionsResponse.newBuilder().setNextPageToken("").addAllTensorflowVersions(Arrays.asList(responsesElement)).build();
        mockTpu.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        TpuClient.ListTensorFlowVersionsPagedResponse pagedListResponse = this.client.listTensorFlowVersions(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getTensorflowVersionsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockTpu.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListTensorFlowVersionsRequest actualRequest = (ListTensorFlowVersionsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listTensorFlowVersionsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTpu.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listTensorFlowVersions(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getTensorFlowVersionTest() throws Exception {
        TensorFlowVersion expectedResponse = TensorFlowVersion.newBuilder().setName(TensorFlowVersionName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[TENSOR_FLOW_VERSION]").toString()).setVersion("version351608024").build();
        mockTpu.addResponse((AbstractMessage)expectedResponse);
        TensorFlowVersionName name = TensorFlowVersionName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[TENSOR_FLOW_VERSION]");
        TensorFlowVersion actualResponse = this.client.getTensorFlowVersion(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTpu.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetTensorFlowVersionRequest actualRequest = (GetTensorFlowVersionRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getTensorFlowVersionExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTpu.addException((Exception)exception);
        try {
            TensorFlowVersionName name = TensorFlowVersionName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[TENSOR_FLOW_VERSION]");
            this.client.getTensorFlowVersion(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getTensorFlowVersionTest2() throws Exception {
        TensorFlowVersion expectedResponse = TensorFlowVersion.newBuilder().setName(TensorFlowVersionName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[TENSOR_FLOW_VERSION]").toString()).setVersion("version351608024").build();
        mockTpu.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        TensorFlowVersion actualResponse = this.client.getTensorFlowVersion(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTpu.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetTensorFlowVersionRequest actualRequest = (GetTensorFlowVersionRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getTensorFlowVersionExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTpu.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getTensorFlowVersion(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listAcceleratorTypesTest() throws Exception {
        AcceleratorType responsesElement = AcceleratorType.newBuilder().build();
        ListAcceleratorTypesResponse expectedResponse = ListAcceleratorTypesResponse.newBuilder().setNextPageToken("").addAllAcceleratorTypes(Arrays.asList(responsesElement)).build();
        mockTpu.addResponse((AbstractMessage)expectedResponse);
        AcceleratorTypeName parent = AcceleratorTypeName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ACCELERATOR_TYPE]");
        TpuClient.ListAcceleratorTypesPagedResponse pagedListResponse = this.client.listAcceleratorTypes(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getAcceleratorTypesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockTpu.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListAcceleratorTypesRequest actualRequest = (ListAcceleratorTypesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listAcceleratorTypesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTpu.addException((Exception)exception);
        try {
            AcceleratorTypeName parent = AcceleratorTypeName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ACCELERATOR_TYPE]");
            this.client.listAcceleratorTypes(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listAcceleratorTypesTest2() throws Exception {
        AcceleratorType responsesElement = AcceleratorType.newBuilder().build();
        ListAcceleratorTypesResponse expectedResponse = ListAcceleratorTypesResponse.newBuilder().setNextPageToken("").addAllAcceleratorTypes(Arrays.asList(responsesElement)).build();
        mockTpu.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        TpuClient.ListAcceleratorTypesPagedResponse pagedListResponse = this.client.listAcceleratorTypes(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getAcceleratorTypesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockTpu.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListAcceleratorTypesRequest actualRequest = (ListAcceleratorTypesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listAcceleratorTypesExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTpu.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listAcceleratorTypes(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getAcceleratorTypeTest() throws Exception {
        AcceleratorType expectedResponse = AcceleratorType.newBuilder().setName(AcceleratorTypeName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ACCELERATOR_TYPE]").toString()).setType("type3575610").build();
        mockTpu.addResponse((AbstractMessage)expectedResponse);
        AcceleratorTypeName name = AcceleratorTypeName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ACCELERATOR_TYPE]");
        AcceleratorType actualResponse = this.client.getAcceleratorType(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTpu.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetAcceleratorTypeRequest actualRequest = (GetAcceleratorTypeRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getAcceleratorTypeExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTpu.addException((Exception)exception);
        try {
            AcceleratorTypeName name = AcceleratorTypeName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ACCELERATOR_TYPE]");
            this.client.getAcceleratorType(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getAcceleratorTypeTest2() throws Exception {
        AcceleratorType expectedResponse = AcceleratorType.newBuilder().setName(AcceleratorTypeName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ACCELERATOR_TYPE]").toString()).setType("type3575610").build();
        mockTpu.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        AcceleratorType actualResponse = this.client.getAcceleratorType(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTpu.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetAcceleratorTypeRequest actualRequest = (GetAcceleratorTypeRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getAcceleratorTypeExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTpu.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getAcceleratorType(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

