/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tpu.v2alpha1;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.tpu.v2alpha1.AcceleratorType;
import com.google.cloud.tpu.v2alpha1.AcceleratorTypeName;
import com.google.cloud.tpu.v2alpha1.CreateNodeRequest;
import com.google.cloud.tpu.v2alpha1.DeleteNodeRequest;
import com.google.cloud.tpu.v2alpha1.GenerateServiceIdentityRequest;
import com.google.cloud.tpu.v2alpha1.GenerateServiceIdentityResponse;
import com.google.cloud.tpu.v2alpha1.GetAcceleratorTypeRequest;
import com.google.cloud.tpu.v2alpha1.GetGuestAttributesRequest;
import com.google.cloud.tpu.v2alpha1.GetGuestAttributesResponse;
import com.google.cloud.tpu.v2alpha1.GetNodeRequest;
import com.google.cloud.tpu.v2alpha1.GetRuntimeVersionRequest;
import com.google.cloud.tpu.v2alpha1.ListAcceleratorTypesRequest;
import com.google.cloud.tpu.v2alpha1.ListAcceleratorTypesResponse;
import com.google.cloud.tpu.v2alpha1.ListNodesRequest;
import com.google.cloud.tpu.v2alpha1.ListNodesResponse;
import com.google.cloud.tpu.v2alpha1.ListRuntimeVersionsRequest;
import com.google.cloud.tpu.v2alpha1.ListRuntimeVersionsResponse;
import com.google.cloud.tpu.v2alpha1.LocationName;
import com.google.cloud.tpu.v2alpha1.MockTpu;
import com.google.cloud.tpu.v2alpha1.NetworkConfig;
import com.google.cloud.tpu.v2alpha1.Node;
import com.google.cloud.tpu.v2alpha1.NodeName;
import com.google.cloud.tpu.v2alpha1.RuntimeVersion;
import com.google.cloud.tpu.v2alpha1.RuntimeVersionName;
import com.google.cloud.tpu.v2alpha1.SchedulingConfig;
import com.google.cloud.tpu.v2alpha1.ServiceAccount;
import com.google.cloud.tpu.v2alpha1.ServiceIdentity;
import com.google.cloud.tpu.v2alpha1.StartNodeRequest;
import com.google.cloud.tpu.v2alpha1.StopNodeRequest;
import com.google.cloud.tpu.v2alpha1.TpuClient;
import com.google.cloud.tpu.v2alpha1.TpuSettings;
import com.google.cloud.tpu.v2alpha1.UpdateNodeRequest;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Any;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TpuClientTest {
    private static MockServiceHelper mockServiceHelper;
    private static MockTpu mockTpu;
    private LocalChannelProvider channelProvider;
    private TpuClient client;

    @BeforeClass
    public static void startStaticServer() {
        mockTpu = new MockTpu();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockTpu));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        TpuSettings settings = ((TpuSettings.Builder)((TpuSettings.Builder)TpuSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = TpuClient.create((TpuSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void listNodesTest() throws Exception {
        Node responsesElement = Node.newBuilder().build();
        ListNodesResponse expectedResponse = ListNodesResponse.newBuilder().setNextPageToken("").addAllNodes(Arrays.asList(responsesElement)).build();
        mockTpu.addResponse((AbstractMessage)expectedResponse);
        NodeName parent = NodeName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NODE]");
        TpuClient.ListNodesPagedResponse pagedListResponse = this.client.listNodes(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getNodesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockTpu.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListNodesRequest actualRequest = (ListNodesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listNodesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTpu.addException((Exception)exception);
        try {
            NodeName parent = NodeName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NODE]");
            this.client.listNodes(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listNodesTest2() throws Exception {
        Node responsesElement = Node.newBuilder().build();
        ListNodesResponse expectedResponse = ListNodesResponse.newBuilder().setNextPageToken("").addAllNodes(Arrays.asList(responsesElement)).build();
        mockTpu.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        TpuClient.ListNodesPagedResponse pagedListResponse = this.client.listNodes(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getNodesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockTpu.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListNodesRequest actualRequest = (ListNodesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listNodesExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTpu.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listNodes(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getNodeTest() throws Exception {
        Node expectedResponse = Node.newBuilder().setName(NodeName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NODE]").toString()).setDescription("description-1724546052").setAcceleratorType("acceleratorType-82462651").setHealthDescription("healthDescription1231837184").setRuntimeVersion("runtimeVersion602071520").setNetworkConfig(NetworkConfig.newBuilder().build()).setCidrBlock("cidrBlock1646183801").setServiceAccount(ServiceAccount.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setSchedulingConfig(SchedulingConfig.newBuilder().build()).addAllNetworkEndpoints(new ArrayList()).putAllLabels(new HashMap()).putAllMetadata(new HashMap()).addAllTags(new ArrayList()).setId(3355L).addAllDataDisks(new ArrayList()).addAllSymptoms(new ArrayList()).build();
        mockTpu.addResponse((AbstractMessage)expectedResponse);
        NodeName name = NodeName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NODE]");
        Node actualResponse = this.client.getNode(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTpu.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetNodeRequest actualRequest = (GetNodeRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getNodeExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTpu.addException((Exception)exception);
        try {
            NodeName name = NodeName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NODE]");
            this.client.getNode(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getNodeTest2() throws Exception {
        Node expectedResponse = Node.newBuilder().setName(NodeName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NODE]").toString()).setDescription("description-1724546052").setAcceleratorType("acceleratorType-82462651").setHealthDescription("healthDescription1231837184").setRuntimeVersion("runtimeVersion602071520").setNetworkConfig(NetworkConfig.newBuilder().build()).setCidrBlock("cidrBlock1646183801").setServiceAccount(ServiceAccount.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setSchedulingConfig(SchedulingConfig.newBuilder().build()).addAllNetworkEndpoints(new ArrayList()).putAllLabels(new HashMap()).putAllMetadata(new HashMap()).addAllTags(new ArrayList()).setId(3355L).addAllDataDisks(new ArrayList()).addAllSymptoms(new ArrayList()).build();
        mockTpu.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Node actualResponse = this.client.getNode(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTpu.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetNodeRequest actualRequest = (GetNodeRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getNodeExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTpu.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getNode(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createNodeTest() throws Exception {
        Node expectedResponse = Node.newBuilder().setName(NodeName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NODE]").toString()).setDescription("description-1724546052").setAcceleratorType("acceleratorType-82462651").setHealthDescription("healthDescription1231837184").setRuntimeVersion("runtimeVersion602071520").setNetworkConfig(NetworkConfig.newBuilder().build()).setCidrBlock("cidrBlock1646183801").setServiceAccount(ServiceAccount.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setSchedulingConfig(SchedulingConfig.newBuilder().build()).addAllNetworkEndpoints(new ArrayList()).putAllLabels(new HashMap()).putAllMetadata(new HashMap()).addAllTags(new ArrayList()).setId(3355L).addAllDataDisks(new ArrayList()).addAllSymptoms(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("createNodeTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockTpu.addResponse((AbstractMessage)resultOperation);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        Node node = Node.newBuilder().build();
        String nodeId = "nodeId-1040171331";
        Node actualResponse = (Node)this.client.createNodeAsync(parent, node, nodeId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTpu.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateNodeRequest actualRequest = (CreateNodeRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)node, (Object)actualRequest.getNode());
        Assert.assertEquals((Object)nodeId, (Object)actualRequest.getNodeId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createNodeExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTpu.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            Node node = Node.newBuilder().build();
            String nodeId = "nodeId-1040171331";
            this.client.createNodeAsync(parent, node, nodeId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void createNodeTest2() throws Exception {
        Node expectedResponse = Node.newBuilder().setName(NodeName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NODE]").toString()).setDescription("description-1724546052").setAcceleratorType("acceleratorType-82462651").setHealthDescription("healthDescription1231837184").setRuntimeVersion("runtimeVersion602071520").setNetworkConfig(NetworkConfig.newBuilder().build()).setCidrBlock("cidrBlock1646183801").setServiceAccount(ServiceAccount.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setSchedulingConfig(SchedulingConfig.newBuilder().build()).addAllNetworkEndpoints(new ArrayList()).putAllLabels(new HashMap()).putAllMetadata(new HashMap()).addAllTags(new ArrayList()).setId(3355L).addAllDataDisks(new ArrayList()).addAllSymptoms(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("createNodeTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockTpu.addResponse((AbstractMessage)resultOperation);
        String parent = "parent-995424086";
        Node node = Node.newBuilder().build();
        String nodeId = "nodeId-1040171331";
        Node actualResponse = (Node)this.client.createNodeAsync(parent, node, nodeId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTpu.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateNodeRequest actualRequest = (CreateNodeRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)node, (Object)actualRequest.getNode());
        Assert.assertEquals((Object)nodeId, (Object)actualRequest.getNodeId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createNodeExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTpu.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            Node node = Node.newBuilder().build();
            String nodeId = "nodeId-1040171331";
            this.client.createNodeAsync(parent, node, nodeId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteNodeTest() throws Exception {
        Node expectedResponse = Node.newBuilder().setName(NodeName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NODE]").toString()).setDescription("description-1724546052").setAcceleratorType("acceleratorType-82462651").setHealthDescription("healthDescription1231837184").setRuntimeVersion("runtimeVersion602071520").setNetworkConfig(NetworkConfig.newBuilder().build()).setCidrBlock("cidrBlock1646183801").setServiceAccount(ServiceAccount.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setSchedulingConfig(SchedulingConfig.newBuilder().build()).addAllNetworkEndpoints(new ArrayList()).putAllLabels(new HashMap()).putAllMetadata(new HashMap()).addAllTags(new ArrayList()).setId(3355L).addAllDataDisks(new ArrayList()).addAllSymptoms(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("deleteNodeTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockTpu.addResponse((AbstractMessage)resultOperation);
        NodeName name = NodeName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NODE]");
        Node actualResponse = (Node)this.client.deleteNodeAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTpu.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteNodeRequest actualRequest = (DeleteNodeRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteNodeExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTpu.addException((Exception)exception);
        try {
            NodeName name = NodeName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NODE]");
            this.client.deleteNodeAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteNodeTest2() throws Exception {
        Node expectedResponse = Node.newBuilder().setName(NodeName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NODE]").toString()).setDescription("description-1724546052").setAcceleratorType("acceleratorType-82462651").setHealthDescription("healthDescription1231837184").setRuntimeVersion("runtimeVersion602071520").setNetworkConfig(NetworkConfig.newBuilder().build()).setCidrBlock("cidrBlock1646183801").setServiceAccount(ServiceAccount.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setSchedulingConfig(SchedulingConfig.newBuilder().build()).addAllNetworkEndpoints(new ArrayList()).putAllLabels(new HashMap()).putAllMetadata(new HashMap()).addAllTags(new ArrayList()).setId(3355L).addAllDataDisks(new ArrayList()).addAllSymptoms(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("deleteNodeTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockTpu.addResponse((AbstractMessage)resultOperation);
        String name = "name3373707";
        Node actualResponse = (Node)this.client.deleteNodeAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTpu.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteNodeRequest actualRequest = (DeleteNodeRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteNodeExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTpu.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteNodeAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void stopNodeTest() throws Exception {
        Node expectedResponse = Node.newBuilder().setName(NodeName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NODE]").toString()).setDescription("description-1724546052").setAcceleratorType("acceleratorType-82462651").setHealthDescription("healthDescription1231837184").setRuntimeVersion("runtimeVersion602071520").setNetworkConfig(NetworkConfig.newBuilder().build()).setCidrBlock("cidrBlock1646183801").setServiceAccount(ServiceAccount.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setSchedulingConfig(SchedulingConfig.newBuilder().build()).addAllNetworkEndpoints(new ArrayList()).putAllLabels(new HashMap()).putAllMetadata(new HashMap()).addAllTags(new ArrayList()).setId(3355L).addAllDataDisks(new ArrayList()).addAllSymptoms(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("stopNodeTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockTpu.addResponse((AbstractMessage)resultOperation);
        StopNodeRequest request = StopNodeRequest.newBuilder().setName("name3373707").build();
        Node actualResponse = (Node)this.client.stopNodeAsync(request).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTpu.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        StopNodeRequest actualRequest = (StopNodeRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getName(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void stopNodeExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTpu.addException((Exception)exception);
        try {
            StopNodeRequest request = StopNodeRequest.newBuilder().setName("name3373707").build();
            this.client.stopNodeAsync(request).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void startNodeTest() throws Exception {
        Node expectedResponse = Node.newBuilder().setName(NodeName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NODE]").toString()).setDescription("description-1724546052").setAcceleratorType("acceleratorType-82462651").setHealthDescription("healthDescription1231837184").setRuntimeVersion("runtimeVersion602071520").setNetworkConfig(NetworkConfig.newBuilder().build()).setCidrBlock("cidrBlock1646183801").setServiceAccount(ServiceAccount.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setSchedulingConfig(SchedulingConfig.newBuilder().build()).addAllNetworkEndpoints(new ArrayList()).putAllLabels(new HashMap()).putAllMetadata(new HashMap()).addAllTags(new ArrayList()).setId(3355L).addAllDataDisks(new ArrayList()).addAllSymptoms(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("startNodeTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockTpu.addResponse((AbstractMessage)resultOperation);
        StartNodeRequest request = StartNodeRequest.newBuilder().setName("name3373707").build();
        Node actualResponse = (Node)this.client.startNodeAsync(request).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTpu.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        StartNodeRequest actualRequest = (StartNodeRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getName(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void startNodeExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTpu.addException((Exception)exception);
        try {
            StartNodeRequest request = StartNodeRequest.newBuilder().setName("name3373707").build();
            this.client.startNodeAsync(request).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void updateNodeTest() throws Exception {
        Node expectedResponse = Node.newBuilder().setName(NodeName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NODE]").toString()).setDescription("description-1724546052").setAcceleratorType("acceleratorType-82462651").setHealthDescription("healthDescription1231837184").setRuntimeVersion("runtimeVersion602071520").setNetworkConfig(NetworkConfig.newBuilder().build()).setCidrBlock("cidrBlock1646183801").setServiceAccount(ServiceAccount.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setSchedulingConfig(SchedulingConfig.newBuilder().build()).addAllNetworkEndpoints(new ArrayList()).putAllLabels(new HashMap()).putAllMetadata(new HashMap()).addAllTags(new ArrayList()).setId(3355L).addAllDataDisks(new ArrayList()).addAllSymptoms(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("updateNodeTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockTpu.addResponse((AbstractMessage)resultOperation);
        Node node = Node.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Node actualResponse = (Node)this.client.updateNodeAsync(node, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTpu.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateNodeRequest actualRequest = (UpdateNodeRequest)actualRequests.get(0);
        Assert.assertEquals((Object)node, (Object)actualRequest.getNode());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateNodeExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTpu.addException((Exception)exception);
        try {
            Node node = Node.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateNodeAsync(node, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void generateServiceIdentityTest() throws Exception {
        GenerateServiceIdentityResponse expectedResponse = GenerateServiceIdentityResponse.newBuilder().setIdentity(ServiceIdentity.newBuilder().build()).build();
        mockTpu.addResponse((AbstractMessage)expectedResponse);
        GenerateServiceIdentityRequest request = GenerateServiceIdentityRequest.newBuilder().setParent(LocationName.of((String)"[PROJECT]", (String)"[LOCATION]").toString()).build();
        GenerateServiceIdentityResponse actualResponse = this.client.generateServiceIdentity(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTpu.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GenerateServiceIdentityRequest actualRequest = (GenerateServiceIdentityRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getParent(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void generateServiceIdentityExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTpu.addException((Exception)exception);
        try {
            GenerateServiceIdentityRequest request = GenerateServiceIdentityRequest.newBuilder().setParent(LocationName.of((String)"[PROJECT]", (String)"[LOCATION]").toString()).build();
            this.client.generateServiceIdentity(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listAcceleratorTypesTest() throws Exception {
        AcceleratorType responsesElement = AcceleratorType.newBuilder().build();
        ListAcceleratorTypesResponse expectedResponse = ListAcceleratorTypesResponse.newBuilder().setNextPageToken("").addAllAcceleratorTypes(Arrays.asList(responsesElement)).build();
        mockTpu.addResponse((AbstractMessage)expectedResponse);
        AcceleratorTypeName parent = AcceleratorTypeName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ACCELERATOR_TYPE]");
        TpuClient.ListAcceleratorTypesPagedResponse pagedListResponse = this.client.listAcceleratorTypes(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getAcceleratorTypesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockTpu.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListAcceleratorTypesRequest actualRequest = (ListAcceleratorTypesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listAcceleratorTypesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTpu.addException((Exception)exception);
        try {
            AcceleratorTypeName parent = AcceleratorTypeName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ACCELERATOR_TYPE]");
            this.client.listAcceleratorTypes(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listAcceleratorTypesTest2() throws Exception {
        AcceleratorType responsesElement = AcceleratorType.newBuilder().build();
        ListAcceleratorTypesResponse expectedResponse = ListAcceleratorTypesResponse.newBuilder().setNextPageToken("").addAllAcceleratorTypes(Arrays.asList(responsesElement)).build();
        mockTpu.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        TpuClient.ListAcceleratorTypesPagedResponse pagedListResponse = this.client.listAcceleratorTypes(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getAcceleratorTypesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockTpu.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListAcceleratorTypesRequest actualRequest = (ListAcceleratorTypesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listAcceleratorTypesExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTpu.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listAcceleratorTypes(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getAcceleratorTypeTest() throws Exception {
        AcceleratorType expectedResponse = AcceleratorType.newBuilder().setName(AcceleratorTypeName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ACCELERATOR_TYPE]").toString()).setType("type3575610").build();
        mockTpu.addResponse((AbstractMessage)expectedResponse);
        AcceleratorTypeName name = AcceleratorTypeName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ACCELERATOR_TYPE]");
        AcceleratorType actualResponse = this.client.getAcceleratorType(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTpu.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetAcceleratorTypeRequest actualRequest = (GetAcceleratorTypeRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getAcceleratorTypeExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTpu.addException((Exception)exception);
        try {
            AcceleratorTypeName name = AcceleratorTypeName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ACCELERATOR_TYPE]");
            this.client.getAcceleratorType(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getAcceleratorTypeTest2() throws Exception {
        AcceleratorType expectedResponse = AcceleratorType.newBuilder().setName(AcceleratorTypeName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ACCELERATOR_TYPE]").toString()).setType("type3575610").build();
        mockTpu.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        AcceleratorType actualResponse = this.client.getAcceleratorType(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTpu.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetAcceleratorTypeRequest actualRequest = (GetAcceleratorTypeRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getAcceleratorTypeExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTpu.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getAcceleratorType(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listRuntimeVersionsTest() throws Exception {
        RuntimeVersion responsesElement = RuntimeVersion.newBuilder().build();
        ListRuntimeVersionsResponse expectedResponse = ListRuntimeVersionsResponse.newBuilder().setNextPageToken("").addAllRuntimeVersions(Arrays.asList(responsesElement)).build();
        mockTpu.addResponse((AbstractMessage)expectedResponse);
        RuntimeVersionName parent = RuntimeVersionName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[RUNTIME_VERSION]");
        TpuClient.ListRuntimeVersionsPagedResponse pagedListResponse = this.client.listRuntimeVersions(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getRuntimeVersionsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockTpu.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListRuntimeVersionsRequest actualRequest = (ListRuntimeVersionsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listRuntimeVersionsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTpu.addException((Exception)exception);
        try {
            RuntimeVersionName parent = RuntimeVersionName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[RUNTIME_VERSION]");
            this.client.listRuntimeVersions(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listRuntimeVersionsTest2() throws Exception {
        RuntimeVersion responsesElement = RuntimeVersion.newBuilder().build();
        ListRuntimeVersionsResponse expectedResponse = ListRuntimeVersionsResponse.newBuilder().setNextPageToken("").addAllRuntimeVersions(Arrays.asList(responsesElement)).build();
        mockTpu.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        TpuClient.ListRuntimeVersionsPagedResponse pagedListResponse = this.client.listRuntimeVersions(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getRuntimeVersionsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockTpu.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListRuntimeVersionsRequest actualRequest = (ListRuntimeVersionsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listRuntimeVersionsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTpu.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listRuntimeVersions(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getRuntimeVersionTest() throws Exception {
        RuntimeVersion expectedResponse = RuntimeVersion.newBuilder().setName(RuntimeVersionName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[RUNTIME_VERSION]").toString()).setVersion("version351608024").build();
        mockTpu.addResponse((AbstractMessage)expectedResponse);
        RuntimeVersionName name = RuntimeVersionName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[RUNTIME_VERSION]");
        RuntimeVersion actualResponse = this.client.getRuntimeVersion(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTpu.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetRuntimeVersionRequest actualRequest = (GetRuntimeVersionRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getRuntimeVersionExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTpu.addException((Exception)exception);
        try {
            RuntimeVersionName name = RuntimeVersionName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[RUNTIME_VERSION]");
            this.client.getRuntimeVersion(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getRuntimeVersionTest2() throws Exception {
        RuntimeVersion expectedResponse = RuntimeVersion.newBuilder().setName(RuntimeVersionName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[RUNTIME_VERSION]").toString()).setVersion("version351608024").build();
        mockTpu.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        RuntimeVersion actualResponse = this.client.getRuntimeVersion(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTpu.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetRuntimeVersionRequest actualRequest = (GetRuntimeVersionRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getRuntimeVersionExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTpu.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getRuntimeVersion(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getGuestAttributesTest() throws Exception {
        GetGuestAttributesResponse expectedResponse = GetGuestAttributesResponse.newBuilder().addAllGuestAttributes(new ArrayList()).build();
        mockTpu.addResponse((AbstractMessage)expectedResponse);
        GetGuestAttributesRequest request = GetGuestAttributesRequest.newBuilder().setName(NodeName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NODE]").toString()).setQueryPath("queryPath-1807004403").addAllWorkerIds(new ArrayList()).build();
        GetGuestAttributesResponse actualResponse = this.client.getGuestAttributes(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTpu.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetGuestAttributesRequest actualRequest = (GetGuestAttributesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getName(), (Object)actualRequest.getName());
        Assert.assertEquals((Object)request.getQueryPath(), (Object)actualRequest.getQueryPath());
        Assert.assertEquals((Object)request.getWorkerIdsList(), (Object)actualRequest.getWorkerIdsList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getGuestAttributesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTpu.addException((Exception)exception);
        try {
            GetGuestAttributesRequest request = GetGuestAttributesRequest.newBuilder().setName(NodeName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[NODE]").toString()).setQueryPath("queryPath-1807004403").addAllWorkerIds(new ArrayList()).build();
            this.client.getGuestAttributes(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

