/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.video.transcoder.v1;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.video.transcoder.v1.CreateJobRequest;
import com.google.cloud.video.transcoder.v1.CreateJobTemplateRequest;
import com.google.cloud.video.transcoder.v1.DeleteJobRequest;
import com.google.cloud.video.transcoder.v1.DeleteJobTemplateRequest;
import com.google.cloud.video.transcoder.v1.GetJobRequest;
import com.google.cloud.video.transcoder.v1.GetJobTemplateRequest;
import com.google.cloud.video.transcoder.v1.Job;
import com.google.cloud.video.transcoder.v1.JobConfig;
import com.google.cloud.video.transcoder.v1.JobName;
import com.google.cloud.video.transcoder.v1.JobTemplate;
import com.google.cloud.video.transcoder.v1.JobTemplateName;
import com.google.cloud.video.transcoder.v1.ListJobTemplatesRequest;
import com.google.cloud.video.transcoder.v1.ListJobTemplatesResponse;
import com.google.cloud.video.transcoder.v1.ListJobsRequest;
import com.google.cloud.video.transcoder.v1.ListJobsResponse;
import com.google.cloud.video.transcoder.v1.LocationName;
import com.google.cloud.video.transcoder.v1.MockTranscoderService;
import com.google.cloud.video.transcoder.v1.TranscoderServiceClient;
import com.google.cloud.video.transcoder.v1.TranscoderServiceSettings;
import com.google.common.collect.Lists;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Empty;
import com.google.protobuf.Timestamp;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TranscoderServiceClientTest {
    private static MockServiceHelper mockServiceHelper;
    private static MockTranscoderService mockTranscoderService;
    private LocalChannelProvider channelProvider;
    private TranscoderServiceClient client;

    @BeforeClass
    public static void startStaticServer() {
        mockTranscoderService = new MockTranscoderService();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockTranscoderService));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        TranscoderServiceSettings settings = ((TranscoderServiceSettings.Builder)((TranscoderServiceSettings.Builder)TranscoderServiceSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = TranscoderServiceClient.create((TranscoderServiceSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void createJobTest() throws Exception {
        Job expectedResponse = Job.newBuilder().setName(JobName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[JOB]").toString()).setInputUri("inputUri470706498").setOutputUri("outputUri-2119300949").setCreateTime(Timestamp.newBuilder().build()).setStartTime(Timestamp.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).setTtlAfterCompletionDays(107576420).setError(com.google.rpc.Status.newBuilder().build()).build();
        mockTranscoderService.addResponse((AbstractMessage)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        Job job = Job.newBuilder().build();
        Job actualResponse = this.client.createJob(parent, job);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTranscoderService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateJobRequest actualRequest = (CreateJobRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)job, (Object)actualRequest.getJob());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createJobExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranscoderService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            Job job = Job.newBuilder().build();
            this.client.createJob(parent, job);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createJobTest2() throws Exception {
        Job expectedResponse = Job.newBuilder().setName(JobName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[JOB]").toString()).setInputUri("inputUri470706498").setOutputUri("outputUri-2119300949").setCreateTime(Timestamp.newBuilder().build()).setStartTime(Timestamp.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).setTtlAfterCompletionDays(107576420).setError(com.google.rpc.Status.newBuilder().build()).build();
        mockTranscoderService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        Job job = Job.newBuilder().build();
        Job actualResponse = this.client.createJob(parent, job);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTranscoderService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateJobRequest actualRequest = (CreateJobRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)job, (Object)actualRequest.getJob());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createJobExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranscoderService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            Job job = Job.newBuilder().build();
            this.client.createJob(parent, job);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listJobsTest() throws Exception {
        Job responsesElement = Job.newBuilder().build();
        ListJobsResponse expectedResponse = ListJobsResponse.newBuilder().setNextPageToken("").addAllJobs(Arrays.asList(responsesElement)).build();
        mockTranscoderService.addResponse((AbstractMessage)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        TranscoderServiceClient.ListJobsPagedResponse pagedListResponse = this.client.listJobs(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getJobsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockTranscoderService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListJobsRequest actualRequest = (ListJobsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listJobsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranscoderService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            this.client.listJobs(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listJobsTest2() throws Exception {
        Job responsesElement = Job.newBuilder().build();
        ListJobsResponse expectedResponse = ListJobsResponse.newBuilder().setNextPageToken("").addAllJobs(Arrays.asList(responsesElement)).build();
        mockTranscoderService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        TranscoderServiceClient.ListJobsPagedResponse pagedListResponse = this.client.listJobs(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getJobsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockTranscoderService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListJobsRequest actualRequest = (ListJobsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listJobsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranscoderService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listJobs(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getJobTest() throws Exception {
        Job expectedResponse = Job.newBuilder().setName(JobName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[JOB]").toString()).setInputUri("inputUri470706498").setOutputUri("outputUri-2119300949").setCreateTime(Timestamp.newBuilder().build()).setStartTime(Timestamp.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).setTtlAfterCompletionDays(107576420).setError(com.google.rpc.Status.newBuilder().build()).build();
        mockTranscoderService.addResponse((AbstractMessage)expectedResponse);
        JobName name = JobName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[JOB]");
        Job actualResponse = this.client.getJob(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTranscoderService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetJobRequest actualRequest = (GetJobRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getJobExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranscoderService.addException((Exception)exception);
        try {
            JobName name = JobName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[JOB]");
            this.client.getJob(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getJobTest2() throws Exception {
        Job expectedResponse = Job.newBuilder().setName(JobName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[JOB]").toString()).setInputUri("inputUri470706498").setOutputUri("outputUri-2119300949").setCreateTime(Timestamp.newBuilder().build()).setStartTime(Timestamp.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).setTtlAfterCompletionDays(107576420).setError(com.google.rpc.Status.newBuilder().build()).build();
        mockTranscoderService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Job actualResponse = this.client.getJob(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTranscoderService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetJobRequest actualRequest = (GetJobRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getJobExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranscoderService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getJob(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteJobTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockTranscoderService.addResponse((AbstractMessage)expectedResponse);
        JobName name = JobName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[JOB]");
        this.client.deleteJob(name);
        List<AbstractMessage> actualRequests = mockTranscoderService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteJobRequest actualRequest = (DeleteJobRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteJobExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranscoderService.addException((Exception)exception);
        try {
            JobName name = JobName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[JOB]");
            this.client.deleteJob(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteJobTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockTranscoderService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        this.client.deleteJob(name);
        List<AbstractMessage> actualRequests = mockTranscoderService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteJobRequest actualRequest = (DeleteJobRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteJobExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranscoderService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteJob(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createJobTemplateTest() throws Exception {
        JobTemplate expectedResponse = JobTemplate.newBuilder().setName(JobTemplateName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[JOB_TEMPLATE]").toString()).setConfig(JobConfig.newBuilder().build()).build();
        mockTranscoderService.addResponse((AbstractMessage)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        JobTemplate jobTemplate = JobTemplate.newBuilder().build();
        String jobTemplateId = "jobTemplateId-597733678";
        JobTemplate actualResponse = this.client.createJobTemplate(parent, jobTemplate, jobTemplateId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTranscoderService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateJobTemplateRequest actualRequest = (CreateJobTemplateRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)jobTemplate, (Object)actualRequest.getJobTemplate());
        Assert.assertEquals((Object)jobTemplateId, (Object)actualRequest.getJobTemplateId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createJobTemplateExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranscoderService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            JobTemplate jobTemplate = JobTemplate.newBuilder().build();
            String jobTemplateId = "jobTemplateId-597733678";
            this.client.createJobTemplate(parent, jobTemplate, jobTemplateId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createJobTemplateTest2() throws Exception {
        JobTemplate expectedResponse = JobTemplate.newBuilder().setName(JobTemplateName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[JOB_TEMPLATE]").toString()).setConfig(JobConfig.newBuilder().build()).build();
        mockTranscoderService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        JobTemplate jobTemplate = JobTemplate.newBuilder().build();
        String jobTemplateId = "jobTemplateId-597733678";
        JobTemplate actualResponse = this.client.createJobTemplate(parent, jobTemplate, jobTemplateId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTranscoderService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateJobTemplateRequest actualRequest = (CreateJobTemplateRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)jobTemplate, (Object)actualRequest.getJobTemplate());
        Assert.assertEquals((Object)jobTemplateId, (Object)actualRequest.getJobTemplateId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createJobTemplateExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranscoderService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            JobTemplate jobTemplate = JobTemplate.newBuilder().build();
            String jobTemplateId = "jobTemplateId-597733678";
            this.client.createJobTemplate(parent, jobTemplate, jobTemplateId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listJobTemplatesTest() throws Exception {
        JobTemplate responsesElement = JobTemplate.newBuilder().build();
        ListJobTemplatesResponse expectedResponse = ListJobTemplatesResponse.newBuilder().setNextPageToken("").addAllJobTemplates(Arrays.asList(responsesElement)).build();
        mockTranscoderService.addResponse((AbstractMessage)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        TranscoderServiceClient.ListJobTemplatesPagedResponse pagedListResponse = this.client.listJobTemplates(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getJobTemplatesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockTranscoderService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListJobTemplatesRequest actualRequest = (ListJobTemplatesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listJobTemplatesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranscoderService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            this.client.listJobTemplates(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listJobTemplatesTest2() throws Exception {
        JobTemplate responsesElement = JobTemplate.newBuilder().build();
        ListJobTemplatesResponse expectedResponse = ListJobTemplatesResponse.newBuilder().setNextPageToken("").addAllJobTemplates(Arrays.asList(responsesElement)).build();
        mockTranscoderService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        TranscoderServiceClient.ListJobTemplatesPagedResponse pagedListResponse = this.client.listJobTemplates(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getJobTemplatesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockTranscoderService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListJobTemplatesRequest actualRequest = (ListJobTemplatesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listJobTemplatesExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranscoderService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listJobTemplates(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getJobTemplateTest() throws Exception {
        JobTemplate expectedResponse = JobTemplate.newBuilder().setName(JobTemplateName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[JOB_TEMPLATE]").toString()).setConfig(JobConfig.newBuilder().build()).build();
        mockTranscoderService.addResponse((AbstractMessage)expectedResponse);
        JobTemplateName name = JobTemplateName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[JOB_TEMPLATE]");
        JobTemplate actualResponse = this.client.getJobTemplate(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTranscoderService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetJobTemplateRequest actualRequest = (GetJobTemplateRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getJobTemplateExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranscoderService.addException((Exception)exception);
        try {
            JobTemplateName name = JobTemplateName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[JOB_TEMPLATE]");
            this.client.getJobTemplate(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getJobTemplateTest2() throws Exception {
        JobTemplate expectedResponse = JobTemplate.newBuilder().setName(JobTemplateName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[JOB_TEMPLATE]").toString()).setConfig(JobConfig.newBuilder().build()).build();
        mockTranscoderService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        JobTemplate actualResponse = this.client.getJobTemplate(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockTranscoderService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetJobTemplateRequest actualRequest = (GetJobTemplateRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getJobTemplateExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranscoderService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getJobTemplate(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteJobTemplateTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockTranscoderService.addResponse((AbstractMessage)expectedResponse);
        JobTemplateName name = JobTemplateName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[JOB_TEMPLATE]");
        this.client.deleteJobTemplate(name);
        List<AbstractMessage> actualRequests = mockTranscoderService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteJobTemplateRequest actualRequest = (DeleteJobTemplateRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteJobTemplateExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranscoderService.addException((Exception)exception);
        try {
            JobTemplateName name = JobTemplateName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[JOB_TEMPLATE]");
            this.client.deleteJobTemplate(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteJobTemplateTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockTranscoderService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        this.client.deleteJobTemplate(name);
        List<AbstractMessage> actualRequests = mockTranscoderService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteJobTemplateRequest actualRequest = (DeleteJobTemplateRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteJobTemplateExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockTranscoderService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteJobTemplate(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

