/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.recaptcha.passwordcheck;

import com.google.cloud.recaptcha.passwordcheck.PasswordCheckResult;
import com.google.cloud.recaptcha.passwordcheck.utils.BCScryptGenerator;
import com.google.cloud.recaptcha.passwordcheck.utils.CryptoHelper;
import com.google.cloud.recaptcha.passwordcheck.utils.ScryptGenerator;
import com.google.cloud.recaptcha.passwordcheck.utils.SensitiveString;
import com.google.common.hash.Hashing;
import com.google.privacy.encryption.commutative.EcCommutativeCipher;
import com.google.privacy.encryption.commutative.SupportedCurve;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;

public final class PasswordCheckVerification {
    static final ScryptGenerator SCRYPT_GENERATOR = new BCScryptGenerator();
    static final SupportedCurve EC_CURVE = SupportedCurve.SECP256R1;
    static final int USERNAME_HASH_PREFIX_LENGTH = 26;
    private final String username;
    private final EcCommutativeCipher cipher = EcCommutativeCipher.createWithNewKey(EC_CURVE);
    private byte[] encryptedUserCredentialsHash;
    private byte[] lookupHashPrefix;

    private PasswordCheckVerification(String username) {
        this.username = username;
    }

    public byte[] getEncryptedUserCredentialsHash() {
        return this.encryptedUserCredentialsHash;
    }

    @Deprecated
    public byte[] getEncryptedLookupHash() {
        return this.encryptedUserCredentialsHash;
    }

    public byte[] getLookupHashPrefix() {
        return this.lookupHashPrefix;
    }

    EcCommutativeCipher getCipher() {
        return this.cipher;
    }

    static CompletableFuture<PasswordCheckVerification> create(String username, SensitiveString password, ExecutorService executorService) {
        return CompletableFuture.supplyAsync(PasswordCheckVerification.getCreatorSupplier(username, password), executorService);
    }

    CompletableFuture<PasswordCheckResult> verify(byte[] reEncryptedUserCredentialsHash, Collection<byte[]> encryptedLeakMatchPrefixList, ExecutorService executorService) {
        if (reEncryptedUserCredentialsHash == null || reEncryptedUserCredentialsHash.length == 0) {
            throw new IllegalArgumentException("reEncryptedLookupHash must be present");
        }
        if (encryptedLeakMatchPrefixList == null) {
            throw new IllegalArgumentException("encryptedLeakMatchPrefixList cannot be null");
        }
        return CompletableFuture.supplyAsync(() -> {
            byte[] serverEncryptedUserCredentialsHash = this.cipher.decrypt(reEncryptedUserCredentialsHash);
            byte[] reHashedEncryptedUserCredentialsHash = Hashing.sha256().hashBytes(serverEncryptedUserCredentialsHash).asBytes();
            boolean credentialsLeaked = encryptedLeakMatchPrefixList.stream().anyMatch(prefix -> this.isPrefixMatch(reHashedEncryptedUserCredentialsHash, (byte[])prefix));
            return new PasswordCheckResult(this, this.username, credentialsLeaked);
        }, executorService);
    }

    private static Supplier<PasswordCheckVerification> getCreatorSupplier(String username, SensitiveString password) {
        return () -> {
            PasswordCheckVerification verification = new PasswordCheckVerification(username);
            String canonicalizedUsername = CryptoHelper.canonicalizeUsername(username);
            verification.encryptedUserCredentialsHash = verification.cipher.encrypt(CryptoHelper.hashUsernamePasswordPair(canonicalizedUsername, password, SCRYPT_GENERATOR));
            verification.lookupHashPrefix = CryptoHelper.bucketizeUsername(canonicalizedUsername, 26);
            return verification;
        };
    }

    private boolean isPrefixMatch(byte[] reHashedEncryptedUserCredentialsHash, byte[] prefix) {
        if (prefix.length == 0 || prefix.length > reHashedEncryptedUserCredentialsHash.length) {
            return false;
        }
        for (int i = 0; i < prefix.length; ++i) {
            if (reHashedEncryptedUserCredentialsHash[i] == prefix[i]) continue;
            return false;
        }
        return true;
    }
}

