/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.recaptcha.passwordcheck;

import com.google.cloud.recaptcha.passwordcheck.PasswordCheckResult;
import com.google.cloud.recaptcha.passwordcheck.PasswordCheckVerification;
import com.google.cloud.recaptcha.passwordcheck.utils.SensitiveString;
import com.google.common.base.Strings;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class PasswordCheckVerifier {
    private static final int DEFAULT_N_THREADS = 10;
    private final ExecutorService executorService;

    public PasswordCheckVerifier(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public PasswordCheckVerifier() {
        this.executorService = Executors.newFixedThreadPool(10);
    }

    public CompletableFuture<PasswordCheckVerification> createVerification(String username, String password) {
        if (Strings.isNullOrEmpty((String)username)) {
            throw new IllegalArgumentException("Username cannot be null or empty");
        }
        if (Strings.isNullOrEmpty((String)password)) {
            throw new IllegalArgumentException("Password cannot be null or empty");
        }
        return PasswordCheckVerification.create(username, SensitiveString.of(password), this.executorService).toCompletableFuture();
    }

    public CompletableFuture<PasswordCheckResult> verify(PasswordCheckVerification verification, byte[] reEncryptedLookupHash, Collection<byte[]> encryptedLeakMatchPrefixList) {
        return verification.verify(reEncryptedLookupHash, encryptedLeakMatchPrefixList, this.executorService).toCompletableFuture();
    }
}

