/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.recaptcha.passwordcheck.utils;

import com.google.auto.value.AutoValue;
import com.google.cloud.recaptcha.passwordcheck.utils.AutoValue_BitPrefix;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.Immutable;
import java.math.BigInteger;

@Immutable
@AutoValue
public abstract class BitPrefix {
    abstract BigInteger bigInteger();

    public abstract int length();

    public static BitPrefix of(byte[] fullBytes, int prefixLength) {
        Preconditions.checkArgument((fullBytes.length * 8 >= prefixLength ? 1 : 0) != 0);
        return new AutoValue_BitPrefix(new BigInteger(1, fullBytes).shiftRight(fullBytes.length * 8 - prefixLength), prefixLength);
    }

    public BitPrefix truncate(int prefixLength) {
        Preconditions.checkArgument((this.length() >= prefixLength ? 1 : 0) != 0);
        return new AutoValue_BitPrefix(this.bigInteger().shiftRight(this.length() - prefixLength), prefixLength);
    }

    public BitPrefix expand(int prefixLength, boolean fillBit) {
        Preconditions.checkArgument((prefixLength >= this.length() ? 1 : 0) != 0);
        BigInteger expandedBigInt = this.bigInteger().shiftLeft(prefixLength - this.length());
        if (fillBit) {
            BigInteger bitMask = BigInteger.ONE.shiftLeft(prefixLength - this.length()).subtract(BigInteger.ONE);
            expandedBigInt = expandedBigInt.or(bitMask);
        }
        return new AutoValue_BitPrefix(expandedBigInt, prefixLength);
    }

    public byte[] toByteArray() {
        return this.toByteArray(false);
    }

    public byte[] toByteArray(boolean fillBit) {
        return this.toByteArray((this.length() + 8 - 1) / 8, fillBit);
    }

    public byte[] toByteArray(int arrayLength, boolean fillBit) {
        Preconditions.checkArgument((arrayLength >= (this.length() + 8 - 1) / 8 ? 1 : 0) != 0, (Object)"arrayLength is not allowed to be shorter than the prefix.");
        byte[] result = new byte[arrayLength];
        byte[] bytes = this.expand(arrayLength * 8, fillBit).bigInteger().toByteArray();
        int bytesContentLength = bytes[0] == 0 ? bytes.length - 1 : bytes.length;
        System.arraycopy(bytes, bytes.length - bytesContentLength, result, arrayLength - bytesContentLength, bytesContentLength);
        return result;
    }

    public final String toString() {
        if (this.length() == 0) {
            return "Empty prefix";
        }
        String s = this.bigInteger().toString(2);
        StringBuilder builder = new StringBuilder("0b");
        for (int i = 0; i < this.length() - s.length(); ++i) {
            builder.append('0');
        }
        builder.append(s);
        return builder.toString();
    }
}

