/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.recaptcha.passwordcheck.utils;

import com.google.cloud.recaptcha.passwordcheck.utils.BitPrefix;
import com.google.cloud.recaptcha.passwordcheck.utils.EmailAddress;
import com.google.cloud.recaptcha.passwordcheck.utils.MessageStrippingException;
import com.google.cloud.recaptcha.passwordcheck.utils.ScryptGenerator;
import com.google.cloud.recaptcha.passwordcheck.utils.SensitiveString;
import com.google.common.base.Ascii;
import com.google.common.hash.Hashing;
import com.google.common.math.IntMath;
import com.google.common.primitives.Bytes;
import com.google.privacy.encryption.commutative.EcCommutativeCipher;
import java.nio.charset.StandardCharsets;

public abstract class CryptoHelper {
    private static final int SCRYPT_PASSWORD_HASH_CPU_MEM_COST = IntMath.pow((int)2, (int)12);
    private static final int SCRYPT_PASSWORD_HASH_BLOCK_SIZE = 8;
    private static final int SCRYPT_PASSWORD_HASH_PARALLELIZATION = 1;
    private static final int SCRYPT_PASSWORD_HASH_KEY_LENGTH = 32;
    private static final byte[] PASSWORD_HASH_CONSTANT_SALT = new byte[]{48, 118, 42, -46, 63, 123, -95, -101, -8, -29, 66, -4, -95, -89, -115, 6, -26, 107, -28, -37, -72, 79, -127, 83, -59, 3, -56, -37, -67, -34, -91, 32};
    private static final byte[] USERNAME_HASH_CONSTANT_SALT = new byte[]{-60, -108, -93, -107, -8, -64, -30, 62, -87, 35, 4, 120, 112, 44, 114, 24, 86, 84, -103, -77, -23, 33, 24, 108, 33, 26, 1, 34, 60, 69, 74, -6};

    public static byte[] hashUsername(String canonicalizedUsername) {
        return Hashing.sha256().hashBytes(Bytes.concat((byte[][])new byte[][]{canonicalizedUsername.getBytes(StandardCharsets.UTF_8), USERNAME_HASH_CONSTANT_SALT})).asBytes();
    }

    public static byte[] hashUsernamePasswordPair(String canonicalizedUsername, SensitiveString password, ScryptGenerator scryptGenerator) {
        byte[] usernameBytes = canonicalizedUsername.getBytes(StandardCharsets.UTF_8);
        try {
            return scryptGenerator.generate(Bytes.concat((byte[][])new byte[][]{usernameBytes, password.getValue().getBytes(StandardCharsets.UTF_8)}), Bytes.concat((byte[][])new byte[][]{usernameBytes, PASSWORD_HASH_CONSTANT_SALT}), SCRYPT_PASSWORD_HASH_CPU_MEM_COST, 8, 1, 32);
        }
        catch (Throwable e) {
            throw new MessageStrippingException("Computing the password hash failed.", e);
        }
    }

    public static String canonicalizeUsername(String username) {
        EmailAddress emailAddress = new EmailAddress(username);
        if (emailAddress.isValid()) {
            username = emailAddress.getUser();
        }
        return Ascii.toLowerCase((String)username.replace(".", ""));
    }

    public static byte[] canonicalizeAndHashUsername(String username) {
        String canonicalizeUsername = CryptoHelper.canonicalizeUsername(username);
        return CryptoHelper.hashUsername(canonicalizeUsername);
    }

    public static byte[] hashBlindedHash(byte[] blindedHash) {
        return Hashing.sha256().hashBytes(blindedHash).asBytes();
    }

    public static byte[] encryptLookupHash(EcCommutativeCipher cipher, byte[] lookupHash) {
        return cipher.encrypt(lookupHash);
    }

    public static byte[] computeEncryptedLookupHash(String canonicalizedUsername, SensitiveString password, EcCommutativeCipher cipher, ScryptGenerator scryptGenerator) {
        return cipher.encrypt(CryptoHelper.hashUsernamePasswordPair(canonicalizedUsername, password, scryptGenerator));
    }

    public static byte[] decryptReencryptedLookupHash(byte[] reencryptedLookupHash, EcCommutativeCipher cipher) {
        return CryptoHelper.hashBlindedHash(cipher.decrypt(reencryptedLookupHash));
    }

    public static byte[] bucketizeUsername(String canonicalizedUsername, int allowedUsernameHashPrefixLength) {
        return BitPrefix.of(CryptoHelper.hashUsername(canonicalizedUsername), allowedUsernameHashPrefixLength).toByteArray();
    }
}

