/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.recaptcha.passwordcheck.utils;

import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Set;

public final class MessageStrippingException
extends RuntimeException {
    public MessageStrippingException(String message, Throwable cause) {
        super(message + "\nOriginal stack trace:\n" + MessageStrippingException.extractOriginalStackTrace(cause));
    }

    private static String extractOriginalStackTrace(Throwable cause) {
        StringBuilder stackTrace = new StringBuilder();
        MessageStrippingException.addStackTrace(cause, Sets.newHashSet(), stackTrace, "");
        return stackTrace.toString();
    }

    private static void addStackTrace(Throwable cause, Set<Throwable> alreadySeen, StringBuilder stackTrace, String indent) {
        Throwable currentThrowable = cause;
        while (currentThrowable != null) {
            stackTrace.append(currentThrowable.getClass().getName());
            if (!alreadySeen.add(currentThrowable)) break;
            for (StackTraceElement stackTraceElement : currentThrowable.getStackTrace()) {
                stackTrace.append('\n').append(indent).append('\t').append(stackTraceElement);
            }
            for (Serializable serializable : currentThrowable.getSuppressed()) {
                stackTrace.append('\n').append(indent).append('\t').append("Suppressed: ");
                MessageStrippingException.addStackTrace((Throwable)serializable, alreadySeen, stackTrace, indent + "\t");
            }
            if ((currentThrowable = currentThrowable.getCause()) == null) continue;
            stackTrace.append('\n').append(indent).append("Caused by: ");
        }
    }
}

