/*
 * Decompiled with CFR 0.152.
 */
package com.google.privacy.encryption.commutative;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.Immutable;
import com.google.privacy.encryption.commutative.EcCommutativeCipherBase;
import com.google.privacy.encryption.commutative.SupportedCurve;
import java.math.BigInteger;
import java.security.interfaces.ECPrivateKey;
import java.security.spec.ECPoint;
import java.security.spec.InvalidKeySpecException;
import org.bouncycastle.asn1.sec.SECNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.params.ECNamedDomainParameters;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECFieldElement;

@Immutable
public final class EcCommutativeCipher
extends EcCommutativeCipherBase {
    private final ECNamedDomainParameters domainParams;

    private static ECNamedDomainParameters getDomainParams(SupportedCurve curve) {
        String curveName = curve.getCurveName();
        X9ECParameters ecParams = SECNamedCurves.getByName((String)curveName);
        return new ECNamedDomainParameters(SECNamedCurves.getOID((String)curveName), ecParams.getCurve(), ecParams.getG(), ecParams.getN(), ecParams.getH(), ecParams.getSeed());
    }

    private EcCommutativeCipher(EcCommutativeCipherBase.HashType hashType, ECPrivateKey key, SupportedCurve ecCurve) {
        super(hashType, key, ecCurve);
        this.domainParams = EcCommutativeCipher.getDomainParams(ecCurve);
    }

    public static EcCommutativeCipher createWithNewKey(SupportedCurve curve, EcCommutativeCipherBase.HashType hashType) {
        return new EcCommutativeCipher(hashType, EcCommutativeCipher.createPrivateKey(curve), curve);
    }

    public static EcCommutativeCipher createWithNewKey(SupportedCurve curve) {
        return EcCommutativeCipher.createWithNewKey(curve, EcCommutativeCipherBase.HashType.SHA256);
    }

    public static EcCommutativeCipher createFromKey(SupportedCurve curve, EcCommutativeCipherBase.HashType hashType, byte[] keyBytes) {
        try {
            BigInteger key = EcCommutativeCipher.byteArrayToBigIntegerCppCompatible(keyBytes);
            return new EcCommutativeCipher(hashType, EcCommutativeCipher.decodePrivateKey(key, curve), curve);
        }
        catch (InvalidKeySpecException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public static EcCommutativeCipher createFromKey(SupportedCurve curve, byte[] keyBytes) {
        return EcCommutativeCipher.createFromKey(curve, EcCommutativeCipherBase.HashType.SHA256, keyBytes);
    }

    public static boolean validateCiphertext(byte[] ciphertext, SupportedCurve supportedCurve) {
        try {
            org.bouncycastle.math.ec.ECPoint point = EcCommutativeCipher.getDomainParams(supportedCurve).getCurve().decodePoint(ciphertext);
            return point.isValid() && !point.isInfinity();
        }
        catch (IllegalArgumentException ignored) {
            return false;
        }
    }

    @Override
    protected ECPoint hashIntoTheCurveInternal(byte[] byteId) {
        ECCurve ecCurve = this.domainParams.getCurve();
        ECFieldElement a = ecCurve.getA();
        ECFieldElement b = ecCurve.getB();
        BigInteger p = ((ECCurve.Fp)ecCurve).getQ();
        BigInteger x = EcCommutativeCipher.randomOracle(byteId, p, this.hashType);
        while (true) {
            ECFieldElement fieldX;
            ECFieldElement y2;
            ECFieldElement y2Sqrt;
            if ((y2Sqrt = (y2 = (fieldX = ecCurve.fromBigInteger(x)).multiply(fieldX.square().add(a)).add(b)).sqrt()) != null) {
                if (y2Sqrt.toBigInteger().testBit(0)) {
                    return new ECPoint(fieldX.toBigInteger(), y2Sqrt.negate().toBigInteger());
                }
                return new ECPoint(fieldX.toBigInteger(), y2Sqrt.toBigInteger());
            }
            x = EcCommutativeCipher.randomOracle(EcCommutativeCipher.bigIntegerToByteArrayCppCompatible(x), p, this.hashType);
        }
    }

    @Override
    public byte[] hashIntoTheCurve(byte[] byteId) {
        return this.convertECPoint(this.hashIntoTheCurveInternal(byteId)).getEncoded(true);
    }

    private byte[] encrypt(org.bouncycastle.math.ec.ECPoint point) {
        return point.multiply(this.privateKey.getS()).getEncoded(true);
    }

    @Override
    public byte[] encrypt(byte[] plaintext) {
        ECPoint point = this.hashIntoTheCurveInternal(plaintext);
        return this.encrypt(this.convertECPoint(point));
    }

    @Override
    public byte[] reEncrypt(byte[] ciphertext) {
        org.bouncycastle.math.ec.ECPoint point = this.checkPointOnCurve(ciphertext);
        return this.encrypt(point);
    }

    @Override
    public byte[] decrypt(byte[] ciphertext) {
        org.bouncycastle.math.ec.ECPoint point = this.checkPointOnCurve(ciphertext);
        BigInteger privateKeyInverse = this.privateKey.getS().modInverse(this.privateKey.getParams().getOrder());
        return point.multiply(privateKeyInverse).getEncoded(true);
    }

    private org.bouncycastle.math.ec.ECPoint checkPointOnCurve(byte[] compressedPoint) {
        org.bouncycastle.math.ec.ECPoint point = this.domainParams.getCurve().decodePoint(compressedPoint);
        Preconditions.checkArgument((boolean)point.isValid(), (Object)"Invalid point: the point is not on the curve");
        Preconditions.checkArgument((!point.isInfinity() ? 1 : 0) != 0, (Object)"Invalid point: the point is at infinity");
        return point;
    }

    @Override
    protected byte[] getEncoded(ECPoint point) {
        return this.convertECPoint(point).getEncoded(true);
    }

    @Override
    protected boolean isValid(ECPoint point) {
        return this.convertECPoint(point).isValid();
    }

    @Override
    protected boolean isInfinity(ECPoint point) {
        return this.convertECPoint(point).isInfinity();
    }

    private org.bouncycastle.math.ec.ECPoint convertECPoint(ECPoint point) {
        return this.domainParams.getCurve().createPoint(point.getAffineX(), point.getAffineY());
    }
}

