/*
 * Decompiled with CFR 0.152.
 */
package com.google.privacy.encryption.commutative;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.hash.Hashing;
import com.google.common.primitives.Bytes;
import com.google.errorprone.annotations.Immutable;
import com.google.privacy.encryption.commutative.SupportedCurve;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.ECPrivateKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.InvalidKeySpecException;

@Immutable
public abstract class EcCommutativeCipherBase {
    protected final ECPrivateKey privateKey;
    protected final SupportedCurve ecCurve;
    protected final HashType hashType;

    protected EcCommutativeCipherBase(HashType hashType, ECPrivateKey key, SupportedCurve ecCurve) {
        this.privateKey = key;
        this.ecCurve = ecCurve;
        this.hashType = hashType;
    }

    protected static ECPrivateKey decodePrivateKey(BigInteger key, SupportedCurve curve) throws InvalidKeySpecException {
        EcCommutativeCipherBase.checkPrivateKey(key, curve.getParameterSpec());
        ECPrivateKeySpec privateKeySpec = new ECPrivateKeySpec(key, curve.getParameterSpec());
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("EC");
            return (ECPrivateKey)keyFactory.generatePrivate(privateKeySpec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    protected static ECPrivateKey createPrivateKey(SupportedCurve curve) {
        try {
            KeyPairGenerator generator = KeyPairGenerator.getInstance("EC");
            generator.initialize(curve.getParameterSpec(), new SecureRandom());
            return (ECPrivateKey)generator.generateKeyPair().getPrivate();
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    public abstract byte[] encrypt(byte[] var1);

    public abstract byte[] reEncrypt(byte[] var1);

    public abstract byte[] decrypt(byte[] var1);

    @VisibleForTesting
    abstract ECPoint hashIntoTheCurveInternal(byte[] var1);

    public abstract byte[] hashIntoTheCurve(byte[] var1);

    public static BigInteger randomOracle(byte[] bytes, BigInteger maxValue, HashType hashType) {
        int hashBitLength = hashType.getHashBitLength();
        int outputBitLength = maxValue.bitLength() + hashBitLength;
        int iterCount = (outputBitLength + hashBitLength - 1) / hashBitLength;
        int excessBitCount = iterCount * hashBitLength - outputBitLength;
        BigInteger hashOutput = BigInteger.ZERO;
        BigInteger counter = BigInteger.ONE;
        for (int i = 1; i < iterCount + 1; ++i) {
            byte[] hashCode;
            hashOutput = hashOutput.shiftLeft(hashBitLength);
            byte[] counterBytes = EcCommutativeCipherBase.bigIntegerToByteArrayCppCompatible(counter);
            byte[] hashInput = Bytes.concat((byte[][])new byte[][]{counterBytes, bytes});
            switch (hashType) {
                case SHA256: {
                    hashCode = Hashing.sha256().hashBytes(hashInput).asBytes();
                    break;
                }
                case SHA384: {
                    hashCode = Hashing.sha384().hashBytes(hashInput).asBytes();
                    break;
                }
                default: {
                    hashCode = Hashing.sha512().hashBytes(hashInput).asBytes();
                }
            }
            hashOutput = hashOutput.add(EcCommutativeCipherBase.byteArrayToBigIntegerCppCompatible(hashCode));
            counter = counter.add(BigInteger.ONE);
        }
        return hashOutput.shiftRight(excessBitCount).mod(maxValue);
    }

    private static void checkPrivateKey(BigInteger key, ECParameterSpec params) {
        if (key.compareTo(BigInteger.ONE) <= 0 || key.compareTo(params.getOrder()) >= 0) {
            throw new IllegalArgumentException("The given key is out of bounds.");
        }
    }

    public byte[] getPrivateKeyBytes() {
        return EcCommutativeCipherBase.bigIntegerToByteArrayCppCompatible(this.privateKey.getS());
    }

    public static byte[] bigIntegerToByteArrayCppCompatible(BigInteger value) {
        byte[] signedArray = value.toByteArray();
        int leadingZeroes = 0;
        while (signedArray[leadingZeroes] == 0) {
            ++leadingZeroes;
        }
        byte[] unsignedArray = new byte[signedArray.length - leadingZeroes];
        System.arraycopy(signedArray, leadingZeroes, unsignedArray, 0, unsignedArray.length);
        return unsignedArray;
    }

    public static BigInteger byteArrayToBigIntegerCppCompatible(byte[] bytes) {
        byte[] twosComplement = new byte[bytes.length + 1];
        twosComplement[0] = 0;
        System.arraycopy(bytes, 0, twosComplement, 1, bytes.length);
        return new BigInteger(twosComplement);
    }

    @VisibleForTesting
    abstract byte[] getEncoded(ECPoint var1);

    @VisibleForTesting
    abstract boolean isValid(ECPoint var1);

    @VisibleForTesting
    abstract boolean isInfinity(ECPoint var1);

    public static enum HashType {
        SHA256(256),
        SHA384(384),
        SHA512(512);

        private final int hashBitLength;

        private HashType(int hashBitLength) {
            this.hashBitLength = hashBitLength;
        }

        public int getHashBitLength() {
            return this.hashBitLength;
        }
    }
}

