/*
 * Decompiled with CFR 0.152.
 */
package com.google.privacy.encryption.commutative;

import java.security.AlgorithmParameters;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;

public enum SupportedCurve {
    SECP256R1("secp256r1"),
    SECP384R1("secp384r1");

    private final ECParameterSpec parameterSpec;
    private final ECGenParameterSpec genParameterSpec;
    private final String curveName;

    private SupportedCurve(String curveName) {
        try {
            AlgorithmParameters parameters = AlgorithmParameters.getInstance("EC");
            parameters.init(new ECGenParameterSpec(curveName));
            this.parameterSpec = parameters.getParameterSpec(ECParameterSpec.class);
            this.genParameterSpec = new ECGenParameterSpec(curveName);
            this.curveName = curveName;
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    public ECGenParameterSpec getGenParameterSpec() {
        return this.genParameterSpec;
    }

    public ECParameterSpec getParameterSpec() {
        return this.parameterSpec;
    }

    public String getCurveName() {
        return this.curveName;
    }
}

