/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.data.datastore.repository.query;

import com.google.cloud.datastore.Cursor;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class DatastorePageable
extends PageRequest {
    private final String urlSafeCursor;
    private final Long totalCount;

    private DatastorePageable(Pageable pageable, String urlSafeCursor, Long totalCount) {
        super(pageable.getPageNumber(), pageable.getPageSize(), pageable.getSort());
        this.urlSafeCursor = urlSafeCursor;
        this.totalCount = totalCount;
    }

    DatastorePageable(Pageable pageable, Cursor cursor, Long totalCount) {
        this(pageable, cursor.toUrlSafe(), totalCount);
    }

    public static Pageable from(Pageable pageable, Cursor cursor, Long totalCount) {
        return DatastorePageable.from(pageable, cursor == null ? null : cursor.toUrlSafe(), totalCount);
    }

    public static Pageable from(Pageable pageable, String urlSafeCursor, Long totalCount) {
        if (pageable.isUnpaged()) {
            return pageable;
        }
        return new DatastorePageable(pageable, urlSafeCursor, totalCount);
    }

    public String getUrlSafeCursor() {
        return this.urlSafeCursor;
    }

    public PageRequest next() {
        PageRequest nextPage = PageRequest.of((int)(this.getPageNumber() + 1), (int)this.getPageSize(), (Sort)this.getSort());
        return (PageRequest)DatastorePageable.from((Pageable)nextPage, this.urlSafeCursor, this.totalCount);
    }

    public Cursor toCursor() {
        return this.urlSafeCursor == null ? null : Cursor.fromUrlSafe((String)this.urlSafeCursor);
    }

    public Long getTotalCount() {
        return this.totalCount;
    }
}

