/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.data.firestore.mapping;

import com.google.cloud.Timestamp;
import com.google.cloud.firestore.DocumentSnapshot;
import com.google.cloud.firestore.FirestoreOptions;
import com.google.cloud.firestore.Internal;
import com.google.cloud.spring.core.util.MapBuilder;
import com.google.cloud.spring.data.firestore.mapping.FirestoreClassMapper;
import com.google.cloud.spring.data.firestore.mapping.FirestoreMappingContext;
import com.google.cloud.spring.data.firestore.mapping.FirestorePersistentEntity;
import com.google.cloud.spring.data.firestore.mapping.FirestorePersistentProperty;
import com.google.firestore.v1.Document;
import com.google.firestore.v1.Value;
import java.util.Map;
import java.util.Objects;
import org.springframework.data.mapping.PersistentProperty;

public final class FirestoreDefaultClassMapper
implements FirestoreClassMapper {
    private static final Internal INTERNAL = new Internal(((FirestoreOptions.Builder)FirestoreOptions.newBuilder().setProjectId("dummy-project-id")).build(), null);
    private static final String VALUE_FIELD_NAME = "value";
    private static final String NOT_USED_PATH = "/not/used/path";
    private FirestoreMappingContext mappingContext;

    public FirestoreDefaultClassMapper(FirestoreMappingContext mappingContext) {
        this.mappingContext = mappingContext;
    }

    @Override
    public <T> Value toFirestoreValue(T sourceValue) {
        DocumentSnapshot documentSnapshot = INTERNAL.snapshotFromMap(NOT_USED_PATH, new MapBuilder().put((Object)VALUE_FIELD_NAME, sourceValue).build());
        return (Value)INTERNAL.protoFromSnapshot(documentSnapshot).get(VALUE_FIELD_NAME);
    }

    @Override
    public <T> Document entityToDocument(T entity, String documentResourceName) {
        DocumentSnapshot documentSnapshot = INTERNAL.snapshotFromObject(NOT_USED_PATH, entity);
        return Document.newBuilder().putAllFields(this.removeUpdateTimestamp(INTERNAL.protoFromSnapshot(documentSnapshot), entity)).setName(documentResourceName).build();
    }

    @Override
    public <T> T documentToEntity(Document document, Class<T> clazz) {
        DocumentSnapshot documentSnapshot = INTERNAL.snapshotFromProto(Timestamp.now(), document);
        Object entity = documentSnapshot.toObject(clazz);
        return (T)this.setUpdateTime(entity, documentSnapshot.getUpdateTime());
    }

    @Override
    public <T> T setUpdateTime(T entity, Timestamp updateTime) {
        FirestorePersistentEntity persistentEntity = (FirestorePersistentEntity)this.mappingContext.getPersistentEntity(entity.getClass());
        FirestorePersistentProperty updateTimeProperty = Objects.requireNonNull(persistentEntity).getUpdateTimeProperty();
        if (updateTimeProperty != null) {
            persistentEntity.getPropertyAccessor(entity).setProperty((PersistentProperty)updateTimeProperty, (Object)updateTime);
        }
        return entity;
    }

    private Map<String, Value> removeUpdateTimestamp(Map<String, Value> valuesMap, Object entity) {
        FirestorePersistentEntity persistentEntity = (FirestorePersistentEntity)this.mappingContext.getPersistentEntity(entity.getClass());
        FirestorePersistentProperty updateTimeProperty = Objects.requireNonNull(persistentEntity).getUpdateTimeProperty();
        if (updateTimeProperty != null) {
            valuesMap.remove(updateTimeProperty.getFieldName());
        }
        return valuesMap;
    }
}

