/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.data.firestore.repository.support;

import com.google.cloud.spring.data.firestore.FirestoreTemplate;
import com.google.cloud.spring.data.firestore.repository.query.FirestoreQueryMethod;
import com.google.cloud.spring.data.firestore.repository.query.PartTreeFirestoreQuery;
import java.lang.reflect.Method;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.RepositoryQuery;

public class FirestoreQueryLookupStrategy
implements QueryLookupStrategy {
    private final FirestoreTemplate firestoreTemplate;

    public FirestoreQueryLookupStrategy(FirestoreTemplate firestoreTemplate) {
        this.firestoreTemplate = firestoreTemplate;
    }

    public RepositoryQuery resolveQuery(Method method, RepositoryMetadata repositoryMetadata, ProjectionFactory projectionFactory, NamedQueries namedQueries) {
        return new PartTreeFirestoreQuery(new FirestoreQueryMethod(method, repositoryMetadata, projectionFactory), this.firestoreTemplate, this.firestoreTemplate.getMappingContext(), this.firestoreTemplate.getClassMapper());
    }
}

