/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.data.firestore.transaction;

import com.google.cloud.Timestamp;
import com.google.cloud.spring.data.firestore.mapping.FirestoreClassMapper;
import com.google.cloud.spring.data.firestore.transaction.ReactiveFirestoreResourceHolder;
import com.google.cloud.spring.data.firestore.util.ObservableReactiveUtil;
import com.google.cloud.spring.data.firestore.util.Util;
import com.google.firestore.v1.BeginTransactionRequest;
import com.google.firestore.v1.CommitRequest;
import com.google.firestore.v1.FirestoreGrpc;
import com.google.firestore.v1.RollbackRequest;
import com.google.firestore.v1.TransactionOptions;
import com.google.protobuf.ByteString;
import org.springframework.lang.Nullable;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.reactive.AbstractReactiveTransactionManager;
import org.springframework.transaction.reactive.GenericReactiveTransaction;
import org.springframework.transaction.reactive.TransactionSynchronizationManager;
import org.springframework.transaction.support.SmartTransactionObject;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public class ReactiveFirestoreTransactionManager
extends AbstractReactiveTransactionManager {
    private final FirestoreGrpc.FirestoreStub firestore;
    private final String databasePath;
    private FirestoreClassMapper classMapper;

    public ReactiveFirestoreTransactionManager(FirestoreGrpc.FirestoreStub firestore, String parent, FirestoreClassMapper classMapper) {
        this.firestore = firestore;
        this.databasePath = Util.extractDatabasePath(parent);
        this.classMapper = classMapper;
    }

    protected Object doGetTransaction(TransactionSynchronizationManager synchronizationManager) throws TransactionException {
        ReactiveFirestoreResourceHolder resourceHolder = (ReactiveFirestoreResourceHolder)((Object)synchronizationManager.getResource((Object)this.firestore));
        return new ReactiveFirestoreTransactionObject(resourceHolder);
    }

    protected Mono<Void> doBegin(TransactionSynchronizationManager synchronizationManager, Object transactionObject, TransactionDefinition transactionDefinition) throws TransactionException {
        return Mono.defer(() -> {
            Mono<ReactiveFirestoreResourceHolder> holder = this.startTransaction(transactionDefinition);
            return holder.doOnNext(ReactiveFirestoreTransactionManager.extractFirestoreTransaction(transactionObject)::setResourceHolder).onErrorMap(ex -> new TransactionSystemException("Could not start Firestore transaction", ex)).doOnSuccess(resourceHolder -> synchronizationManager.bindResource((Object)this.firestore, (Object)resourceHolder)).then();
        });
    }

    protected Mono<Void> doCommit(TransactionSynchronizationManager transactionSynchronizationManager, GenericReactiveTransaction genericReactiveTransaction) throws TransactionException {
        return Mono.defer(() -> {
            ReactiveFirestoreResourceHolder resourceHolder = ReactiveFirestoreTransactionManager.extractFirestoreTransaction(genericReactiveTransaction).getResourceHolder();
            CommitRequest.Builder builder = CommitRequest.newBuilder().setDatabase(this.databasePath).setTransaction(resourceHolder.getTransactionId());
            resourceHolder.getWrites().forEach(arg_0 -> ((CommitRequest.Builder)builder).addWrites(arg_0));
            return ObservableReactiveUtil.unaryCall(obs -> this.firestore.commit(builder.build(), obs)).flatMap(response -> {
                for (Object entity : resourceHolder.getEntities()) {
                    this.classMapper.setUpdateTime(entity, Timestamp.fromProto((com.google.protobuf.Timestamp)response.getCommitTime()));
                }
                return Mono.empty();
            });
        });
    }

    protected Mono<Void> doRollback(TransactionSynchronizationManager transactionSynchronizationManager, GenericReactiveTransaction genericReactiveTransaction) throws TransactionException {
        return ObservableReactiveUtil.unaryCall(obs -> this.firestore.rollback(RollbackRequest.newBuilder().setTransaction(ReactiveFirestoreTransactionManager.extractFirestoreTransaction(genericReactiveTransaction).getTransactionId()).setDatabase(this.databasePath).build(), obs)).then();
    }

    private static ReactiveFirestoreTransactionObject extractFirestoreTransaction(Object transaction) {
        Assert.isInstanceOf(ReactiveFirestoreTransactionObject.class, (Object)transaction, () -> String.format("Expected to find a %s but it turned out to be %s.", ReactiveFirestoreTransactionObject.class, transaction.getClass()));
        return (ReactiveFirestoreTransactionObject)transaction;
    }

    private static ReactiveFirestoreTransactionObject extractFirestoreTransaction(GenericReactiveTransaction transaction) {
        Assert.isInstanceOf(ReactiveFirestoreTransactionObject.class, (Object)transaction.getTransaction(), () -> String.format("Expected to find a %s but it turned out to be %s.", ReactiveFirestoreTransactionObject.class, transaction.getTransaction().getClass()));
        return (ReactiveFirestoreTransactionObject)transaction.getTransaction();
    }

    private Mono<ReactiveFirestoreResourceHolder> startTransaction(TransactionDefinition definition) {
        TransactionOptions.Builder txOptions = definition.isReadOnly() ? TransactionOptions.newBuilder().setReadOnly(TransactionOptions.ReadOnly.newBuilder().build()) : TransactionOptions.newBuilder().setReadWrite(TransactionOptions.ReadWrite.newBuilder().build());
        BeginTransactionRequest beginTransactionRequest = BeginTransactionRequest.newBuilder().setOptions(txOptions).setDatabase(this.databasePath).build();
        return ObservableReactiveUtil.unaryCall(obs -> this.firestore.beginTransaction(beginTransactionRequest, obs)).map(beginTransactionResponse -> new ReactiveFirestoreResourceHolder(beginTransactionResponse.getTransaction()));
    }

    private class ReactiveFirestoreTransactionObject
    implements SmartTransactionObject {
        @Nullable
        private ReactiveFirestoreResourceHolder resourceHolder;

        ReactiveFirestoreTransactionObject(ReactiveFirestoreResourceHolder resourceHolder) {
            this.resourceHolder = resourceHolder;
        }

        @Nullable
        public ByteString getTransactionId() {
            return this.resourceHolder != null ? this.resourceHolder.getTransactionId() : null;
        }

        @Nullable
        public ReactiveFirestoreResourceHolder getResourceHolder() {
            return this.resourceHolder;
        }

        public void setResourceHolder(@Nullable ReactiveFirestoreResourceHolder resourceHolder) {
            this.resourceHolder = resourceHolder;
        }

        public boolean isRollbackOnly() {
            return false;
        }

        public void flush() {
        }
    }
}

