/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.data.spanner.core.convert;

import com.google.cloud.ByteArray;
import com.google.cloud.spring.data.spanner.core.convert.SpannerCustomConverter;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.function.Supplier;
import org.springframework.util.Assert;

public final class ConversionUtils {
    private ConversionUtils() {
    }

    static Class boxIfNeeded(Class propertyType) {
        if (propertyType == null) {
            return null;
        }
        return propertyType.isPrimitive() ? Array.get(Array.newInstance(propertyType, 1), 0).getClass() : propertyType;
    }

    public static boolean isIterableNonByteArrayType(Class propType) {
        return Iterable.class.isAssignableFrom(propType) && !ByteArray.class.isAssignableFrom(propType);
    }

    static <T> Iterable<T> convertIterable(Iterable<Object> source, Class<T> targetType, SpannerCustomConverter converter) {
        ArrayList result = new ArrayList();
        source.forEach(item -> result.add(converter.convert(item, targetType)));
        return result;
    }

    public static <T> T wrapSimpleLazyProxy(Supplier<T> supplierFunc, Class<T> type) {
        return (T)Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, new SimpleLazyDynamicInvocationHandler(supplierFunc));
    }

    public static boolean ignoreForWriteLazyProxy(Object object) {
        if (Proxy.isProxyClass(object.getClass()) && Proxy.getInvocationHandler(object) instanceof SimpleLazyDynamicInvocationHandler) {
            SimpleLazyDynamicInvocationHandler handler = (SimpleLazyDynamicInvocationHandler)Proxy.getInvocationHandler(object);
            return !handler.isEvaluated();
        }
        return false;
    }

    private static final class SimpleLazyDynamicInvocationHandler<T>
    implements InvocationHandler {
        private final Supplier<T> supplierFunc;
        private boolean isEvaluated = false;
        private T value;

        private SimpleLazyDynamicInvocationHandler(Supplier<T> supplierFunc) {
            Assert.notNull(supplierFunc, (String)"A non-null supplier function is required for a lazy proxy.");
            this.supplierFunc = supplierFunc;
        }

        private boolean isEvaluated() {
            return this.isEvaluated;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (!this.isEvaluated) {
                this.value = this.supplierFunc.get();
                this.isEvaluated = true;
            }
            return method.invoke(this.value, args);
        }
    }
}

