/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.data.spanner.core.convert;

import com.google.cloud.spanner.Struct;
import com.google.cloud.spring.data.spanner.core.convert.ConversionUtils;
import com.google.cloud.spring.data.spanner.core.convert.SpannerCustomConverter;
import com.google.cloud.spring.data.spanner.core.convert.SpannerEntityReader;
import com.google.cloud.spring.data.spanner.core.convert.StructAccessor;
import com.google.cloud.spring.data.spanner.core.mapping.SpannerDataException;
import com.google.cloud.spring.data.spanner.core.mapping.SpannerPersistentProperty;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.data.mapping.model.PropertyValueProvider;

class StructPropertyValueProvider
implements PropertyValueProvider<SpannerPersistentProperty> {
    private final SpannerCustomConverter readConverter;
    private SpannerEntityReader entityReader;
    private StructAccessor structAccessor;
    private boolean allowMissingColumns;

    StructPropertyValueProvider(StructAccessor structAccessor, SpannerCustomConverter readConverter, SpannerEntityReader entityReader) {
        this(structAccessor, readConverter, entityReader, false);
    }

    StructPropertyValueProvider(StructAccessor structAccessor, SpannerCustomConverter readConverter, SpannerEntityReader entityReader, boolean allowMissingColumns) {
        this.structAccessor = structAccessor;
        this.readConverter = readConverter;
        this.entityReader = entityReader;
        this.allowMissingColumns = allowMissingColumns;
    }

    public <T> T getPropertyValue(SpannerPersistentProperty spannerPersistentProperty) {
        Iterable<T> value;
        String colName = spannerPersistentProperty.getColumnName();
        if (!this.structAccessor.hasColumn(colName)) {
            throw new SpannerDataException("Column not found: " + colName);
        }
        if (this.structAccessor.isNull(colName)) {
            return null;
        }
        Class propType = spannerPersistentProperty.getType();
        Iterable<T> iterable = value = ConversionUtils.isIterableNonByteArrayType(propType) ? this.readIterableWithConversion(spannerPersistentProperty) : this.readSingleWithConversion(spannerPersistentProperty);
        if (value == null) {
            throw new SpannerDataException(String.format("The value in column with name %s could not be converted to the corresponding property in the entity. The property's type is %s.", colName, propType));
        }
        return (T)value;
    }

    private <T> T readSingleWithConversion(SpannerPersistentProperty spannerPersistentProperty) {
        String colName = spannerPersistentProperty.getColumnName();
        Object value = this.structAccessor.getSingleValue(colName);
        return value != null ? (T)this.convertOrRead(spannerPersistentProperty.getType(), value) : null;
    }

    private <T> Iterable<T> readIterableWithConversion(SpannerPersistentProperty spannerPersistentProperty) {
        String colName = spannerPersistentProperty.getColumnName();
        List listValue = this.structAccessor.getListValue(colName);
        return listValue.stream().map(item -> this.convertOrRead(spannerPersistentProperty.getColumnInnerType(), item)).collect(Collectors.toList());
    }

    private <T> T convertOrRead(Class<T> targetType, Object sourceValue) {
        Class<?> sourceClass = sourceValue.getClass();
        return Struct.class.isAssignableFrom(sourceClass) && !this.readConverter.canConvert(sourceClass, targetType) ? this.entityReader.read(targetType, (Struct)sourceValue, null, this.allowMissingColumns) : this.readConverter.convert(sourceValue, targetType);
    }
}

