/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.data.spanner.core.mapping;

import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.Type;
import com.google.cloud.spring.data.spanner.core.convert.SpannerTypeMapper;
import com.google.cloud.spring.data.spanner.core.mapping.SpannerPersistentEntity;
import com.google.cloud.spring.data.spanner.core.mapping.SpannerPersistentProperty;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.OptionalInt;
import java.util.OptionalLong;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class SpannerCompositeKeyProperty
implements SpannerPersistentProperty {
    private final SpannerPersistentEntity<?> spannerPersistentEntity;
    private final SpannerPersistentProperty[] primaryKeyColumns;

    public SpannerCompositeKeyProperty(SpannerPersistentEntity spannerPersistentEntity, SpannerPersistentProperty[] primaryKeyColumns) {
        Assert.notNull((Object)spannerPersistentEntity, (String)"A valid Cloud Spanner persistent entity is required.");
        Assert.notNull((Object)primaryKeyColumns, (String)"A valid array of primary key properties is required.");
        this.primaryKeyColumns = primaryKeyColumns;
        this.spannerPersistentEntity = spannerPersistentEntity;
    }

    Key getId(Object entity) {
        PersistentPropertyAccessor accessor = this.getOwner().getPropertyAccessor(entity);
        ArrayList<Object> keyParts = new ArrayList<Object>();
        for (SpannerPersistentProperty spannerPersistentProperty : this.primaryKeyColumns) {
            Object value = accessor.getProperty((PersistentProperty)spannerPersistentProperty);
            if (spannerPersistentProperty.isEmbedded()) {
                Key embeddedKeyParts = ((SpannerPersistentEntity)this.spannerPersistentEntity.getSpannerMappingContext().getPersistentEntity(spannerPersistentProperty.getType())).getIdProperty().getId(value);
                for (Object keyPart : embeddedKeyParts.getParts()) {
                    keyParts.add(keyPart);
                }
                continue;
            }
            if (spannerPersistentProperty.getAnnotatedColumnItemType() == null || value == null) {
                keyParts.add(value);
                continue;
            }
            keyParts.add(this.spannerPersistentEntity.getSpannerEntityProcessor().getSpannerWriteConverter().convert(value, SpannerTypeMapper.getSimpleJavaClassFor(spannerPersistentProperty.getAnnotatedColumnItemType())));
        }
        return this.spannerPersistentEntity.getSpannerEntityProcessor().convertToKey(keyParts);
    }

    @Override
    public String getColumnName() {
        return null;
    }

    public Class getColumnInnerType() {
        return null;
    }

    @Override
    public OptionalInt getPrimaryKeyOrder() {
        return null;
    }

    @Override
    public boolean isMapped() {
        return false;
    }

    @Override
    public boolean isEmbedded() {
        return false;
    }

    @Override
    public boolean isInterleaved() {
        return false;
    }

    @Override
    public boolean isGenerateSchemaNotNull() {
        return false;
    }

    @Override
    public boolean isCommitTimestamp() {
        return false;
    }

    @Override
    public Type.Code getAnnotatedColumnItemType() {
        return null;
    }

    @Override
    public boolean isLazyInterleaved() {
        return false;
    }

    @Override
    public boolean isEagerInterleaved() {
        return false;
    }

    @Override
    public String getWhere() {
        return "";
    }

    @Override
    public boolean hasWhere() {
        return false;
    }

    @Override
    public OptionalLong getMaxColumnLength() {
        return OptionalLong.empty();
    }

    public PersistentEntity<?, SpannerPersistentProperty> getOwner() {
        return this.spannerPersistentEntity;
    }

    public String getName() {
        return null;
    }

    public Class<?> getType() {
        return this.primaryKeyColumns.length == 1 ? this.primaryKeyColumns[0].getActualType() : Key.class;
    }

    public TypeInformation<?> getTypeInformation() {
        return ClassTypeInformation.from(this.getType());
    }

    public Iterable<? extends TypeInformation<?>> getPersistentEntityTypes() {
        return Collections.emptySet();
    }

    @Nullable
    public Method getGetter() {
        return null;
    }

    @Nullable
    public Method getSetter() {
        return null;
    }

    @Nullable
    public Field getField() {
        return null;
    }

    @Nullable
    public String getSpelExpression() {
        return null;
    }

    @Nullable
    public Association<SpannerPersistentProperty> getAssociation() {
        return null;
    }

    public boolean isEntity() {
        return false;
    }

    public boolean isIdProperty() {
        return true;
    }

    public boolean isVersionProperty() {
        return false;
    }

    public boolean isCollectionLike() {
        return false;
    }

    public boolean isMap() {
        return false;
    }

    public boolean isArray() {
        return false;
    }

    public boolean isTransient() {
        return false;
    }

    public boolean isWritable() {
        return false;
    }

    public boolean isAssociation() {
        return false;
    }

    @Nullable
    public Class<?> getComponentType() {
        return null;
    }

    public Class<?> getRawType() {
        return this.getType();
    }

    @Nullable
    public Class<?> getMapValueType() {
        return null;
    }

    public Class<?> getActualType() {
        return this.getType();
    }

    @Nullable
    public <A extends Annotation> A findAnnotation(Class<A> annotationType) {
        return null;
    }

    @Nullable
    public <A extends Annotation> A findPropertyOrOwnerAnnotation(Class<A> annotationType) {
        return null;
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return false;
    }

    public boolean usePropertyAccess() {
        return false;
    }

    public Class<?> getAssociationTargetType() {
        return null;
    }

    public boolean isImmutable() {
        return false;
    }

    public Method getWither() {
        return null;
    }
}

