/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.data.spanner.repository.support;

import com.google.cloud.spring.data.spanner.core.SpannerTemplate;
import com.google.cloud.spring.data.spanner.core.mapping.SpannerMappingContext;
import com.google.cloud.spring.data.spanner.repository.support.SpannerRepositoryFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.support.RepositoryFactoryBeanSupport;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;

public class SpannerRepositoryFactoryBean<T extends Repository<S, ID>, S, ID>
extends RepositoryFactoryBeanSupport<T, S, ID>
implements ApplicationContextAware {
    private SpannerMappingContext spannerMappingContext;
    private SpannerTemplate spannerTemplate;
    private ApplicationContext applicationContext;

    SpannerRepositoryFactoryBean(Class<T> repositoryInterface) {
        super(repositoryInterface);
    }

    public void setSpannerTemplate(SpannerTemplate spannerTemplate) {
        this.spannerTemplate = spannerTemplate;
    }

    public void setSpannerMappingContext(SpannerMappingContext mappingContext) {
        super.setMappingContext((MappingContext)mappingContext);
        this.spannerMappingContext = mappingContext;
    }

    protected RepositoryFactorySupport createRepositoryFactory() {
        SpannerRepositoryFactory spannerRepositoryFactory = new SpannerRepositoryFactory(this.spannerMappingContext, this.spannerTemplate);
        spannerRepositoryFactory.setApplicationContext(this.applicationContext);
        return spannerRepositoryFactory;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

