/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.data.spanner.core.mapping;

import com.google.cloud.spring.data.spanner.core.convert.ConverterAwareMappingSpannerEntityProcessor;
import com.google.cloud.spring.data.spanner.core.convert.SpannerEntityProcessor;
import com.google.cloud.spring.data.spanner.core.mapping.SpannerDataException;
import com.google.cloud.spring.data.spanner.core.mapping.SpannerPersistentEntity;
import com.google.cloud.spring.data.spanner.core.mapping.SpannerPersistentEntityImpl;
import com.google.cloud.spring.data.spanner.core.mapping.SpannerPersistentProperty;
import com.google.cloud.spring.data.spanner.core.mapping.SpannerPersistentPropertyImpl;
import com.google.gson.Gson;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.context.AbstractMappingContext;
import org.springframework.data.mapping.model.FieldNamingStrategy;
import org.springframework.data.mapping.model.Property;
import org.springframework.data.mapping.model.PropertyNameFieldNamingStrategy;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public class SpannerMappingContext
extends AbstractMappingContext<SpannerPersistentEntity<?>, SpannerPersistentProperty>
implements ApplicationContextAware {
    private static final FieldNamingStrategy DEFAULT_NAMING_STRATEGY = PropertyNameFieldNamingStrategy.INSTANCE;
    private FieldNamingStrategy fieldNamingStrategy = DEFAULT_NAMING_STRATEGY;
    private ApplicationContext applicationContext;
    private Gson gson;

    public SpannerMappingContext() {
    }

    public SpannerMappingContext(Gson gson) {
        Assert.notNull((Object)gson, (String)"A non-null gson is required.");
        this.gson = gson;
    }

    @NonNull
    public Gson getGson() {
        return this.gson;
    }

    public void setFieldNamingStrategy(FieldNamingStrategy fieldNamingStrategy) {
        this.fieldNamingStrategy = fieldNamingStrategy != null ? fieldNamingStrategy : DEFAULT_NAMING_STRATEGY;
    }

    public FieldNamingStrategy getFieldNamingStrategy() {
        return this.fieldNamingStrategy;
    }

    protected <T> SpannerPersistentEntity<T> createPersistentEntity(TypeInformation<T> typeInformation) {
        SpannerPersistentEntityImpl<T> persistentEntity = this.constructPersistentEntity(typeInformation);
        if (this.applicationContext != null) {
            persistentEntity.setApplicationContext(this.applicationContext);
        }
        return persistentEntity;
    }

    protected <T> SpannerPersistentEntityImpl<T> constructPersistentEntity(TypeInformation<T> typeInformation) {
        SpannerEntityProcessor processor = this.applicationContext == null || !this.applicationContext.containsBean("spannerConverter") ? new ConverterAwareMappingSpannerEntityProcessor(this) : (SpannerEntityProcessor)this.applicationContext.getBean(SpannerEntityProcessor.class);
        return new SpannerPersistentEntityImpl<T>(typeInformation, this, processor);
    }

    protected SpannerPersistentProperty createPersistentProperty(Property property, SpannerPersistentEntity<?> owner, SimpleTypeHolder simpleTypeHolder) {
        return new SpannerPersistentPropertyImpl(property, (PersistentEntity<?, SpannerPersistentProperty>)owner, simpleTypeHolder, this.fieldNamingStrategy);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public SpannerPersistentEntity<?> getPersistentEntityOrFail(Class<?> entityClass) {
        SpannerPersistentEntity entity = (SpannerPersistentEntity)super.getPersistentEntity(entityClass);
        if (entity == null) {
            throw new SpannerDataException("The provided entity class cannot be converted to a Spanner Entity: " + entityClass);
        }
        return entity;
    }
}

