/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.logging.extensions;

import ch.qos.logback.classic.spi.ILoggingEvent;
import com.google.cloud.logging.LogEntry;
import com.google.cloud.logging.logback.LoggingEventEnhancer;
import com.google.cloud.spring.logging.JsonLoggingEventEnhancer;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.logstash.logback.marker.ObjectAppendingMarker;
import org.slf4j.Marker;

public class LogstashLoggingEventEnhancer
implements LoggingEventEnhancer,
JsonLoggingEventEnhancer {
    public void enhanceLogEntry(LogEntry.Builder builder, ILoggingEvent event) {
        this.addLogstashMarkerIfNecessary(this.getFirstMarker(event.getMarkerList()), marker -> builder.addLabel(marker.getFieldName(), marker.getFieldValue().toString()));
    }

    @Override
    public void enhanceJsonLogEntry(Map<String, Object> jsonMap, ILoggingEvent event) {
        this.addLogstashMarkerIfNecessary(this.getFirstMarker(event.getMarkerList()), marker -> jsonMap.put(marker.getFieldName(), marker.getFieldValue()));
    }

    private Marker getFirstMarker(List<Marker> markers) {
        return markers == null || markers.isEmpty() ? null : markers.get(0);
    }

    private void addLogstashMarkerIfNecessary(Marker marker, Consumer<ObjectAppendingMarker> markerAdderFunction) {
        if (marker == null) {
            return;
        }
        if (marker instanceof ObjectAppendingMarker) {
            ObjectAppendingMarker objectAppendingMarker = (ObjectAppendingMarker)marker;
            markerAdderFunction.accept(objectAppendingMarker);
        }
        if (marker.hasReferences()) {
            for (Marker next : marker) {
                this.addLogstashMarkerIfNecessary(next, markerAdderFunction);
            }
        }
    }
}

