/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.logging;

import com.google.cloud.spring.logging.TraceIdLoggingEnhancer;
import com.google.cloud.spring.logging.extractors.TraceIdExtractor;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.util.Assert;
import org.springframework.web.servlet.HandlerInterceptor;

public class TraceIdLoggingWebMvcInterceptor
implements HandlerInterceptor {
    private final TraceIdExtractor traceIdExtractor;

    public TraceIdLoggingWebMvcInterceptor(TraceIdExtractor extractor) {
        Assert.notNull((Object)extractor, (String)"A valid trace id extractor is required.");
        this.traceIdExtractor = extractor;
    }

    public TraceIdExtractor getTraceIdExtractor() {
        return this.traceIdExtractor;
    }

    public boolean preHandle(HttpServletRequest req, HttpServletResponse resp, Object handler) {
        String traceId = this.traceIdExtractor.extractTraceIdFromRequest(req);
        if (traceId != null) {
            TraceIdLoggingEnhancer.setCurrentTraceId(traceId);
        }
        return true;
    }

    public void afterCompletion(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object handler, Exception e) {
        TraceIdLoggingEnhancer.setCurrentTraceId(null);
    }
}

