/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.vision;

import com.google.cloud.spring.vision.CloudVisionException;
import com.google.cloud.vision.v1.AnnotateImageRequest;
import com.google.cloud.vision.v1.AnnotateImageResponse;
import com.google.cloud.vision.v1.BatchAnnotateImagesRequest;
import com.google.cloud.vision.v1.BatchAnnotateImagesResponse;
import com.google.cloud.vision.v1.Feature;
import com.google.cloud.vision.v1.Image;
import com.google.cloud.vision.v1.ImageAnnotatorClient;
import com.google.cloud.vision.v1.ImageContext;
import com.google.protobuf.ByteString;
import com.google.rpc.Code;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class CloudVisionTemplate {
    private final ImageAnnotatorClient imageAnnotatorClient;

    public CloudVisionTemplate(ImageAnnotatorClient imageAnnotatorClient) {
        Assert.notNull((Object)imageAnnotatorClient, (String)"imageAnnotatorClient must not be null.");
        this.imageAnnotatorClient = imageAnnotatorClient;
    }

    public String extractTextFromImage(Resource imageResource) {
        return this.extractTextFromImage(imageResource, ImageContext.getDefaultInstance());
    }

    public String extractTextFromImage(Resource imageResource, ImageContext imageContext) {
        AnnotateImageResponse response = this.analyzeImage(imageResource, imageContext, Feature.Type.TEXT_DETECTION);
        String result = response.getFullTextAnnotation().getText();
        if (result.isEmpty() && response.getError().getCode() != Code.OK.getNumber()) {
            throw new CloudVisionException(response.getError().getMessage());
        }
        return result;
    }

    public AnnotateImageResponse analyzeImage(Resource imageResource, Feature.Type ... featureTypes) {
        return this.analyzeImage(imageResource, ImageContext.getDefaultInstance(), featureTypes);
    }

    public AnnotateImageResponse analyzeImage(Resource imageResource, ImageContext imageContext, Feature.Type ... featureTypes) {
        ByteString imgBytes;
        try {
            imgBytes = ByteString.readFrom((InputStream)imageResource.getInputStream());
        }
        catch (IOException ex) {
            throw new CloudVisionException("Failed to read image bytes from provided resource.", ex);
        }
        Image image = Image.newBuilder().setContent(imgBytes).build();
        List featureList = Arrays.stream(featureTypes).map(featureType -> Feature.newBuilder().setType(featureType).build()).collect(Collectors.toList());
        BatchAnnotateImagesRequest request = BatchAnnotateImagesRequest.newBuilder().addRequests(AnnotateImageRequest.newBuilder().addAllFeatures(featureList).setImageContext(imageContext).setImage(image)).build();
        BatchAnnotateImagesResponse batchResponse = this.imageAnnotatorClient.batchAnnotateImages(request);
        List annotateImageResponses = batchResponse.getResponsesList();
        if (!annotateImageResponses.isEmpty()) {
            return (AnnotateImageResponse)annotateImageResponses.get(0);
        }
        throw new CloudVisionException("Failed to receive valid response Vision APIs; empty response received.");
    }
}

