/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.proto.streamio;

import com.google.code.proto.streamio.IPBStreamReaderCallback;
import com.google.code.proto.streamio.PBWireByteMarkerHelper;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.GeneratedMessage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PBStreamReader<T extends GeneratedMessage> {
    protected boolean finishedReadingStream = false;
    protected Logger log = Logger.getLogger(this.getClass().getName());
    protected final PBWireByteMarkerHelper gpbWireByteMarkerHelper;
    protected ReadWriteLock lock = new ReentrantReadWriteLock();

    public <T> PBStreamReader() {
        this.gpbWireByteMarkerHelper = new PBWireByteMarkerHelper();
    }

    public <T> PBStreamReader(PBWireByteMarkerHelper pbWireByteMarkerHelper) {
        this.gpbWireByteMarkerHelper = pbWireByteMarkerHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setFinishedReadingStream(boolean finished) {
        try {
            this.lock.writeLock().lock();
            this.finishedReadingStream = finished;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean getFinishedReadingStream() {
        try {
            this.lock.readLock().lock();
            boolean bl = this.finishedReadingStream;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    protected byte[] readUntilNextStartMarker(InputStream inStream, byte[] remnant, int bufferSize, byte startByte, byte[] byteMarker, int byteMarkerSize) throws IOException {
        int bufferTrimPos;
        byte[] buffer;
        int sum;
        block15: {
            this.log.log(Level.FINEST, "readUntilNextStartMarker");
            if (byteMarker == null || byteMarker.length != byteMarkerSize) {
                this.log.log(Level.SEVERE, "size of byteMarker must be equal to byteMarkerSize");
                throw new IllegalArgumentException("size of byteMarker must be equal to byteMarkerSize");
            }
            int nRead = 0;
            sum = 0;
            if (remnant != null && remnant.length > 0) {
                sum = remnant.length;
                buffer = new byte[bufferSize += remnant.length];
                System.arraycopy(remnant, 0, buffer, 0, sum);
                remnant = null;
            } else {
                buffer = new byte[bufferSize];
            }
            while (sum < bufferSize && nRead != -1) {
                nRead = inStream.read(buffer, sum, bufferSize - sum);
                if (nRead == -1) continue;
                sum += nRead;
            }
            if (nRead == -1) {
                this.setFinishedReadingStream(true);
                this.log.log(Level.FINEST, "end of stream");
            } else {
                this.log.log(Level.FINEST, "read {0} bytes from remnant and input stream", sum);
            }
            if (sum > 0 && sum < byteMarkerSize) {
                throw new IOException("stream has ended and we only read " + sum + " bytes but needed to find " + byteMarkerSize + " bytes for the byte marker");
            }
            int matchStartPos = -1;
            int markerBytesFound = 0;
            bufferTrimPos = 0;
            boolean foundMarker = false;
            boolean foundStartByte = false;
            if (sum > 0 && !foundMarker) {
                for (int i = 0; i < sum; ++i) {
                    if (!foundStartByte && buffer[i] == startByte) {
                        foundStartByte = true;
                        matchStartPos = i;
                    } else if (foundStartByte) {
                        ++markerBytesFound;
                    }
                    if (!foundStartByte || markerBytesFound != byteMarkerSize) continue;
                    foundMarker = true;
                    foundStartByte = false;
                    bufferTrimPos = i + 1;
                    System.arraycopy(buffer, matchStartPos + 1, byteMarker, 0, byteMarkerSize);
                    break block15;
                }
                throw new IOException("leading byte marker was not found in stream after reading " + bufferSize + " bytes");
            }
        }
        if (sum > 0) {
            int start;
            int n = start = bufferTrimPos < sum ? bufferTrimPos : sum;
            if (remnant != null) {
                byte[] remn = new byte[remnant.length + sum];
                System.arraycopy(remnant, 0, remn, 0, remnant.length);
                System.arraycopy(remnant, remnant.length, buffer, start, sum - start);
                remnant = remn;
            } else {
                remnant = Arrays.copyOfRange(buffer, start, sum);
            }
        }
        return remnant;
    }

    public void read(InputStream inStream, AbstractMessage.Builder messageBuilder, IPBStreamReaderCallback callback) throws IOException, InstantiationException, IllegalAccessException {
        this.readFromStream(inStream, messageBuilder, callback);
    }

    public List<T> read(InputStream inStream, AbstractMessage.Builder messageBuilder) throws IOException, InstantiationException, IllegalAccessException {
        return this.readFromStream(inStream, messageBuilder, null);
    }

    protected List<T> readFromStream(InputStream inStream, AbstractMessage.Builder messageBuilder, IPBStreamReaderCallback callback) throws IOException, InstantiationException, IllegalAccessException {
        this.log.log(Level.INFO, "read");
        ArrayList<GeneratedMessage> results = new ArrayList<GeneratedMessage>();
        int bufferSizeForMarkerReads = 256;
        byte[] remnant = null;
        while (!this.getFinishedReadingStream() || remnant != null && remnant.length > 0) {
            byte[] remn;
            PBStreamReader pBStreamReader = this;
            byte[] byteMarker = new byte[pBStreamReader.gpbWireByteMarkerHelper.getByteMarkerSize()];
            PBStreamReader pBStreamReader2 = this;
            remnant = this.readUntilNextStartMarker(inStream, remnant, bufferSizeForMarkerReads, pBStreamReader2.gpbWireByteMarkerHelper.getMarkerForStart(), byteMarker, byteMarker.length);
            int messageLength = PBWireByteMarkerHelper.bytesToInteger(byteMarker);
            this.log.log(Level.FINEST, "reading an event of length = {0}", messageLength);
            if (messageLength == 0) {
                this.setFinishedReadingStream(true);
                continue;
            }
            while (remnant.length < messageLength) {
                byte[] bytes = new byte[bufferSizeForMarkerReads];
                int nRead = inStream.read(bytes);
                if (nRead == -1) {
                    this.setFinishedReadingStream(true);
                    continue;
                }
                int sz = remnant.length + nRead;
                remn = new byte[sz];
                System.arraycopy(remnant, 0, remn, 0, remnant.length);
                System.arraycopy(bytes, 0, remn, remnant.length, nRead);
                remnant = remn;
            }
            byte[] messageBytes = new byte[messageLength];
            System.arraycopy(remnant, 0, messageBytes, 0, messageLength);
            CodedInputStream codedInStream = CodedInputStream.newInstance((byte[])messageBytes);
            messageBuilder.mergeFrom(codedInStream);
            GeneratedMessage msg = (GeneratedMessage)messageBuilder.build();
            this.log.log(Level.FINE, "read serialized message: {0}", new Object[]{msg.toString()});
            if (callback != null) {
                callback.handleDeserializedMessage(msg);
            } else {
                results.add(msg);
            }
            messageBuilder.clear();
            if (remnant.length == messageLength) {
                remnant = null;
                continue;
            }
            remn = Arrays.copyOfRange(remnant, messageLength, remnant.length);
            remnant = remn;
        }
        if (callback == null) {
            this.log.log(Level.FINE, "read {0} results", new Object[]{Integer.toString(results.size())});
        }
        return results;
    }
}

