/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.proto.streamio;

import com.google.code.proto.streamio.PBWireByteMarkerHelper;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.GeneratedMessage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PBStreamWriter {
    public static void writeToStream(OutputStream out, List<? extends GeneratedMessage> messages) throws IOException {
        PBStreamWriter.writeToStream(out, messages, new PBWireByteMarkerHelper());
    }

    public static void writeToStream(OutputStream out, List<? extends GeneratedMessage> messages, PBWireByteMarkerHelper gpbWireByteMarkerHelper) throws IOException {
        for (GeneratedMessage generatedMessage : messages) {
            byte[] delimiter = PBWireByteMarkerHelper.createMessageDelimiter(generatedMessage);
            out.write(delimiter);
            CodedOutputStream cos = CodedOutputStream.newInstance((OutputStream)out);
            generatedMessage.writeTo(cos);
            cos.flush();
            out.flush();
            Logger.getLogger(PBStreamWriter.class.getName()).log(Level.FINEST, " Wrote {0} bytes to stream + {1} bytes for delimeter", new Object[]{Integer.toString(generatedMessage.getSerializedSize()), Integer.toString(delimiter.length)});
        }
    }
}

