/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.proto.streamio;

import com.google.protobuf.GeneratedMessage;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PBWireByteMarkerHelper {
    private static final byte markerForStart = -128;
    private static int byteMarkerSize = 4;
    private static int delimiterSize = byteMarkerSize + 1;

    public static int getByteMarkerSize() {
        return byteMarkerSize;
    }

    public static int getDelimiterSize() {
        return delimiterSize;
    }

    public static byte getMarkerForStart() {
        return -128;
    }

    public static int estimateTotalContentLength(List<? extends GeneratedMessage> messages) {
        int sum = 0;
        for (GeneratedMessage generatedMessage : messages) {
            int messageSize = generatedMessage.getSerializedSize();
            Logger.getLogger(PBWireByteMarkerHelper.class.getName()).log(Level.FINEST, "size of a message = {0}", Integer.toString(messageSize));
            sum += messageSize + delimiterSize;
        }
        return sum;
    }

    public static byte[] createMessageDelimiter(GeneratedMessage message) {
        Integer sz = message.getSerializedSize();
        byte[] szInBytes = PBWireByteMarkerHelper.integerTo4ByteBigEndian(sz);
        byte[] delimeter = new byte[delimiterSize];
        delimeter[0] = -128;
        System.arraycopy(szInBytes, 0, delimeter, 1, 4);
        return delimeter;
    }

    static byte[] integerTo4ByteBigEndian(int sz) {
        byte[] marker = new byte[4];
        int a00 = sz & 0xFF;
        int a08 = (sz >>= 8) & 0xFF;
        int a16 = (sz >>= 8) & 0xFF;
        int a24 = (sz >>= 8) & 0xFF;
        byte b00 = a00 >= 0 && a00 < 128 ? (byte)a00 : (byte)(a00 - 256);
        byte b08 = a08 >= 0 && a08 < 128 ? (byte)a08 : (byte)(a08 - 256);
        byte b16 = a16 >= 0 && a16 < 128 ? (byte)a16 : (byte)(a16 - 256);
        byte b24 = a24 >= 0 && a24 < 128 ? (byte)a24 : (byte)(a24 - 256);
        marker[0] = b00;
        marker[1] = b08;
        marker[2] = b16;
        marker[3] = b24;
        return marker;
    }

    static int bytesToInteger(byte[] marker) {
        int b00 = marker[0];
        int b08 = marker[1];
        int b16 = marker[2];
        int b24 = marker[3];
        int d00 = b00 >= 0 && b00 < 128 ? b00 : 256 + b00;
        int d08 = b08 >= 0 && b08 < 128 ? b08 : 256 + b08;
        d08 = (d08 & 0xFF) << 8;
        int d16 = b16 >= 0 && b16 < 128 ? b16 : 256 + b16;
        d16 = (d16 & 0xFF) << 16;
        int d24 = b24 >= 0 && b24 < 128 ? b24 : 256 + b24;
        d24 = (d24 & 0xFF) << 24;
        int total = d00 + d08 + d16 + d24;
        return total;
    }
}

