/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.proto.streamio;

import com.google.code.proto.streamio.IPBWireByteMarkerHelper;
import com.google.code.proto.streamio.PBWireSignedByteMarkerHelper;
import com.google.protobuf.GeneratedMessage;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractPBWireByteMarkerHelper
implements IPBWireByteMarkerHelper {
    protected final byte markerForStart = 0;
    protected int byteMarkerSize = 4;
    protected int delimiterSize = this.byteMarkerSize + 1;

    @Override
    public abstract int bytesToInteger(byte[] var1);

    @Override
    public abstract byte[] integerToBytesBigEndian(int var1);

    @Override
    public byte[] createMessageDelimiter(GeneratedMessage message) {
        Integer sz = message.getSerializedSize();
        byte[] szInBytes = this.integerToBytesBigEndian(sz);
        byte[] delimeter = new byte[this.delimiterSize];
        delimeter[0] = 0;
        System.arraycopy(szInBytes, 0, delimeter, 1, this.byteMarkerSize);
        return delimeter;
    }

    @Override
    public int estimateTotalContentLength(List<? extends GeneratedMessage> messages) {
        int sum = 0;
        for (GeneratedMessage generatedMessage : messages) {
            int messageSize = generatedMessage.getSerializedSize();
            Logger.getLogger(PBWireSignedByteMarkerHelper.class.getName()).log(Level.FINEST, "size of a message = {0}", Integer.toString(messageSize));
            sum += messageSize + this.delimiterSize;
        }
        return sum;
    }

    @Override
    public int getByteMarkerSize() {
        return this.byteMarkerSize;
    }

    @Override
    public int getDelimiterSize() {
        return this.delimiterSize;
    }

    @Override
    public byte getMarkerForStart() {
        return 0;
    }
}

