/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.proto.streamio;

import com.google.code.proto.streamio.ByteOption;
import com.google.code.proto.streamio.PBWireUnsignedByteMarkerHelper;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.GeneratedMessage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.logging.Logger;

public class PBStreamWriter {
    private static Logger log = Logger.getLogger(PBStreamWriter.class.getName());

    public static void writeToStream(OutputStream out, List<? extends GeneratedMessage> messages) throws IOException {
        PBStreamWriter.writeToStream(out, messages, ByteOption.UNSIGNED);
    }

    public static void writeToStream(OutputStream out, List<? extends GeneratedMessage> messages, ByteOption byteOption) throws IOException {
        PBWireUnsignedByteMarkerHelper gpbWireByteMarkerHelper = null;
        gpbWireByteMarkerHelper = byteOption == null || byteOption.ordinal() == ByteOption.UNSIGNED.ordinal() ? new PBWireUnsignedByteMarkerHelper() : new PBWireUnsignedByteMarkerHelper();
        int count = 1;
        for (GeneratedMessage generatedMessage : messages) {
            byte[] delimiter = gpbWireByteMarkerHelper.createMessageDelimiter(generatedMessage);
            out.write(delimiter);
            CodedOutputStream cos = CodedOutputStream.newInstance((OutputStream)out);
            generatedMessage.writeTo(cos);
            cos.flush();
            out.flush();
            ++count;
        }
    }
}

