/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.proto.streamio;

import com.google.code.proto.streamio.AbstractPBWireByteMarkerHelper;

public class PBWireUnsignedByteMarkerHelper
extends AbstractPBWireByteMarkerHelper {
    @Override
    public byte[] integerToBytesBigEndian(int sz) {
        byte[] marker = new byte[this.byteMarkerSize];
        for (int i = 0; i < marker.length; ++i) {
            byte b;
            int shift = i * 7;
            int a = sz >> shift & 0x7F;
            marker[i] = b = (byte)a;
        }
        return marker;
    }

    @Override
    public int bytesToInteger(byte[] marker) {
        int total = 0;
        for (int i = 0; i < marker.length; ++i) {
            int b = marker[i];
            if (b > 127) {
                throw new IllegalArgumentException("byte marker contains a value less than 0 which is not allowed");
            }
            int d = b;
            int shift = i * 7;
            d = (d & 0x7F) << shift;
            total += d;
        }
        if ((double)total > Math.pow(2.0, 8 * this.byteMarkerSize - 1)) {
            throw new IllegalArgumentException("the value sz exceeds the max holdable in these byte markers");
        }
        return total;
    }
}

